/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema.models;

import com.integ.supporter.cinema.models.MacroAction;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Random;

public class MacroActionNode {
    private final PropertyChangeSupport _propertyChangeSupport = new PropertyChangeSupport(this);
    public final MacroAction _macroAction;
    private int _timing;
    private final int _instanceHash = new Random().nextInt() & 0xFFFFFFFF;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public MacroActionNode(MacroAction macroAction, int timing) {
        this._macroAction = macroAction;
        this._timing = timing;
    }

    public int getTimingSeconds() {
        return this._timing;
    }

    public String getTiming() {
        int minutes = this._timing / 60;
        int seconds = this._timing % 60;
        return String.format("%d:%02d", minutes, seconds);
    }

    public void setTiming(int seconds) {
        int oldValue = this.getTimingSeconds();
        this._timing = seconds;
        this._propertyChangeSupport.firePropertyChange("Timing", oldValue, seconds);
    }

    public String toString() {
        return this._macroAction.getName();
    }

    public MacroAction getMacroAction() {
        return this._macroAction;
    }

    public String getName() {
        return this._macroAction.getName();
    }

    public String getDescription() {
        return this._macroAction.getDescription();
    }

    public boolean equals(Object obj) {
        MacroActionNode macroActionNodeToCompare = (MacroActionNode)obj;
        if (!this._macroAction.equals(macroActionNodeToCompare._macroAction)) {
            return false;
        }
        return this._timing == macroActionNodeToCompare.getTimingSeconds();
    }

    public int hashCode() {
        return this._instanceHash;
    }

    public MacroActionNode clone() {
        MacroActionNode macroActionNode = new MacroActionNode(this._macroAction.clone(), this._timing);
        return macroActionNode;
    }
}

