/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.net.beacon.JniorVersion;
import com.integ.janoslib.utils.StringUtils;
import java.util.ArrayList;
import java.util.Date;

public class JniorItem {
    private JniorInfo _jniorInfo;
    private boolean _hovered = false;

    public JniorItem(JniorInfo jniorInfo) {
        this._jniorInfo = jniorInfo;
    }

    public boolean isHovered() {
        return this._hovered;
    }

    public void setHovered(boolean hovered) {
        this._hovered = hovered;
    }

    public String getSerialNumberString() {
        return String.valueOf(this._jniorInfo.getSerialNumber());
    }

    public int getSerialNumber() {
        return this._jniorInfo.getSerialNumber();
    }

    public String getModel() {
        return this._jniorInfo.Model;
    }

    public String getHostname() {
        return this._jniorInfo.Hostname;
    }

    public String getIpAddress() {
        return this._jniorInfo.IpAddress;
    }

    public String getSubnetMask() {
        return this._jniorInfo.SubnetMask;
    }

    public String getPhysicalAddress() {
        return this._jniorInfo.PhysicalAddress;
    }

    public JniorVersion getOsVersion() {
        return this._jniorInfo.OsVersion;
    }

    public JniorVersion getFullOsVersion() {
        return this._jniorInfo.FullOsVersion;
    }

    public Date getLastAnnounced() {
        return this._jniorInfo.LastAnnounced;
    }

    public Date getBootTime() {
        return this._jniorInfo.BootTime;
    }

    public String getMessages() {
        ArrayList<String> messagesArrayList = new ArrayList<String>();
        if (0 != this._jniorInfo.AttentionInfo) {
            String string;
            if (0 != (this._jniorInfo.AttentionInfo & 1)) {
                messagesArrayList.add("Assertion occurred");
            }
            if (0 != (this._jniorInfo.AttentionInfo & 2)) {
                string = "Errors file exists";
                if (null != this._jniorInfo.getErrorsModified()) {
                    string = String.format("%s (%s)", string, this._jniorInfo.getErrorsModified());
                }
                messagesArrayList.add(string);
            }
            if (0 != (this._jniorInfo.AttentionInfo & 4)) {
                messagesArrayList.add("Memory test failed during boot");
            }
            if (0 != (this._jniorInfo.AttentionInfo & 8)) {
                messagesArrayList.add("SRAM was reformatted on boot");
            }
            if (0 != (this._jniorInfo.AttentionInfo & 0x10)) {
                messagesArrayList.add("FLASH file system was not mounted");
            }
            if (0 != (this._jniorInfo.AttentionInfo & 0x20)) {
                string = "Dump file exists";
                if (null != this._jniorInfo.getDumpModified()) {
                    string = String.format("%s (%s)", string, this._jniorInfo.getDumpModified());
                }
                messagesArrayList.add(string);
            }
            if (0 != (this._jniorInfo.AttentionInfo & 0x40)) {
                messagesArrayList.add("Some applications could not start");
            }
            if (0 != (this._jniorInfo.AttentionInfo & 0x100)) {
                messagesArrayList.add("Getting Network Capture");
            }
        }
        String[] messagesArray = messagesArrayList.toArray(new String[messagesArrayList.size()]);
        String messageString = StringUtils.join(messagesArray, ", ");
        return messageString;
    }

    public JniorInfo getJniorInfo() {
        return this._jniorInfo;
    }

    public void update(JniorInfo jniorInfo) {
        this._jniorInfo = jniorInfo;
    }
}

