/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.dialogs;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFormattedTextField;

public class IPAddressFormattedTextField
extends JFormattedTextField {
    private static final String IPADDRESS_PATTERN = "^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.)?(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.)?(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.)?([01]?\\d\\d?|2[0-4]\\d|25[0-5])?$";

    public IPAddressFormattedTextField() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                IPAddressFormattedTextField.this.selectAll();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if ('.' != e.getKeyChar() && !Character.isDigit(e.getKeyChar())) {
                    e.consume();
                    return;
                }
                StringBuilder text = new StringBuilder(IPAddressFormattedTextField.this.getText());
                int caretPos = IPAddressFormattedTextField.this.getCaretPosition();
                text.insert(caretPos, e.getKeyChar());
                Pattern pattern = Pattern.compile(IPAddressFormattedTextField.IPADDRESS_PATTERN);
                Matcher matcher = pattern.matcher(text);
                if (!matcher.matches()) {
                    if ('.' != e.getKeyChar() && 4 > text.toString().split(".").length) {
                        text.insert(caretPos, '.');
                        matcher = pattern.matcher(text);
                        if (matcher.matches()) {
                            IPAddressFormattedTextField.this.setText(text.toString());
                        }
                    }
                    e.consume();
                }
            }
        });
    }
}

