/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.parser;

import com.github.weisj.jsvg.parser.ResourceLoader;
import com.github.weisj.jsvg.parser.SwingUIFuture;
import com.github.weisj.jsvg.parser.UIFuture;
import com.github.weisj.jsvg.parser.resources.RenderableResource;
import com.github.weisj.jsvg.util.ResourceUtil;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public final class AsynchronousResourceLoader
implements ResourceLoader {
    private static final Logger LOGGER = Logger.getLogger(AsynchronousResourceLoader.class.getName());

    @Override
    @NotNull
    public UIFuture<RenderableResource> loadImage(@NotNull URI uri) {
        return new SwingUIFuture<RenderableResource>(() -> {
            try {
                return ResourceUtil.loadImage(uri);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                return null;
            }
        });
    }
}

