/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema.models;

import com.integ.supporter.cinema.devices.CinemaDevice;
import com.integ.supporter.cinema.models.MacroAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import javax.swing.table.AbstractTableModel;

public class MacroActionModel
extends AbstractTableModel {
    protected static String[] ColumnNames = new String[]{"Name", "Device", "Action", " Data"};
    protected static Class[] ClassTypes = new Class[]{String.class, String.class, String.class, String.class};
    private final LinkedHashMap<String, CinemaDevice> _knownDevices;
    private ArrayList<MacroAction> _macroActions = new ArrayList();

    public MacroActionModel(LinkedHashMap<String, CinemaDevice> knownDevices) {
        this._knownDevices = knownDevices;
    }

    public void setMacroActions(MacroAction[] macroActionsArray) {
        Collections.addAll(this._macroActions, macroActionsArray);
    }

    public void addMacroAction(MacroAction macroAction) {
        this._macroActions.add(macroAction);
        super.fireTableDataChanged();
    }

    public void removeMacroAction(MacroAction macroAction) {
        this._macroActions.remove(macroAction);
        super.fireTableDataChanged();
    }

    public void setMacroActions(ArrayList<MacroAction> macroActions) {
        this._macroActions = macroActions;
    }

    public ArrayList<MacroAction> getMacroActions() {
        return this._macroActions;
    }

    public MacroAction getMacroActionAtRow(int row) {
        return this._macroActions.get(row);
    }

    public int getRowForMacroAction(MacroAction macroAction) {
        return this._macroActions.indexOf(macroAction);
    }

    @Override
    public int getRowCount() {
        return this._macroActions.size();
    }

    @Override
    public int getColumnCount() {
        return ColumnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return ColumnNames[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MacroAction macroAction = this._macroActions.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return macroAction.getName();
            }
            case 1: {
                CinemaDevice cinemaDevice = macroAction.getDevice();
                if (null != cinemaDevice) {
                    return cinemaDevice;
                }
                return macroAction.getDeviceName();
            }
            case 2: {
                return macroAction.getAction();
            }
            case 3: {
                return macroAction.getData();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        MacroAction macroAction = this._macroActions.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                macroAction.setName((String)value);
                this.fireTableCellUpdated(rowIndex, columnIndex);
                break;
            }
            case 1: {
                CinemaDevice oldDevice = macroAction.getDevice();
                System.out.println("old value = " + oldDevice);
                System.out.println("new value = " + value);
                if (value instanceof CinemaDevice) {
                    CinemaDevice cinemaDevice = (CinemaDevice)value;
                    macroAction.setDevice(cinemaDevice);
                    macroAction.setDeviceName(cinemaDevice.getName());
                    if (null != oldDevice && null != cinemaDevice && !oldDevice.getClass().equals(cinemaDevice.getClass())) {
                        macroAction.setAction("");
                        macroAction.setData("");
                    }
                } else if (value instanceof String) {
                    macroAction.setDeviceName((String)value);
                }
                this.fireTableCellUpdated(rowIndex, columnIndex);
                break;
            }
            case 2: {
                macroAction.setAction((String)value);
                this.fireTableCellUpdated(rowIndex, columnIndex);
                break;
            }
            case 3: {
                macroAction.setData((String)value);
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public void moveMacroActionNode(MacroAction macroAction, int direction) {
        int macroNodeIndex = this._macroActions.indexOf(macroAction);
        this._macroActions.remove(macroAction);
        this._macroActions.add(macroNodeIndex + direction, macroAction);
        if (direction < 0) {
            this.fireTableRowsUpdated(macroNodeIndex - 1, macroNodeIndex);
        } else {
            this.fireTableRowsUpdated(macroNodeIndex, macroNodeIndex + 1);
        }
    }

    public int getSize() {
        return this._macroActions.size();
    }
}

