/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema.models;

import com.integ.supporter.cinema.models.MacroActionNode;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Random;

public class MacroNode {
    private final int _instanceHash = new Random().nextInt() & 0xFFFFFFFF;
    private final PropertyChangeSupport _propertyChangeSupport = new PropertyChangeSupport(this);
    private String _name;
    private final ArrayList<MacroActionNode> _macroActionNodes = new ArrayList();

    public int hashCode() {
        return this._instanceHash;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MacroNode macroNodeToCompareTo = (MacroNode)obj;
        if (!this.getName().equals(macroNodeToCompareTo.getName())) {
            return false;
        }
        if (this.getMacroActionNodes().size() != macroNodeToCompareTo.getMacroActionNodes().size()) {
            return false;
        }
        for (int i = 0; i < this.getMacroActionNodes().size(); ++i) {
            MacroActionNode macroActionNodeToCompareTo;
            MacroActionNode macroActionNode = this.getMacroActionNodes().get(i);
            if (macroActionNode.equals(macroActionNodeToCompareTo = macroNodeToCompareTo.getMacroActionNodes().get(i))) continue;
            return false;
        }
        return true;
    }

    public MacroNode clone() {
        MacroNode clone = new MacroNode(this.getName());
        for (MacroActionNode macroActionNode : this.getMacroActionNodes()) {
            clone.addMacroAction(macroActionNode.clone());
        }
        return clone;
    }

    public MacroNode(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    void setName(String name) {
        this._name = name;
        String oldValue = this.getName();
        this._name = name;
        this._propertyChangeSupport.firePropertyChange("Name", oldValue, name);
    }

    public void addMacroAction(MacroActionNode macroActionNode) {
        Object oldValue = this._macroActionNodes.clone();
        this._macroActionNodes.add(macroActionNode);
        this._propertyChangeSupport.firePropertyChange("MacroAction", oldValue, this._macroActionNodes);
    }

    public ArrayList<MacroActionNode> getMacroActionNodes() {
        return this._macroActionNodes;
    }

    public void removeMacroAction(MacroActionNode macroActionNode) {
        this._macroActionNodes.remove(macroActionNode);
    }

    public String toString() {
        return this._name;
    }

    public void sort() {
        this._macroActionNodes.sort((man1, man2) -> {
            if (man1.getTimingSeconds() < man2.getTimingSeconds()) {
                return -1;
            }
            if (man1.getTimingSeconds() > man2.getTimingSeconds()) {
                return 1;
            }
            return 0;
        });
    }
}

