/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.net.beacon.messages;

import com.integ.janoslib.net.beacon.Beacon;
import com.integ.janoslib.net.beacon.messages.BeaconMessage;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.HexUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class MemoryInfoMessage
extends BeaconMessage {
    public MemoryInfoMessage(int serialNumber) {
        super(serialNumber, "DEATH");
    }

    @Override
    public void parse(byte[] messageBytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(messageBytes);
            DataInputStream dis = new DataInputStream(bais);
            this._jniorInfo.TotalMemory = dis.readInt();
            this._jniorInfo.FreeMemory = dis.readInt();
            this._jniorInfo.MaxFreeMemory = dis.readInt();
            this._jniorInfo.LargestFreeBlock = dis.readInt();
            this._jniorInfo.FreeBlockCount = dis.readInt();
            this._jniorInfo.IdleTime = dis.readLong();
            this._jniorInfo.UpTime = dis.readLong();
            this._jniorInfo.MemoryTimestamp = System.currentTimeMillis();
        }
        catch (Exception ex) {
            Exception ex2 = new Exception(this._serialNumber + " error", ex);
            String stacktrace = ExceptionUtils.getStackTrace(ex2);
            Beacon.LOGGER.severe(stacktrace);
            Beacon.LOGGER.severe("processAnnouncement:\n" + HexUtils.hexDump(messageBytes, 0, messageBytes.length));
        }
    }
}

