/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.janoslib.net.beacon.Beacon;
import com.integ.janoslib.net.beacon.JniorCollection;
import com.integ.janoslib.net.beacon.JniorCollectionListenerAdapter;
import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.utils.FileUtils;
import com.integ.janoslib.utils.HexUtils;
import com.integ.supporter.AssemblyInfo;
import com.integ.supporter.Constants;
import com.integ.supporter.RollingLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JniorPhomeReporter {
    private static final Logger LOGGER = RollingLog.getLogger("PhomeReporter");
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss XXX");
    private static final SimpleDateFormat FILE_SIMPLE_DATE_FORMAT = new SimpleDateFormat("ddMMMYYYY_HHmm");
    private static final JniorPhomeReporter Instance = new JniorPhomeReporter();
    private static final HashMap<Integer, JniorInfo> JNIORS_BY_SERIAL = new HashMap();
    private Thread _reportJniorsThread = null;
    private boolean _unitAdded = true;
    private boolean _unitModified = true;

    private JniorPhomeReporter() {
    }

    public static void init() {
        JniorCollection.addListener(new JniorCollectionListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void jniorAdded(JniorInfo jniorInfo) {
                JniorPhomeReporter jniorPhomeReporter = Instance;
                synchronized (jniorPhomeReporter) {
                    JNIORS_BY_SERIAL.put(jniorInfo.getSerialNumber(), jniorInfo.clone());
                    LOGGER.info(jniorInfo.toString() + " Added");
                    JniorPhomeReporter.Instance._unitAdded = true;
                }
            }
        });
        Beacon.getInstance().addBeaconListener(jniorInfo -> {
            JniorPhomeReporter jniorPhomeReporter = Instance;
            synchronized (jniorPhomeReporter) {
                JniorInfo previousJniorInfo;
                if (JNIORS_BY_SERIAL.containsKey(jniorInfo.getSerialNumber()) && !(previousJniorInfo = JNIORS_BY_SERIAL.get(jniorInfo.getSerialNumber())).equals(jniorInfo)) {
                    JNIORS_BY_SERIAL.put(jniorInfo.getSerialNumber(), jniorInfo.clone());
                    LOGGER.info(jniorInfo.toString() + " Updated");
                    JniorPhomeReporter.Instance._unitModified = true;
                }
            }
        });
        Instance.startReportJniorsThread();
    }

    private void startReportJniorsThread() {
        if (null == this._reportJniorsThread) {
            this._reportJniorsThread = new Thread(() -> {
                this.sendSavedReports();
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(5000L);
                            JniorPhomeReporter jniorPhomeReporter = Instance;
                            synchronized (jniorPhomeReporter) {
                                if (this._unitAdded || this._unitModified) {
                                    this._unitModified = false;
                                    this._unitAdded = false;
                                    new Thread(() -> this.sendReport()).start();
                                }
                            }
                        }
                    }
                    catch (InterruptedException ex) {
                        LOGGER.log(Level.SEVERE, null, ex);
                        continue;
                    }
                    break;
                }
            }, this.getClass().getName());
            this._reportJniorsThread.start();
        }
    }

    private void sendSavedReports() {
        try {
            File[] savedListingFiles;
            for (File file : savedListingFiles = new File(Constants.LISTINGS_DIRECTORY).listFiles()) {
                String backupServicesJsonFileContent = FileUtils.readAllText(file.getPath());
                JSONObject jsonReport = new JSONObject(backupServicesJsonFileContent);
                if (!this.sendReport(jsonReport)) continue;
                file.delete();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(JniorPhomeReporter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void sendReport() {
        JSONObject jsonReport = new JSONObject();
        jsonReport.put("app_info", "java supporter");
        ArrayList<JniorInfo> jniors = JniorCollection.getJniors();
        jniors.sort((o1, o2) -> Integer.valueOf(o1.getSerialNumber()).compareTo(o2.getSerialNumber()));
        JSONArray peersJsonArray = new JSONArray();
        for (JniorInfo jniorInfo : jniors) {
            JSONObject peerJson = new JSONObject();
            peerJson.put("SerialNumber", jniorInfo.getSerialNumber());
            peerJson.put("Hostname", jniorInfo.Hostname);
            peerJson.put("OSVersion", jniorInfo.FullOsVersion);
            peerJson.put("MacAddress", jniorInfo.PhysicalAddress);
            peerJson.put("BootTime", SIMPLE_DATE_FORMAT.format(jniorInfo.BootTime));
            peerJson.put("ReceivingIpAddress", jniorInfo.getReceivingIpAddress().toString());
            peersJsonArray.put(peerJson);
        }
        jsonReport.put("peers", peersJsonArray);
        this.sendReport(jsonReport);
    }

    private boolean sendReport(JSONObject jsonReport) {
        LOGGER.info("Send report");
        try {
            String reportString = jsonReport.toString();
            LOGGER.info("Send " + jsonReport.getJSONArray("peers").length() + " peers: " + reportString);
            byte[] dataBytes = reportString.getBytes();
            System.out.println("reportBytesString = " + HexUtils.bytesToHex(dataBytes));
            String encodedString = Base64.getEncoder().encodeToString(dataBytes);
            dataBytes = encodedString.getBytes();
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(dataBytes);
            byte[] digest = md.digest();
            String md5String = HexUtils.bytesToHex(digest).toLowerCase();
            System.out.println("md5String = " + md5String);
            String urlString = "http://phome.integpg.com/jst_report_json?jst_version=" + AssemblyInfo.getVersion();
            URL url = new URL(urlString);
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
            httpConnection.setRequestMethod("POST");
            httpConnection.setRequestProperty("Content-Type", "application/octet-stream");
            httpConnection.setRequestProperty("Accept", "application/json");
            httpConnection.setDoOutput(true);
            try (OutputStream os = httpConnection.getOutputStream();){
                os.write(dataBytes);
                os.write(digest);
                os.flush();
            }
            int status = httpConnection.getResponseCode();
            LOGGER.info("status = " + status + " " + httpConnection.getResponseMessage());
            if (302 == status || 301 == status) {
                String newLocation = httpConnection.getHeaderField("Location");
                URL newUrl = new URL(newLocation);
                httpConnection = (HttpURLConnection)newUrl.openConnection();
                httpConnection.setRequestMethod("POST");
                httpConnection.setRequestProperty("Content-Type", "application/json");
                httpConnection.setDoOutput(true);
                try (OutputStream os = httpConnection.getOutputStream();){
                    os.write(dataBytes);
                    os.write(digest);
                    os.flush();
                }
                status = httpConnection.getResponseCode();
                LOGGER.info("status = " + status);
            }
            if (200 == status) {
                try (BufferedReader br = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "utf-8"));){
                    StringBuilder response = new StringBuilder();
                    String responseLine = null;
                    while ((responseLine = br.readLine()) != null) {
                        response.append(responseLine.trim());
                    }
                    System.out.println(response.toString());
                }
                return true;
            }
            throw new RuntimeException("jnior report failed: " + status);
        }
        catch (Throwable ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            try {
                String filename = String.format("%sjniors_%s.json", Constants.LISTINGS_DIRECTORY, FILE_SIMPLE_DATE_FORMAT.format(System.currentTimeMillis()));
                File jniorCollectionFile = new File(filename);
                String jniorCollectionJsonFileContent = jsonReport.toString(2);
                FileUtils.writeAllBytes(jniorCollectionFile.getPath(), jniorCollectionJsonFileContent.getBytes());
            }
            catch (IOException | JSONException ex2) {
                ex2.printStackTrace();
            }
            return false;
        }
    }
}

