/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.beacon.renderers;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import com.integ.supporter.beacon.renderers.BeaconTableRenderer;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.table.TableCellRenderer;

public class MessageColumnRenderer
implements TableCellRenderer {
    private static final float SCALE = 0.027f;
    private static final FlatSVGIcon.ColorFilter GRAY_COLOR_FILTER = new FlatSVGIcon.ColorFilter();
    private static final FlatSVGIcon TRIANGLE_EXCLAMATION_SVG = new FlatSVGIcon("resources/triangle-exclamation.svg").derive(0.027f);
    private static final FlatSVGIcon CIRCLE_EXCLAMATION_SVG = new FlatSVGIcon("resources/circle-exclamation.svg").derive(0.027f);
    private static final FlatSVGIcon MEMORY_SVG = new FlatSVGIcon("resources/memory.svg").derive(0.027f);
    private static final FlatSVGIcon SD_CARD_SVG = new FlatSVGIcon("resources/sd-card.svg").derive(0.027f);
    private static final FlatSVGIcon BUG_SVG = new FlatSVGIcon("resources/bug.svg").derive(0.027f);
    private static final FlatSVGIcon BOMB_SVG = new FlatSVGIcon("resources/bomb.svg").derive(0.027f);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = new BeaconTableRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ToolTipManager.sharedInstance().setInitialDelay(60);
        StringBuilder tooltipBuilder = new StringBuilder();
        JPanel panel = new JPanel();
        panel.setBackground(c.getBackground());
        ArrayList<FlatSVGIcon> iconsList = new ArrayList<FlatSVGIcon>();
        short attentionFlags = (Short)value;
        if (0 != attentionFlags) {
            if (0 != (attentionFlags & 1)) {
                TRIANGLE_EXCLAMATION_SVG.setDescription("Assertion Occurred");
                iconsList.add(TRIANGLE_EXCLAMATION_SVG);
            }
            if (0 != (attentionFlags & 2)) {
                CIRCLE_EXCLAMATION_SVG.setDescription("Errors File Exists");
                iconsList.add(CIRCLE_EXCLAMATION_SVG);
            }
            if (0 != (attentionFlags & 4)) {
                MEMORY_SVG.setDescription("Memory Error");
                iconsList.add(MEMORY_SVG);
            }
            if (0 != (attentionFlags & 8)) {
                MEMORY_SVG.setDescription("Memory Reformatted");
                iconsList.add(MEMORY_SVG);
            }
            if (0 != (attentionFlags & 0x10)) {
                SD_CARD_SVG.setDescription("Flash Not Mounted");
                iconsList.add(SD_CARD_SVG);
            }
            if (0 != (attentionFlags & 0x20)) {
                BOMB_SVG.setDescription("Dump File Exists");
                iconsList.add(BOMB_SVG);
            }
            if (0 != (attentionFlags & 0x40)) {
                BUG_SVG.setDescription("Application Startup Error");
                iconsList.add(BUG_SVG);
            }
        }
        for (FlatSVGIcon icon : iconsList) {
            icon.setColorFilter(GRAY_COLOR_FILTER);
            JLabel label = new JLabel(icon, 0);
            panel.add(label);
            if (0 < tooltipBuilder.length()) {
                tooltipBuilder.append(", ");
            }
            tooltipBuilder.append(icon.getDescription());
        }
        panel.setToolTipText(tooltipBuilder.toString());
        return panel;
    }

    static {
        GRAY_COLOR_FILTER.add(Color.BLACK, Color.GRAY);
    }
}

