/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.celleditors;

import com.integ.supporter.ui.celleditors.DropDownCellEditorListener;
import com.integ.supporter.ui.celleditors.DropDownCellEditorNotifier;
import java.util.LinkedHashMap;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellEditor;

public class DropDownCellEditor
extends AbstractCellEditor
implements TableCellEditor,
PopupMenuListener {
    private final JComboBox _comboBox;
    private final LinkedHashMap<String, Object> _pairs = new LinkedHashMap();
    private final DropDownCellEditorNotifier _cellEditorNotifier = new DropDownCellEditorNotifier();

    public DropDownCellEditor() {
        this._comboBox = new JComboBox();
        this._comboBox.addPopupMenuListener(this);
    }

    public void clearPairs() {
        this._pairs.clear();
        this._comboBox.removeAllItems();
    }

    public void addNameValuePair(String name, Object value) {
        this._pairs.put(name, value);
        this._comboBox.addItem(name);
    }

    public Object getValue(String name) {
        if (this._pairs.containsKey(name)) {
            return this._pairs.get(name);
        }
        return name;
    }

    public void addBeginCellEditorListener(DropDownCellEditorListener l) {
        this._cellEditorNotifier.addEventListener(l);
    }

    @Override
    public JComponent getTableCellEditorComponent(JTable table, Object item, boolean isSelected, int row, int column) {
        System.out.println("getTableCellEditorComponent = " + table + " " + row + " " + column);
        this._cellEditorNotifier.notifyEditingStarted(new ChangeEvent(this), row, column);
        this._comboBox.setEditable(true);
        if (item != null) {
            this._comboBox.setSelectedItem(item);
        }
        return this._comboBox;
    }

    @Override
    public Object getCellEditorValue() {
        Object value = this._comboBox.getEditor().getItem();
        if (value instanceof String) {
            return this.getValue((String)value);
        }
        return value;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this._cellEditorNotifier.popupMenuWillBecomeVisible(new ChangeEvent(this));
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }
}

