/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.snapshot.menus;

import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.Constants;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.snapshot.SubmitSnapshotDialog;
import com.integ.supporter.snapshot.ZipFileNode;
import com.integ.supporter.snapshot.menus.SnapshotPopupMenu;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;

public class SnapshotTreePopupMenu
extends JPopupMenu {
    private JTree _tree;

    public SnapshotTreePopupMenu() {
        this.init();
    }

    private void init() {
        this.addShowInFolderMenuItem();
        this.addSubmitSnapshotMenuItem();
    }

    private void addShowInFolderMenuItem() {
        JMenuItem openFolderLocationMenuItem = new JMenuItem("Show in Folder");
        openFolderLocationMenuItem.addActionListener(e -> EventQueue.invokeLater(() -> {
            try {
                Object lastSelectedPathComponent = this._tree.getLastSelectedPathComponent();
                if (lastSelectedPathComponent instanceof ZipFileNode) {
                    ZipFileNode selectedZipFileNode = (ZipFileNode)lastSelectedPathComponent;
                    File file = selectedZipFileNode.getFile();
                    File parentFolder = file.getParentFile();
                    if (Constants.IS_WINDOWS) {
                        Runtime.getRuntime().exec("explorer.exe /select," + file.getPath());
                    } else {
                        Desktop desktop = Desktop.getDesktop();
                        desktop.open(parentFolder);
                    }
                }
            }
            catch (IOException | IllegalArgumentException ex) {
                Logger.getLogger(SnapshotPopupMenu.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
            }
        }));
        super.add(openFolderLocationMenuItem);
    }

    private void addSubmitSnapshotMenuItem() {
        JMenuItem openFolderLocationMenuItem = new JMenuItem("Submit Snapshot...");
        openFolderLocationMenuItem.addActionListener(e -> {
            try {
                Object lastSelectedPathComponent = this._tree.getLastSelectedPathComponent();
                if (lastSelectedPathComponent instanceof ZipFileNode) {
                    ZipFileNode selectedZipFileNode = (ZipFileNode)lastSelectedPathComponent;
                    File file = selectedZipFileNode.getFile();
                    SubmitSnapshotDialog submitSnapshotDialog = new SubmitSnapshotDialog((Frame)SupporterMain.getMainFrame(), true);
                    submitSnapshotDialog.setSnapshotFile(file);
                    submitSnapshotDialog.setLocationRelativeTo(null);
                    submitSnapshotDialog.setVisible(true);
                }
            }
            catch (Exception ex) {
                Logger.getLogger(SnapshotPopupMenu.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
            }
        });
        super.add(openFolderLocationMenuItem);
    }

    @Override
    public void show(Component invoker, int x, int y) {
        this._tree = (JTree)invoker;
        super.show(invoker, x, y);
    }
}

