/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema;

import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.supporter.BackgroundAction;
import com.integ.supporter.Constants;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.ui.dialogs.LoginDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.io.CopyStreamAdapter;

public class RemoteFileOpener
extends BackgroundAction {
    private FTPClient _ftpClient;
    private File _localTempFile = null;
    private final String _remoteFolderPath = "/";
    private FTPFile _selectedRemoteFile = null;
    private String _title;
    private FilenameFilter _filenameFilter;

    public RemoteFileOpener(JniorInfo jniorInfo) {
        super(jniorInfo);
    }

    @Override
    public String getTitle() {
        return String.format("%s for %s", this._title, super.getJniorInfo().IpAddress);
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this._filenameFilter = filenameFilter;
    }

    public File getLocalFile() {
        return this._localTempFile;
    }

    @Override
    public void run() {
        try {
            if (null != super.getJniorInfo()) {
                FTPFile[] fileEntries;
                this._ftpClient = new FTPClient();
                this._ftpClient.addProtocolCommandListener(new PrintCommandListener(new PrintWriter(System.out)));
                CopyStreamAdapter streamListener = new CopyStreamAdapter(){

                    @Override
                    public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
                        int percent = (int)(totalBytesTransferred * 100L / RemoteFileOpener.this._selectedRemoteFile.getSize());
                        RemoteFileOpener.this.update(String.format("downloading %s", RemoteFileOpener.this._selectedRemoteFile.getName()), percent);
                    }
                };
                this._ftpClient.setCopyStreamListener(streamListener);
                super.update("Connecting to FTP Server");
                this._ftpClient.connect(super.getJniorInfo().IpAddress, 21);
                int reply = this._ftpClient.getReplyCode();
                if (!FTPReply.isPositiveCompletion(reply)) {
                    this._ftpClient.disconnect();
                    throw new IOException("Exception in connecting to FTP Server");
                }
                super.update("Logging in to FTP Server");
                if (!this._ftpClient.login(super.getJniorInfo().Username, super.getJniorInfo().Password)) {
                    LoginDialog loginDialog = new LoginDialog((Frame)SupporterMain.getMainFrame(), true);
                    loginDialog.setDescription(this._title + " for " + this.getJniorInfo().IpAddress);
                    loginDialog.centerParent();
                    loginDialog.setVisible(true);
                    if (loginDialog.getResult() == 1) {
                        this.getJniorInfo().Username = loginDialog.getUsername();
                        this.getJniorInfo().Password = loginDialog.getPassword();
                        if (!this._ftpClient.login(this.getJniorInfo().Username, this.getJniorInfo().Password)) {
                            super.update("Unable to login to ftp server for " + this.getJniorInfo().IpAddress);
                            Thread.sleep(3000L);
                            this.complete();
                            return;
                        }
                    } else {
                        super.update("User cancelled providing new credentials");
                        Thread.sleep(2000L);
                        this.complete();
                        return;
                    }
                }
                super.update("Checking for Device Files");
                ArrayList<FTPFile> deviceFiles = new ArrayList<FTPFile>();
                for (FTPFile fileEntry : fileEntries = this._ftpClient.listFiles("/")) {
                    boolean isCinemaFile = this._filenameFilter.accept(new File("/"), fileEntry.getName());
                    if (!isCinemaFile) continue;
                    deviceFiles.add(fileEntry);
                }
                if (1 == deviceFiles.size()) {
                    this._selectedRemoteFile = (FTPFile)deviceFiles.get(0);
                    String remoteDeviceFilePath = this._selectedRemoteFile.getName();
                    if (this.downloadDeviceFile(remoteDeviceFilePath)) {
                        super.update("Successfully downloaded " + remoteDeviceFilePath);
                        NotificationCollection.addNotification(String.format("%s has been downloaded", remoteDeviceFilePath));
                    }
                } else {
                    super.update("There are not any remote Device Files");
                }
            }
        }
        catch (Exception ex) {
            super.update("ERROR: " + ex.getMessage());
            NotificationCollection.addError("Error downloading remote device file from " + super.getJniorInfo().toString(), ex);
        }
        this.complete();
    }

    private boolean downloadDeviceFile(String remoteDeviceFilePath) throws FileNotFoundException, IOException {
        File jniorTempDirectory;
        File tempDirectory = new File(Constants.TEMP_DIRECTORY);
        if (!tempDirectory.exists()) {
            tempDirectory.mkdir();
        }
        if (!(jniorTempDirectory = new File(Constants.TEMP_DIRECTORY + File.separator + super.getJniorInfo().getSerialNumber())).exists()) {
            jniorTempDirectory.mkdir();
        }
        this._localTempFile = new File(jniorTempDirectory.getPath() + File.separator + remoteDeviceFilePath);
        FileOutputStream out = new FileOutputStream(this._localTempFile.getPath());
        return this._ftpClient.retrieveFile(remoteDeviceFilePath, out);
    }
}

