/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.beacon;

import com.integ.janoslib.net.beacon.Beacon;
import com.integ.janoslib.net.beacon.JniorCollection;
import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.net.beacon.Version;
import com.integ.janoslib.net.beacon.commands.GetInfoCommand;
import com.integ.janoslib.net.beacon.commands.IdentifyCommand;
import com.integ.janoslib.net.beacon.commands.QueryAllCommand;
import com.integ.janoslib.net.beacon.commands.RebootCommand;
import com.integ.janoslib.net.beacon.commands.SetDhcpCommand;
import com.integ.janoslib.net.beacon.commands.SetHostnameCommand;
import com.integ.janoslib.net.beacon.commands.SetInfoCommand;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.StringUtils;
import com.integ.janoslib.utils.ThreadUtils;
import com.integ.protocols.websockets.WebSocketClient;
import com.integ.supporter.JniorAnnouncementStore;
import com.integ.supporter.JniorItem;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.OpenTelnetConsole;
import com.integ.supporter.RollingLog;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.beacon.BeaconTableColumnModel;
import com.integ.supporter.beacon.BeaconTableColumnModelListener;
import com.integ.supporter.beacon.BeaconTableHeaderMouseListener;
import com.integ.supporter.beacon.BeaconTableModel;
import com.integ.supporter.beacon.HostnameCellEditor;
import com.integ.supporter.beacon.RemoteFileListener;
import com.integ.supporter.beacon.comparators.DateStringComparator;
import com.integ.supporter.beacon.comparators.IpAddressComparator;
import com.integ.supporter.beacon.comparators.VersionStringComparator;
import com.integ.supporter.beacon.dialogs.ConfigurationDialog;
import com.integ.supporter.beacon.menus.BeaconPopupMenu;
import com.integ.supporter.beacon.renderers.BeaconTableRenderer;
import com.integ.supporter.beacon.renderers.MessageColumnRenderer;
import com.integ.supporter.config.BeaconConfig;
import com.integ.supporter.ui.RemoteFileTextDialog;
import com.integ.supporter.ui.TableHeaderRenderer;
import com.integ.supporter.ui.dialogs.LoginDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.json.JSONObject;

public class BeaconTab
extends JPanel
implements TableModelListener,
RemoteFileListener {
    public static final Logger LOGGER = RollingLog.getLogger("BeaconTab");
    private static final BeaconTab Instance = new BeaconTab();
    private final BeaconTableModel _tableModel;
    private final JTable _table;
    private final JScrollPane _scrollPane;
    private final TableRowSorter _sorter;
    private BeaconPopupMenu _popupMenu;
    private String _beaconStatus = "";
    private ArrayList<String> _pendingRemoteFiles;
    private RemoteFileTextDialog _textDialog;
    private JniorInfo _jniorInfo;
    private JButton _configureIpToolbarButton;
    private JButton _rebootToolbarButton;
    private JButton _telnetToolbarButton;
    private final BeaconTableColumnModel _tableColumnModel = new BeaconTableColumnModel();
    private boolean _controlPressed = false;
    private final HashMap<String, WebSocketClient> _websocketHashMap = new HashMap();
    private boolean _series3NotificationSent = false;
    private boolean _oldOsNotificationSent = false;
    private boolean _nonReleasedCodeNotificationSent = false;
    private boolean _alphaCodeNotificationSent = false;
    private boolean _betaCodeNotificationSent = false;

    public static BeaconTab getInstance() {
        return Instance;
    }

    private BeaconTab() {
        LOGGER.info("initialize");
        super.setMinimumSize(new Dimension(250, 650));
        this.setLayout(new BorderLayout());
        this.createToolbar();
        LOGGER.info("add table");
        this._table = new JTable();
        this._table.setColumnModel(this._tableColumnModel);
        this._table.setDoubleBuffered(true);
        this._table.setSelectionMode(2);
        this._table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this._table.setFillsViewportHeight(true);
        this._tableModel = new BeaconTableModel();
        this._table.setModel(this._tableModel);
        this._tableModel.addHostnameChangedListener((jniorInfo, newHostname) -> {
            ThreadUtils.execute(() -> {
                try {
                    GetInfoCommand getInfo = new GetInfoCommand(jniorInfo.getSerialNumber());
                    Beacon.getInstance().broadcastCommand(getInfo);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            });
            jniorInfo.waitForInfo();
            Beacon.getInstance().broadcastCommand(new SetHostnameCommand(jniorInfo, newHostname));
        });
        JTableHeader header = this._table.getTableHeader();
        header.setDefaultRenderer(new TableHeaderRenderer(this._table));
        BeaconTableRenderer beaconTableRenderer = new BeaconTableRenderer();
        this._table.setDefaultRenderer(Object.class, beaconTableRenderer);
        String messageColumnName = this._table.getModel().getColumnName(9);
        this._table.getColumn(messageColumnName).setCellRenderer(new MessageColumnRenderer());
        this._table.setRowHeight(20);
        this._table.setShowVerticalLines(false);
        this._table.setShowHorizontalLines(false);
        this._table.setAutoCreateColumnsFromModel(false);
        this._table.getTableHeader().addMouseListener(new BeaconTableHeaderMouseListener(this._table));
        this._table.getTableHeader().setReorderingAllowed(false);
        this._table.getColumnModel().addColumnModelListener(new BeaconTableColumnModelListener(this._table));
        this._table.setAutoResizeMode(0);
        this._sorter = new TableRowSorter<TableModel>(this._table.getModel());
        this._sorter.setComparator(2, new IpAddressComparator());
        this._sorter.setComparator(7, new DateStringComparator());
        this._sorter.setComparator(8, new DateStringComparator());
        this._sorter.setComparator(3, new VersionStringComparator());
        this._table.setRowSorter(this._sorter);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(2, SortOrder.ASCENDING));
        this._sorter.setSortKeys(sortKeys);
        this._scrollPane = new JScrollPane(this._table);
        this._scrollPane.setHorizontalScrollBarPolicy(30);
        this._scrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)this._scrollPane, "Center");
        this.createPopupMenu();
        this._table.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                BeaconTab.this._controlPressed = e.getKeyCode() == 17;
            }

            @Override
            public void keyReleased(KeyEvent e) {
                BeaconTab.this._controlPressed = false;
            }
        });
        this._table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                LOGGER.info(String.format("mouse clicked at (%d, %d)", e.getX(), e.getY()));
                int row = BeaconTab.this._table.rowAtPoint(e.getPoint());
                int column = BeaconTab.this._table.columnAtPoint(e.getPoint());
                if (0 > row) {
                    BeaconTab.this._table.clearSelection();
                } else if (!BeaconTab.this._table.isRowSelected(row)) {
                    BeaconTab.this._table.changeSelection(row, column, false, false);
                }
                BeaconTab.this._configureIpToolbarButton.setEnabled(1 == BeaconTab.this._table.getSelectedRowCount());
                BeaconTab.this._rebootToolbarButton.setEnabled(0 < BeaconTab.this._table.getSelectedRowCount());
                BeaconTab.this._telnetToolbarButton.setEnabled(0 < BeaconTab.this._table.getSelectedRowCount());
                System.out.println("e.isPopupTrigger() = " + e.isPopupTrigger());
                System.out.println("e.isMetaDown() = " + e.isMetaDown());
                System.out.println("_controlPressed = " + BeaconTab.this._controlPressed);
                System.out.println("e.isControlDown() = " + e.isControlDown());
                if (e.isControlDown() || e.isPopupTrigger() || e.isMetaDown()) {
                    BeaconTab.this._popupMenu.setCtrlDown(e.isControlDown());
                    BeaconTab.this._popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (2 == e.getClickCount() && e.getButton() == 1) {
                    JniorItem jniorItem = BeaconTab.this.getSelectedJniorItem();
                    if (null != jniorItem) {
                        final JniorInfo jniorInfo = jniorItem.getJniorInfo();
                        if (BeaconConfig.getDoubleClickOpensConsoleSession()) {
                            new Thread(){

                                @Override
                                public void run() {
                                    OpenTelnetConsole openTelnetConsole = new OpenTelnetConsole(jniorInfo.IpAddress);
                                    openTelnetConsole.execute();
                                }
                            }.start();
                        }
                    }
                    JSONObject jniorAnnouncementStoreJson = JniorAnnouncementStore.getStoreJSONObject();
                    for (String serialNumberString : jniorAnnouncementStoreJson.keySet()) {
                        int serialNumber = Integer.parseInt(serialNumberString);
                        System.out.println("serialNumber = " + serialNumber);
                        if (JniorCollection.contains(serialNumber)) continue;
                        JSONObject jniorJson = jniorAnnouncementStoreJson.getJSONObject(serialNumberString);
                        System.out.println("jniorJson = " + jniorJson);
                    }
                    System.out.println("");
                }
            }
        });
        this._table.addMouseMotionListener(new MouseMotionAdapter(){
            private JniorItem _lastHoveredItem = null;

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = BeaconTab.this._table.rowAtPoint(e.getPoint());
                JniorItem rowJniorItem = BeaconTab.this.getJniorItemForRow(row);
                if (this._lastHoveredItem != rowJniorItem) {
                    if (null != this._lastHoveredItem) {
                        this._lastHoveredItem.setHovered(false);
                    }
                    if (null != rowJniorItem) {
                        rowJniorItem.setHovered(true);
                    }
                    this._lastHoveredItem = rowJniorItem;
                    BeaconTab.this._table.repaint();
                }
            }
        });
        JniorAnnouncementStore.init();
        String hostnameColumnName = this._table.getModel().getColumnName(1);
        int hostnameColumnIndex = this._table.getColumnModel().getColumnIndex(hostnameColumnName);
        TableColumn hostnameTableColumn = this._table.getColumnModel().getColumn(hostnameColumnIndex);
        hostnameTableColumn.setCellEditor(new HostnameCellEditor());
        LOGGER.info("add query all hooks");
        AbstractAction queryAll = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeaconTab.this.queryAll();
            }
        };
        this._table.getInputMap().put(KeyStroke.getKeyStroke("F5"), "queryAll");
        this._table.getActionMap().put("queryAll", queryAll);
        this.addBeaconListener();
    }

    public JniorItem[] getJniors() {
        return this._tableModel.getJniors();
    }

    public int getMinimumWidth() {
        JScrollBar verticalScrollBar = this._scrollPane.getVerticalScrollBar();
        int verticalScrollBarWidth = verticalScrollBar.isVisible() ? verticalScrollBar.getWidth() : 0;
        return this._tableColumnModel.getMinimumWidth() + verticalScrollBarWidth;
    }

    public int selectedJniorCount() {
        return this._table.getSelectedRowCount();
    }

    @Override
    public void fileReceived(JniorInfo jniorInfo, String remoteFileName) {
        this.getNextRemoteFile();
    }

    public void clearSelection() {
        this._table.clearSelection();
    }

    private void createPopupMenu() {
        LOGGER.info(String.format("%s create popup menu", this.getClass().getName()));
        this._popupMenu = new BeaconPopupMenu(this);
    }

    public void retrieveAndDisplayRemoteFile(JniorInfo jniorInfo, String remoteFileName, boolean scrollToEnd) throws UnknownHostException, IOException {
        this.retrieveAndDisplayRemoteFiles(jniorInfo, new String[]{remoteFileName}, scrollToEnd);
    }

    public void retrieveAndDisplayRemoteFiles(JniorInfo jniorInfo, String[] remoteFileNames, boolean scrollToEnd) throws UnknownHostException, IOException {
        this._pendingRemoteFiles = new ArrayList<String>(Arrays.asList(remoteFileNames));
        String remoteFileNamesString = StringUtils.join(remoteFileNames, ", ");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(this._table);
        this._jniorInfo = jniorInfo;
        this._textDialog = new RemoteFileTextDialog(topFrame, true);
        this._textDialog.setTitle(String.format("%s /%s", jniorInfo.IpAddress, remoteFileNamesString));
        this._textDialog.setText(String.format("Retrieving %s\n", remoteFileNamesString));
        this._textDialog.setEditable(false);
        this._textDialog.setSize(1024, screenSize.height - 128);
        this._textDialog.setCompletedListener(this);
        if (scrollToEnd) {
            this._textDialog.setScrollToEnd();
        }
        this.getNextRemoteFile();
        this._textDialog.setVisible(true);
    }

    private void getNextRemoteFile() {
        if (0 < this._pendingRemoteFiles.size()) {
            String nextFile = this._pendingRemoteFiles.remove(0);
            this._textDialog.displayRemoteFile(this._jniorInfo, nextFile);
        }
    }

    public boolean removeRemoteFile(JniorInfo jniorInfo, String remoteFileName) throws UnknownHostException, IOException {
        return this.removeRemoteFiles(jniorInfo, new String[]{remoteFileName});
    }

    public boolean removeRemoteFiles(JniorInfo jniorInfo, String[] remoteFileNames) throws UnknownHostException, IOException {
        FTPClient _ftpClient = new FTPClient();
        _ftpClient.addProtocolCommandListener(new PrintCommandListener(new PrintWriter(System.out)));
        _ftpClient.connect(jniorInfo.IpAddress, 21);
        int reply = _ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion(reply)) {
            _ftpClient.disconnect();
            throw new IOException("Exception in connecting to FTP Server");
        }
        if (_ftpClient.login(jniorInfo.Username, jniorInfo.Password)) {
            try {
                for (String remoteFileName : remoteFileNames) {
                    _ftpClient.deleteFile(remoteFileName);
                }
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public int getSelectedRowCount() {
        return this._table.getSelectedRowCount();
    }

    public ArrayList<JniorItem> getSelectedJniorItems() {
        int[] selectedRows;
        ArrayList<JniorItem> selectedJniorItems = new ArrayList<JniorItem>();
        for (int selectedRow : selectedRows = this._table.getSelectedRows()) {
            JniorItem jniorItem = this.getJniorItemForRow(selectedRow);
            selectedJniorItems.add(jniorItem);
        }
        return selectedJniorItems;
    }

    public JniorItem getSelectedJniorItem() {
        int selectedRow = this._table.getSelectedRow();
        return this.getJniorItemForRow(selectedRow);
    }

    public JniorItem getJniorItemForRow(int row) {
        if (-1 == row) {
            return null;
        }
        JniorItem jniorItem = null;
        try {
            int modelRow;
            row = modelRow = this._table.convertRowIndexToModel(row);
            jniorItem = this._tableModel.getJniorAt(row);
        }
        catch (Exception ex) {
            NotificationCollection.addError("Error getting selected Jnior item", ex);
        }
        return jniorItem;
    }

    public boolean getJniorInfoCredentials(JniorInfo jniorInfo) {
        Beacon.getInstance().broadcastCommand(new GetInfoCommand(jniorInfo.getSerialNumber()));
        LoginDialog loginDialog = new LoginDialog((Frame)SupporterMain.getMainFrame(), true);
        loginDialog.setDescription("Beacon for " + jniorInfo.IpAddress + " needs credentials");
        loginDialog.centerParent();
        loginDialog.setVisible(true);
        if (loginDialog.getResult() == 1) {
            jniorInfo.Username = loginDialog.getUsername();
            jniorInfo.Password = loginDialog.getPassword();
            return true;
        }
        return false;
    }

    public void queryAll() {
        this._tableModel.clear();
        Beacon.getInstance().broadcastCommand(new QueryAllCommand());
    }

    public void identify(JniorInfo jniorInfo) {
        LOGGER.info("selected jnior Serial " + jniorInfo.getSerialNumber());
        IdentifyCommand identify = new IdentifyCommand(jniorInfo.getSerialNumber());
        Beacon.getInstance().broadcastCommand(identify);
    }

    public void getInfo(JniorInfo jniorInfo) {
        new Thread(() -> {
            try {
                LOGGER.info("selected jnior Serial " + jniorInfo.getSerialNumber());
                GetInfoCommand getInfo = new GetInfoCommand(jniorInfo.getSerialNumber());
                Beacon.getInstance().broadcastCommand(getInfo);
            }
            catch (Exception ex) {
                NotificationCollection.addError("Error getting unit info for " + jniorInfo.getSerialNumber(), ex);
            }
        }).start();
        LOGGER.info(String.format("wait for info for %s", jniorInfo.toString()));
        jniorInfo.waitForInfo();
        LOGGER.info(String.format("info received for %s", jniorInfo.toString()));
    }

    public void setInfo(JniorInfo jniorInfo) {
        LOGGER.info("setting info for jnior Serial " + jniorInfo.getSerialNumber());
        SetInfoCommand setInfo = new SetInfoCommand(jniorInfo);
        Beacon.getInstance().broadcastCommand(setInfo);
    }

    public void setDhcp(JniorInfo jniorInfo) {
        LOGGER.info("setting dhcp for jnior Serial " + jniorInfo.getSerialNumber());
        SetDhcpCommand setDhcp = new SetDhcpCommand(jniorInfo);
        Beacon.getInstance().broadcastCommand(setDhcp);
    }

    private synchronized void alertSeries3UnitDetected() {
        if (!this._series3NotificationSent) {
            this._series3NotificationSent = true;
            NotificationCollection.addNotification("Series 3 units detected.", 3);
        }
    }

    private synchronized void alertOldOsDetected() {
        if (!this._oldOsNotificationSent) {
            this._oldOsNotificationSent = true;
            NotificationCollection.addNotification("Old version(s) of JANOS was detected.", 3);
        }
    }

    private synchronized void alertNonReleasedCodeDetected() {
        if (!this._nonReleasedCodeNotificationSent) {
            this._nonReleasedCodeNotificationSent = true;
            NotificationCollection.addNotification("Execution of Non Released code was detected.", 3);
        }
    }

    private synchronized void alertAlphaCodeDetected() {
        if (!this._alphaCodeNotificationSent) {
            this._alphaCodeNotificationSent = true;
            NotificationCollection.addNotification("Execution of Alpha code was detected.", 3);
        }
    }

    private synchronized void alertBetaCodeDetected() {
        if (!this._betaCodeNotificationSent) {
            this._betaCodeNotificationSent = true;
            NotificationCollection.addNotification("Execution of Beta code was detected.", 3);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this._sorter.sort();
    }

    private void addBeaconListener() {
        Beacon.getInstance().addBeaconListener(jniorInfo -> {
            boolean isOldOs;
            boolean isSeries4;
            boolean isSeries3 = 600000000 > jniorInfo.getSerialNumber();
            boolean bl = isSeries4 = !isSeries3;
            if (isSeries3) {
                this.alertSeries3UnitDetected();
            }
            boolean bl2 = isOldOs = 0 > jniorInfo.OsVersion.compareTo(new Version(true, 2, 4, 0, 3, 1, 0));
            if (isSeries4 && isOldOs) {
                this.alertOldOsDetected();
            }
            if (jniorInfo.OsVersion.isAlpha()) {
                this.alertAlphaCodeDetected();
            }
            if (jniorInfo.OsVersion.isBeta()) {
                this.alertBetaCodeDetected();
            }
            if (jniorInfo.OsVersion.isReleaseCandidate()) {
                this.alertNonReleasedCodeDetected();
            }
        });
    }

    private void createToolbar() {
        JToolBar jToolBar1 = new JToolBar();
        jToolBar1.setBorder(null);
        jToolBar1.setFloatable(false);
        jToolBar1.setRollover(true);
        JButton queryAllToolbarButton = new JButton();
        queryAllToolbarButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/arrow_refresh.png")));
        queryAllToolbarButton.setText("Query All");
        queryAllToolbarButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        queryAllToolbarButton.setFocusable(false);
        queryAllToolbarButton.setVerticalTextPosition(3);
        queryAllToolbarButton.addActionListener(evt -> this.queryAll());
        jToolBar1.add(queryAllToolbarButton);
        this._configureIpToolbarButton = new JButton();
        this._configureIpToolbarButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/application_view_detail.png")));
        this._configureIpToolbarButton.setText("Configure IP Information");
        this._configureIpToolbarButton.setEnabled(false);
        this._configureIpToolbarButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this._configureIpToolbarButton.setFocusable(false);
        this._configureIpToolbarButton.setVerticalTextPosition(3);
        this._configureIpToolbarButton.addActionListener(evt -> {
            LOGGER.info(String.format("user selected %s", evt.getActionCommand()));
            try {
                JniorItem jniorItem = this.getSelectedJniorItem();
                JniorInfo jniorInfo = jniorItem.getJniorInfo();
                this.getInfo(jniorInfo);
                JniorInfo jniorInfoClone = jniorInfo.clone();
                JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(this);
                ConfigurationDialog dlg = new ConfigurationDialog((Frame)topFrame, true);
                dlg.setJniorInfo(jniorInfoClone);
                dlg.setLocationRelativeTo(null);
                dlg.setVisible(true);
                jniorInfoClone = dlg.getJniorInfo();
                if (null != jniorInfoClone && !jniorInfoClone.equals(jniorInfo) && this.getJniorInfoCredentials(jniorInfo)) {
                    this.getInfo(jniorInfo);
                    jniorInfoClone.Nonce = jniorInfo.Nonce;
                    Thread.sleep(1000L);
                    this.setInfo(jniorInfoClone);
                    this.getInfo(jniorInfo);
                    jniorInfoClone.Nonce = jniorInfo.Nonce;
                    Thread.sleep(1000L);
                    this.setDhcp(jniorInfoClone);
                }
            }
            catch (Exception ex) {
                LOGGER.severe(ExceptionUtils.getStackTrace(ex));
            }
        });
        jToolBar1.add(this._configureIpToolbarButton);
        this._rebootToolbarButton = new JButton();
        this._rebootToolbarButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/control_repeat_blue.png")));
        this._rebootToolbarButton.setText("Reboot");
        this._rebootToolbarButton.setEnabled(false);
        this._rebootToolbarButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this._rebootToolbarButton.setFocusable(false);
        this._rebootToolbarButton.setVerticalTextPosition(3);
        this._rebootToolbarButton.addActionListener(evt -> {
            LOGGER.info(String.format("user selected %s", evt.getActionCommand()));
            try {
                ArrayList<JniorItem> selectedJniors = this.getSelectedJniorItems();
                for (JniorItem jniorItem : selectedJniors) {
                    JniorInfo jniorInfo = jniorItem.getJniorInfo();
                    this.getInfo(jniorInfo);
                    int result = JOptionPane.showConfirmDialog(SupporterMain.getMainFrame(), "Are you sure you want to reboot " + jniorInfo.getSerialNumber(), "Confirm Reboot", 0);
                    if (0 != result || !this.getJniorInfoCredentials(jniorInfo)) continue;
                    Beacon.getInstance().broadcastCommand(new RebootCommand(jniorInfo));
                    jniorInfo.Status = 1;
                }
            }
            catch (Exception ex) {
                LOGGER.severe(ExceptionUtils.getStackTrace(ex));
            }
        });
        jToolBar1.add(this._rebootToolbarButton);
        this._telnetToolbarButton = new JButton();
        this._telnetToolbarButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/application_osx_terminal.png")));
        this._telnetToolbarButton.setText("Open Telnet");
        this._telnetToolbarButton.setEnabled(false);
        this._telnetToolbarButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this._telnetToolbarButton.setFocusable(false);
        this._telnetToolbarButton.setVerticalTextPosition(3);
        this._telnetToolbarButton.addActionListener(evt -> {
            LOGGER.info(String.format("user selected %s", evt.getActionCommand()));
            try {
                ArrayList<JniorItem> selectedJniors = this.getSelectedJniorItems();
                for (JniorItem jniorItem : selectedJniors) {
                    JniorInfo jniorInfo = jniorItem.getJniorInfo();
                    OpenTelnetConsole openTelnetConsole = new OpenTelnetConsole(jniorInfo.IpAddress);
                    openTelnetConsole.execute();
                }
            }
            catch (Exception ex) {
                LOGGER.severe(ExceptionUtils.getStackTrace(ex));
            }
        });
        jToolBar1.add(this._telnetToolbarButton);
        JPanel toolbarPanel = new JPanel();
        toolbarPanel.setLayout(new FlowLayout(0));
        toolbarPanel.add(jToolBar1);
        this.add((Component)toolbarPanel, "North");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPreviouslySeen() {
        BeaconTableModel beaconTableModel = this._tableModel;
        synchronized (beaconTableModel) {
            JSONObject storeJson = JniorAnnouncementStore.getStoreJSONObject();
            for (String key : storeJson.keySet()) {
                JSONObject jniorObject = storeJson.getJSONObject(key);
                JSONObject jniorDataObject = jniorObject.getJSONObject("Data");
                JniorInfo newJniorInfo = JniorInfo.fromJSON(jniorDataObject);
                this._tableModel.updateJniorInfo(newJniorInfo);
            }
        }
    }

    public JTable getTable() {
        return this._table;
    }

    public TableRowSorter getRowSorter() {
        return this._sorter;
    }
}

