/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.jtreetable;

import com.integ.supporter.ui.jtreetable.AbstractTreeTableModel;
import com.integ.supporter.ui.jtreetable.TreeTableCellEditor;
import com.integ.supporter.ui.jtreetable.TreeTableCellRenderer;
import com.integ.supporter.ui.jtreetable.TreeTableModel;
import com.integ.supporter.ui.jtreetable.TreeTableModelAdapter;
import com.integ.supporter.ui.jtreetable.TreeTableSelectionModel;
import java.awt.Dimension;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class JTreeTable
extends JTable {
    private final AbstractTreeTableModel _treeTableModel;
    private final TreeTableCellRenderer _treeTableCellRenderer;
    private boolean _rootVisible = true;

    public JTreeTable(AbstractTreeTableModel treeTableModel) {
        this._treeTableModel = treeTableModel;
        this._treeTableCellRenderer = new TreeTableCellRenderer(this, treeTableModel);
        this._treeTableCellRenderer.setShowsRootHandles(true);
        this._treeTableCellRenderer.setExpandsSelectedPaths(true);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this._treeTableCellRenderer));
        super.setRowHeight(this._treeTableCellRenderer.getRowHeight());
        this.setDefaultRenderer(TreeTableModel.class, this._treeTableCellRenderer);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor(this._treeTableCellRenderer, this));
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
    }

    public void enableExpansion() {
        TreeTableSelectionModel selectionModel = new TreeTableSelectionModel();
        this._treeTableCellRenderer.setSelectionModel(selectionModel);
        super.setSelectionModel(selectionModel.getListSelectionModel());
        selectionModel.getListSelectionModel().addListSelectionListener(e -> {
            try {
                for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                    TreePath treePath = this._treeTableCellRenderer.getPathForRow(i);
                    if (this._treeTableCellRenderer.isExpanded(treePath)) {
                        this._treeTableCellRenderer.collapsePath(treePath);
                        continue;
                    }
                    this._treeTableCellRenderer.expandPath(treePath);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this._treeTableCellRenderer.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                TreePath path = event.getPath();
                Object node = path.getLastPathComponent();
                JTreeTable.this._treeTableModel.getChildCount(node);
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
    }

    public JTree getTree() {
        return this._treeTableCellRenderer;
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this._treeTableCellRenderer.addTreeSelectionListener(listener);
    }

    public void addTableSelectionListener(ListSelectionListener listener) {
        super.getSelectionModel().addListSelectionListener(listener);
    }

    public void expandPath(TreePath path) {
        this._treeTableCellRenderer.expandPath(path);
    }

    public void expandRow(int i) {
        this._treeTableCellRenderer.expandRow(i);
    }

    public void setShowRoot(boolean rootVisible) {
        this._rootVisible = rootVisible;
        this._treeTableCellRenderer.setRootVisible(rootVisible);
    }

    public void expandsSelectedPath(boolean b) {
        this._treeTableCellRenderer.setExpandsSelectedPaths(b);
    }

    public TreePath getPathForLocation(int x, int y) {
        return this._treeTableCellRenderer.getPathForLocation(x, y);
    }

    public void setCellRenderer(TableCellRenderer cellRenderer) {
        super.setDefaultRenderer(Object.class, cellRenderer);
    }

    public TreePath getSelectionPath() {
        int selectedRow = super.getSelectedRow();
        return -1 != selectedRow ? this._treeTableCellRenderer.getPathForRow(selectedRow) : null;
    }

    public void setSelectionPath(TreePath treePath) {
        int row = this._treeTableCellRenderer.getRowForPath(treePath);
        super.setRowSelectionInterval(row, row);
    }

    public TreePath[] getSelectionPaths() {
        int[] selectedRows = super.getSelectedRows();
        TreePath[] selectionPaths = new TreePath[selectedRows.length];
        for (int i = 0; i <= selectedRows.length; ++i) {
            selectionPaths[i] = this._treeTableCellRenderer.getPathForRow(selectedRows[i]);
        }
        return selectionPaths;
    }

    public void setSelectionPaths(TreePath[] treePaths) {
        this._treeTableCellRenderer.setSelectionPaths(treePaths);
    }
}

