/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema;

import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.utils.FileUtils;
import com.integ.janoslib.utils.PathUtils;
import com.integ.janoslib.utils.ResourceUtils;
import com.integ.janoslib.utils.StringUtils;
import com.integ.supporter.Constants;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.cinema.CinemaFilePublisher;
import com.integ.supporter.cinema.Device;
import com.integ.supporter.cinema.DevicePanel;
import com.integ.supporter.cinema.MacroPane;
import com.integ.supporter.cinema.devices.DeviceInfo;
import com.integ.supporter.jrget.DescendingDateFileChooser;
import com.integ.supporter.ui.dialogs.JniorSelectionDialog;
import com.integ.supporter.ui.toasts.InProgressMessageToast;
import com.integ.supporter.ui.toasts.MessageToast;
import com.integ.supporter.ui.toasts.ToastNotifications;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;

public class DevicesPane
extends JPanel {
    private final DefaultListModel<Device> _deviceModel = new DefaultListModel();
    private String _deviceFilePath;
    private boolean _valid;
    private boolean _deviceFileSaved;
    private JButton addDeviceButton;
    private JPanel devicesPanel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar1;
    private JButton publishButton;
    private JButton saveAsButton;
    private JButton saveButton;

    public DevicesPane(String deviceFilePath) {
        this.initComponents();
        this.updateButtons();
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(16);
        this.jScrollPane1.getHorizontalScrollBar().setUnitIncrement(16);
        this.addModelDataListener();
        this.loadDeviceFile(deviceFilePath);
    }

    public String getDeviceFilePath() {
        return this._deviceFilePath;
    }

    @Override
    public final String getName() {
        return new File(this._deviceFilePath).getName();
    }

    private void addModelDataListener() {
        this._deviceModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                for (int i = 0; i < DevicesPane.this._deviceModel.size(); ++i) {
                    if (e.getIndex0() <= i && i <= e.getIndex1()) {
                        Device device = DevicesPane.this._deviceModel.get(i);
                        DevicesPane.this.devicesPanel.add((Component)DevicesPane.this.getDevicePanel(device, i), i);
                    }
                    DevicePanel devicePanel = (DevicePanel)DevicesPane.this.devicesPanel.getComponent(i);
                    devicePanel.setMoveUpEnabled(0 != i);
                    devicePanel.setMoveDownEnabled(DevicesPane.this._deviceModel.size() > i + 1);
                }
                DevicesPane.this.devicesPanel.updateUI();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                for (int i = 0; i < DevicesPane.this.devicesPanel.getComponentCount(); ++i) {
                    if (e.getIndex0() <= i && i <= e.getIndex1()) {
                        DevicesPane.this.devicesPanel.remove(i);
                        continue;
                    }
                    DevicePanel devicePanel = (DevicePanel)DevicesPane.this.devicesPanel.getComponent(i);
                    devicePanel.setMoveUpEnabled(0 != i);
                    devicePanel.setMoveDownEnabled(DevicesPane.this._deviceModel.size() > i + 1);
                }
                DevicesPane.this.devicesPanel.updateUI();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                System.out.println("");
            }
        });
    }

    private void updateButtons() {
        this.areDevicesValid();
        this.saveButton.setEnabled(null != this._deviceFilePath && this._valid);
        this.saveAsButton.setEnabled(this._valid);
    }

    private void loadDeviceFile(String deviceFilePath) {
        if (null == deviceFilePath) {
            try {
                File tempTemplateFile = new File(PathUtils.combine(Constants.TEMP_DIRECTORY, "template_devices.csv"));
                ResourceUtils.extractResource("/resources/template_devices.csv", tempTemplateFile);
                deviceFilePath = tempTemplateFile.getPath();
                this.saveButton.setEnabled(false);
            }
            catch (IOException ex) {
                Logger.getLogger(MacroPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this._deviceFilePath = deviceFilePath;
        }
        try {
            String devicesFileContents = FileUtils.readAllText(deviceFilePath);
            boolean loadDevices = false;
            String[] lines = StringUtils.split(devicesFileContents, "\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                System.out.println("line = " + line);
                String[] fields = StringUtils.split(line, ",");
                if (0 == fields.length) continue;
                if ("device name".equalsIgnoreCase(fields[0])) {
                    loadDevices = true;
                    continue;
                }
                if (!loadDevices) continue;
                String deviceTypeString = fields[1].trim();
                Device device = new Device(fields[0].trim(), deviceTypeString);
                device.setIpAddress(fields[2].trim());
                String baudRateString = fields[4].trim();
                if (!"".equals(baudRateString)) {
                    device.setSerialPort(fields[3].trim());
                    device.setBaudRate(baudRateString);
                    device.setDataBits(fields[5].trim());
                    device.setStopBits(fields[6].trim());
                    device.setParity(fields[7].trim());
                } else {
                    String ethernetPortString = fields[3].trim();
                    device.setEthernetPort(ethernetPortString);
                }
                device.setTerminationString(fields[8].trim());
                this._deviceModel.addElement(device);
            }
        }
        catch (Exception ex) {
            NotificationCollection.addError("Error reading devices file: " + deviceFilePath, ex);
        }
    }

    private DevicePanel getDevicePanel(Device device, int index) {
        DevicePanel devicePanel = new DevicePanel(device);
        devicePanel.addActionListener(e -> {
            DevicePanel devicePanel1 = (DevicePanel)e.getSource();
            Device device1 = devicePanel1.getDevice();
            int indexOfDevice = this._deviceModel.indexOf(device);
            switch (e.getActionCommand()) {
                case "RemoveDevice": {
                    this._deviceModel.removeElement(device1);
                    break;
                }
                case "MoveDeviceUp": {
                    this._deviceModel.removeElement(device1);
                    this._deviceModel.add(indexOfDevice - 1, device1);
                    this.devicesPanel.updateUI();
                    break;
                }
                case "MoveDeviceDown": {
                    this._deviceModel.removeElement(device1);
                    this._deviceModel.add(indexOfDevice + 1, device1);
                    this.devicesPanel.updateUI();
                }
            }
        });
        return devicePanel;
    }

    public boolean areDevicesValid() {
        boolean valid = true;
        for (int i = 0; i < this._deviceModel.size(); ++i) {
            Device device = this._deviceModel.getElementAt(i);
            valid &= device.validate();
        }
        this._valid = valid;
        return this._valid;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.saveButton = new JButton();
        this.saveAsButton = new JButton();
        this.publishButton = new JButton();
        this.addDeviceButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.devicesPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.jPanel1.setPreferredSize(new Dimension(407, 34));
        this.jPanel1.setLayout(new FlowLayout(0, 0, 3));
        this.jToolBar1.setRollover(true);
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/disk.png")));
        this.saveButton.setText("Save");
        this.saveButton.setFocusable(false);
        this.saveButton.setVerticalTextPosition(3);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevicesPane.this.saveButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.saveButton);
        this.saveAsButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/disk_multiple.png")));
        this.saveAsButton.setText("Save As...");
        this.saveAsButton.setFocusable(false);
        this.saveAsButton.setVerticalTextPosition(3);
        this.saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevicesPane.this.saveAsButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.saveAsButton);
        this.publishButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/application_go.png")));
        this.publishButton.setText("Publish");
        this.publishButton.setFocusable(false);
        this.publishButton.setVerticalTextPosition(3);
        this.publishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevicesPane.this.publishButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.publishButton);
        this.addDeviceButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/add.png")));
        this.addDeviceButton.setText("Add Device");
        this.addDeviceButton.setFocusable(false);
        this.addDeviceButton.setVerticalTextPosition(3);
        this.addDeviceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevicesPane.this.addDeviceButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.addDeviceButton);
        this.jPanel1.add(this.jToolBar1);
        this.add((Component)this.jPanel1, "North");
        this.jPanel2.setLayout(new FlowLayout(0));
        this.devicesPanel.setLayout(new GridLayout(0, 1));
        this.jPanel2.add(this.devicesPanel);
        this.jScrollPane1.setViewportView(this.jPanel2);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void addDeviceButtonActionPerformed(ActionEvent evt) {
        String deviceName = this.getDeviceName();
        this._deviceModel.addElement(new Device(deviceName, ""));
    }

    private String getDeviceName() {
        int index = 1;
        while (true) {
            String newDeviceName = "New Device " + index;
            boolean isUsed = false;
            while (index <= this._deviceModel.getSize()) {
                Device device = this._deviceModel.get(index - 1);
                if (device.getName().equalsIgnoreCase(newDeviceName)) {
                    isUsed = true;
                    break;
                }
                ++index;
            }
            if (!isUsed) {
                return newDeviceName;
            }
            ++index;
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        if (!this.areDevicesValid()) {
            return;
        }
        if (null != this._deviceFilePath) {
            this._deviceFileSaved = this.saveDeviceFile(this._deviceFilePath);
        } else {
            this.saveAsButtonActionPerformed(evt);
        }
        if (null != evt && this._deviceFileSaved) {
            MessageToast messageToast = new MessageToast(this.getName() + " saved!");
            ToastNotifications.getInstance().display(messageToast);
        }
    }

    private void saveAsButtonActionPerformed(ActionEvent evt) {
        if (!this.areDevicesValid()) {
            JOptionPane.showMessageDialog(null, "There are invalid devices in your configuration.  Complete the configuration and try to save again.", "Invalid Devices", 0);
            return;
        }
        String filePath = "devices_";
        if (null != this._deviceFilePath) {
            filePath = this._deviceFilePath;
        }
        DescendingDateFileChooser fileChooser = new DescendingDateFileChooser();
        fileChooser.setCurrentDirectory(new File(Constants.CINEMA_FILES_FOLDER));
        fileChooser.setSelectedFile(new File(new File(filePath).getName()));
        fileChooser.removeChoosableFileFilter(fileChooser.getChoosableFileFilters()[0]);
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String name = file.getName();
                return file.getName().startsWith("devices_") && name.endsWith(".csv");
            }

            @Override
            public String getDescription() {
                return "Devices Files";
            }
        });
        if (fileChooser.showSaveDialog(this) == 0) {
            File file = fileChooser.getSelectedFile();
            if (!file.getName().toLowerCase().endsWith(".csv")) {
                file = new File(file.getPath() + ".csv");
            }
            if (!file.getName().toLowerCase().startsWith("devices_") || !file.getName().toLowerCase().endsWith(".csv")) {
                JOptionPane.showMessageDialog(null, "Invalid file name. Please follow the devices_*.csv file pattern");
            } else {
                this._deviceFileSaved = this.saveDeviceFile(file.getPath());
                if (this._deviceFileSaved) {
                    String oldFilePath = this._deviceFilePath;
                    this._deviceFilePath = file.getPath();
                    if (null == oldFilePath || !oldFilePath.equals(this._deviceFilePath)) {
                        super.firePropertyChange("title", oldFilePath, this._deviceFilePath);
                    }
                    this.updateButtons();
                }
            }
        }
    }

    private void publishButtonActionPerformed(ActionEvent evt) {
        JniorInfo jniorInfo;
        this.saveButtonActionPerformed(null);
        if (this._deviceFileSaved && null != (jniorInfo = this.getSelectedJnior())) {
            CinemaFilePublisher cinemaFilePublisher = new CinemaFilePublisher(jniorInfo, this._deviceFilePath, "/");
            cinemaFilePublisher.setFilenameFilter((dir, name) -> (name = name.toLowerCase()).startsWith("devices") && name.endsWith(".csv"));
            InProgressMessageToast inProgressMessageToast = new InProgressMessageToast(cinemaFilePublisher);
            cinemaFilePublisher.addProgressUpdateListener(e -> {
                if (cinemaFilePublisher.isComplete()) {
                    ToastNotifications.getInstance().hide(inProgressMessageToast);
                }
            });
            ToastNotifications.getInstance().display(inProgressMessageToast);
            cinemaFilePublisher.start();
        }
    }

    private JniorInfo getSelectedJnior() {
        JniorSelectionDialog jniorSelectionDialog = new JniorSelectionDialog((Frame)SupporterMain.getMainFrame(), true);
        jniorSelectionDialog.setSelectionType(0);
        jniorSelectionDialog.setVisible(true);
        if (0 < jniorSelectionDialog.getSelectedJniors().length) {
            return jniorSelectionDialog.getSelectedJniors()[0];
        }
        return null;
    }

    private boolean saveDeviceFile(String filepath) {
        File file = new File(filepath);
        File tmpFile = new File(PathUtils.combine(Constants.TEMP_DIRECTORY, file.getName()));
        File bakFile = new File(file.getPath() + ".bak");
        try {
            this.writeDeviceFile(tmpFile);
            boolean fileSaveNeeded = true;
            if (file.exists()) {
                String tmpFileMd5;
                String fileMd5 = FileUtils.getFileMd5(file.getPath());
                boolean bl = fileSaveNeeded = !fileMd5.equalsIgnoreCase(tmpFileMd5 = FileUtils.getFileMd5(tmpFile.getPath()));
                if (fileSaveNeeded) {
                    if (bakFile.exists()) {
                        bakFile.delete();
                    }
                    boolean renamed = file.renameTo(bakFile);
                    System.out.println("renamed = " + renamed);
                }
            }
            if (fileSaveNeeded) {
                if (file.exists()) {
                    file.delete();
                }
                boolean renamed = tmpFile.renameTo(file);
                System.out.println("renamed = " + renamed);
            }
            return true;
        }
        catch (Exception ex) {
            NotificationCollection.addError("Error saving macro file", ex);
            return false;
        }
    }

    private void writeDeviceFile(File file) throws IOException {
        StringBuilder fileContentsBuilder = new StringBuilder();
        fileContentsBuilder.append("Devices,,,,,,,,,");
        fileContentsBuilder.append("\r\n");
        fileContentsBuilder.append(",,,,,,,,,");
        fileContentsBuilder.append("\r\n");
        fileContentsBuilder.append("Device Name,Type,IP Address,Port,Baud,Data Bits,Parity,Stop Bits,Termination String");
        fileContentsBuilder.append("\r\n");
        for (int i = 0; i < this._deviceModel.size(); ++i) {
            Device device = this._deviceModel.getElementAt(i);
            DeviceInfo deviceInfo = DeviceInfo.getByName(device.getType());
            String deviceType = device.getType();
            if (deviceType.toLowerCase().startsWith("barco series")) {
                deviceType = "BARCO";
            }
            Object deviceLine = String.format("%s,%s", device.getName(), deviceType);
            deviceLine = 2 == deviceInfo.getDeviceType() ? String.format("%s,%s,%s,,,,,", deviceLine, device.getIpAddress(), device.getEthernetPort()) : String.format("%s,,%s,%s,%s,%s,%s,", deviceLine, device.getSerialPort(), device.getBaudRate(), device.getDataBits(), device.getStopBits(), device.getParity());
            deviceLine = (String)deviceLine + String.format("%s\r\n", device.getTerminationString());
            fileContentsBuilder.append((String)deviceLine);
        }
        FileUtils.writeAllBytes(file.getPath(), fileContentsBuilder.toString().getBytes());
    }
}

