/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.janoslib.collections.ObservableCollection;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.CollectionModifiedEvent;
import com.integ.supporter.Notification;
import com.integ.supporter.NotificationListener;
import com.integ.supporter.ui.CollectionModifiedAdapter;
import java.util.ArrayList;

public class NotificationCollection
extends ObservableCollection<Notification> {
    private static final ArrayList<NotificationListener> NotificationListeners = new ArrayList();
    private static final NotificationCollection Instance = new NotificationCollection();

    public static NotificationCollection getInstance() {
        return Instance;
    }

    public NotificationCollection() {
        super.addCollectionListener(new CollectionModifiedAdapter(){

            @Override
            public void itemAdded(CollectionModifiedEvent e, Object item) {
                NotificationCollection.fireItemAdded((Notification)item);
            }

            @Override
            public void itemRemoved(CollectionModifiedEvent e, Object item) {
                NotificationCollection.fireItemRemoved((Notification)item);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(NotificationListener notificationListener) {
        ArrayList<NotificationListener> arrayList = NotificationListeners;
        synchronized (arrayList) {
            if (!NotificationListeners.contains(notificationListener)) {
                NotificationListeners.add(notificationListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireItemAdded(Notification notification) {
        ArrayList<NotificationListener> arrayList = NotificationListeners;
        synchronized (arrayList) {
            for (NotificationListener notificationListener : NotificationListeners) {
                notificationListener.notificationAdded(notification);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireItemRemoved(Notification notification) {
        ArrayList<NotificationListener> arrayList = NotificationListeners;
        synchronized (arrayList) {
            for (NotificationListener notificationListener : NotificationListeners) {
                notificationListener.notificationRemoved(notification);
            }
        }
    }

    public static Notification addNotification(String description) {
        return NotificationCollection.addNotification(description, 2);
    }

    public static Notification addNotification(String description, int level) {
        Notification notification = new Notification();
        notification._timestamp = System.currentTimeMillis();
        notification._description = description;
        notification._level = level;
        return NotificationCollection.addNotification(notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Notification addNotification(Notification notification) {
        NotificationCollection notificationCollection = Instance;
        synchronized (notificationCollection) {
            Instance.add(notification);
            return notification;
        }
    }

    public static Notification addError(String message) {
        return NotificationCollection.addNotification(message, 4);
    }

    public static Notification addError(Throwable ex) {
        String message = String.format("%s: %s", ex.toString(), ex.getStackTrace()[0]);
        String stackTrace = ExceptionUtils.getStackTrace(ex);
        Notification notification = NotificationCollection.addNotification(message, 4);
        notification.setUserObject(stackTrace);
        return notification;
    }

    public static Notification addError(String description, Throwable ex) {
        String message = String.format("%s: %s: %s", description, ex.toString(), ex.getStackTrace()[0]);
        String stackTrace = ExceptionUtils.getStackTrace(ex);
        Notification notification = NotificationCollection.addNotification(message, 4);
        notification.setUserObject(stackTrace);
        return notification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Notification> getNotifications() {
        NotificationCollection notificationCollection = Instance;
        synchronized (notificationCollection) {
            return (ArrayList)Instance.clone();
        }
    }
}

