/*
 * Decompiled with CFR 0.152.
 */
package com.integ.protocols.jmpprotocol;

import com.integ.protocols.JniorConnection;
import com.integ.protocols.events.AuthenticationFailedEvent;
import com.integ.protocols.events.AuthenticationSuccessEvent;
import com.integ.protocols.events.ConnectionEvent;
import com.integ.protocols.events.JmpProtocolMessageListener;
import com.integ.protocols.events.JmpProtocolMessageNotifier;
import com.integ.protocols.events.JmpProtocolMessageReceivedEvent;
import com.integ.protocols.jmpprotocol.Credentials;
import com.integ.protocols.jmpprotocol.consolesession.ConsoleSession;
import com.integ.protocols.jmpprotocol.messages.JniorMessage;
import com.integ.protocols.jmpprotocol.messages.LoginMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;

public class JmpProtocolClient
extends JniorConnection
implements AutoCloseable {
    private static final int DEFAULT_PORT = 9220;
    private final JmpProtocolMessageNotifier _jmpProtcolMessageNotifier = new JmpProtocolMessageNotifier();
    private final HashMap<String, JmpProtocolMessageListener> _metaListeners = new HashMap();
    private boolean _loginAttempted = false;
    private boolean _isLoggedIn;
    private final Object _consoleSessionLock = new Object();
    private ConsoleSession _consoleSession;
    protected Credentials _credentials = JniorConnection.DEFAULT_CREDENTIALS;

    public JmpProtocolClient(String hostAddress) {
        super(hostAddress, 9220);
    }

    public JmpProtocolClient(String hostAddress, int port) {
        super(hostAddress, port);
    }

    public void addMessageListener(JmpProtocolMessageListener listener) {
        this._jmpProtcolMessageNotifier.addEventListener(listener);
    }

    public void removeMessageListener(JmpProtocolMessageListener listener) {
        this._jmpProtcolMessageNotifier.removeEventListener(listener);
    }

    public void fireErrorEvent(ConnectionEvent connectionEvent, Exception ex) {
        this._connectionNotifier.fireConnectionError(connectionEvent, ex);
    }

    @Override
    protected void connected() throws Exception {
        this.send(JniorMessage.Empty);
    }

    public void setCredentials(String username, String password) {
        this._credentials = new Credentials(username, password);
    }

    @Override
    public void runReceiverThread() {
        ArrayList messageJsonObjectQueue = new ArrayList();
        new Thread(() -> {
            while (this.isConnected()) {
                try {
                    byte[] messageBytes = this.getMessage();
                    if (null == messageBytes) continue;
                    String messageJsonString = new String(messageBytes);
                    System.out.println(String.format("%s: <-- %s", this.getClientString(), messageJsonString));
                    JSONObject messageJson = new JSONObject(messageJsonString);
                    System.out.println(messageJson.toString());
                    ArrayList arrayList = messageJsonObjectQueue;
                    synchronized (arrayList) {
                        System.out.println(String.format("%s: queue message and notify", this.getClientString()));
                        messageJsonObjectQueue.add(messageJson);
                        messageJsonObjectQueue.notify();
                    }
                }
                catch (Exception ex) {
                    if (this.isConnected()) {
                        this._connectionNotifier.fireConnectionError(new ConnectionEvent(this), ex);
                    }
                    try {
                        this.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }).start();
        new Thread(() -> {
            while (true) {
                ArrayList arrayList;
                if (!messageJsonObjectQueue.isEmpty()) {
                    try {
                        System.out.println(String.format("%s: process queued message", this.getClientString()));
                        arrayList = messageJsonObjectQueue;
                        synchronized (arrayList) {
                            JSONObject messageJson = (JSONObject)messageJsonObjectQueue.remove(0);
                            this.handleMessage(messageJson);
                            System.out.println(String.format("%s: %s has been handled", this.getClientString(), messageJson));
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                arrayList = messageJsonObjectQueue;
                synchronized (arrayList) {
                    if (messageJsonObjectQueue.isEmpty()) {
                        try {
                            System.out.println(String.format("%s: wait for message", this.getClientString()));
                            messageJsonObjectQueue.wait();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        }).start();
    }

    @Override
    protected byte[] getMessage() {
        StringBuilder stringBuffer = new StringBuilder();
        try {
            byte b = this._dataInputStream.readByte();
            if (91 != b) {
                throw new Exception("left bracket expected");
            }
            stringBuffer.append((char)b);
            int length = 0;
            while (true) {
                b = this._dataInputStream.readByte();
                stringBuffer.append((char)b);
                if (48 > b || b > 57) break;
                length *= 10;
                length += b - 48;
            }
            if (44 != b) {
                throw new Exception("command expected");
            }
            if (length > this._inputBuffer.length) {
                this._inputBuffer = new byte[length];
            }
            this._dataInputStream.read(this._inputBuffer, 0, length);
            String dataString = new String(this._inputBuffer, 0, length);
            stringBuffer.append(dataString);
            b = this._dataInputStream.readByte();
            if (93 != b) {
                throw new Exception("right bracket expected");
            }
            stringBuffer.append((char)b);
            return dataString.getBytes();
        }
        catch (Exception ex) {
            if (!this._socket.isClosed()) {
                throw new RuntimeException("Unable to read message", ex);
            }
            return null;
        }
    }

    private void handleMessage(JSONObject messageJson) {
        String message = messageJson.getString("Message");
        System.out.println(String.format("%s: message = %s", this.getClientString(), message));
        if ("error".equalsIgnoreCase(message)) {
            String text = messageJson.getString("Text");
            if (text.toLowerCase().contains("unauthorized")) {
                String nonce = messageJson.getString("Nonce");
                if (!this._attemptDefaultCredentials || this._loginAttempted) {
                    this._authenticationNotifier.fireAuthenticaionFailed(new AuthenticationFailedEvent(this, nonce));
                } else {
                    try {
                        this.send(new LoginMessage(JniorConnection.DEFAULT_CREDENTIALS.getUsername(), JniorConnection.DEFAULT_CREDENTIALS.getPassword(), nonce));
                    }
                    catch (IOException ex) {
                        this._authenticationNotifier.fireAuthenticaionFailed(new AuthenticationFailedEvent(this, nonce));
                    }
                }
                this._loginAttempted = true;
            }
        } else if ("authenticated".equalsIgnoreCase(message)) {
            this._isLoggedIn = true;
            boolean isAdministrator = messageJson.getBoolean("Administrator");
            boolean canControl = messageJson.getBoolean("Control");
            this._authenticationNotifier.fireAuthenticaionSuccess(new AuthenticationSuccessEvent(this, isAdministrator, canControl));
        } else {
            boolean handled = false;
            if (messageJson.has("Meta")) {
                JSONObject metaJson = messageJson.getJSONObject("Meta");
                System.out.println("metaJson = " + metaJson);
                String hash = metaJson.getString("Hash");
                System.out.println("hash = " + hash);
                if (this._metaListeners.containsKey(hash)) {
                    handled = true;
                    JmpProtocolMessageListener listener = this._metaListeners.get(hash);
                    listener.onMessage(new JmpProtocolMessageReceivedEvent(this, messageJson));
                    this._metaListeners.remove(hash);
                    System.out.println("removed message handler for " + hash + ": " + this._metaListeners.size());
                }
            }
            if (!handled) {
                System.out.println(String.format("%s: fire notifier for %s", this.getClientString(), message));
                this._jmpProtcolMessageNotifier.fireMessageReceived(new JmpProtocolMessageReceivedEvent(this, messageJson));
            }
        }
    }

    @Override
    public boolean isConnected() {
        return null != this._socket && this._socket.isConnected();
    }

    public boolean isLoggedIn() {
        return this._isLoggedIn;
    }

    public void send(JniorMessage jniorMessage, JmpProtocolMessageListener jmpProtocolMessageListener) throws IOException {
        if (null != jniorMessage.getHash()) {
            this._metaListeners.put(jniorMessage.getHash(), jmpProtocolMessageListener);
            System.out.println("added message handler for " + jniorMessage.getHash() + ": " + this._metaListeners.size());
        }
        this.send(jniorMessage);
    }

    public void send(JniorMessage jniorMessage) throws IOException {
        if (jniorMessage instanceof LoginMessage) {
            LoginMessage loginMessage = (LoginMessage)jniorMessage;
            this._credentials = new Credentials(loginMessage.getUsername(), loginMessage.getPassword());
        }
        String jniorMessageString = jniorMessage.toString();
        String outputMessage = String.format("[%d,%s]", jniorMessageString.length(), jniorMessageString);
        System.out.println(String.format("%s: --> %s", this.toString(), outputMessage));
        this._outputStream.write(outputMessage.getBytes());
        this._outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsoleSession getConsoleSession() {
        Object object = this._consoleSessionLock;
        synchronized (object) {
            System.out.println(String.format("%s - _consoleSessionLock = _consoleSession", this.toString(), this._consoleSession));
            if (null == this._consoleSession) {
                try {
                    this._consoleSession = new ConsoleSession(this);
                    System.out.println(String.format("%s - got ConsoleSession", this.toString()));
                    this._consoleSession.setCredentials(this._credentials.getUsername(), this._credentials.getPassword());
                    System.out.println(String.format("%s - got ConsoleSession", this.toString()));
                    this._consoleSession.open();
                    System.out.println(String.format("%s - got ConsoleSession", this.toString()));
                    long timeoutExpire = System.currentTimeMillis() + 2000L;
                    while (System.currentTimeMillis() < timeoutExpire && !this._consoleSession.isLoggedIn()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
        }
        return this._consoleSession;
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

