/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.utils;

import com.integ.janoslib.utils.ArrayUtils;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class NetworkUtils {
    private static final Object LOCK = new Object();
    private static ArrayList<NetworkInterface> _networkInterfaces = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<NetworkInterface> getNetworkInterfaces() throws SocketException {
        Object object = LOCK;
        synchronized (object) {
            if (null == _networkInterfaces) {
                ArrayList<NetworkInterface> networkInterfaces = new ArrayList<NetworkInterface>();
                Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
                for (NetworkInterface networkInterface : Collections.list(nets)) {
                    if (networkInterface.isLoopback() || !networkInterface.isUp() || networkInterface.isPointToPoint()) continue;
                    networkInterfaces.add(networkInterface);
                }
                _networkInterfaces = networkInterfaces;
            }
            return _networkInterfaces;
        }
    }

    public static InetAddress getLocalAddressFor(InetAddress remoteAddress) throws SocketException {
        ArrayList<NetworkInterface> networkInterfaces = NetworkUtils.getNetworkInterfaces();
        for (NetworkInterface networkInterface : networkInterfaces) {
            List<InterfaceAddress> interfaceAddresses = networkInterface.getInterfaceAddresses();
            for (InterfaceAddress interfaceAddress : interfaceAddresses) {
                int mask = -1;
                short networkPrefixLength = interfaceAddress.getNetworkPrefixLength();
                byte[] localAddressBytes = interfaceAddress.getAddress().getAddress();
                int localAddressValue = ArrayUtils.getInt(localAddressBytes);
                byte[] remoteAddressBytes = remoteAddress.getAddress();
                int remoteAddressValue = ArrayUtils.getInt(remoteAddressBytes);
                if ((localAddressValue &= (mask <<= 32 - networkPrefixLength)) != (remoteAddressValue &= mask)) continue;
                InetAddress address = interfaceAddress.getAddress();
                return address;
            }
        }
        return null;
    }
}

