/*
 * Decompiled with CFR 0.152.
 */
package com.integ.protocols;

import com.integ.protocols.events.AuthenticationListener;
import com.integ.protocols.events.AuthenticationNotifier;
import com.integ.protocols.events.ConnectionEvent;
import com.integ.protocols.events.ConnectionListener;
import com.integ.protocols.events.ConnectionNotifier;
import com.integ.protocols.jmpprotocol.Credentials;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

public abstract class JniorConnection {
    public static final Credentials DEFAULT_CREDENTIALS = new Credentials("jnior", "jnior");
    private String _hostAddress;
    private int _port;
    protected Socket _socket;
    protected byte[] _inputBuffer = new byte[32];
    protected DataInputStream _dataInputStream;
    protected OutputStream _outputStream;
    protected final ConnectionNotifier _connectionNotifier = new ConnectionNotifier();
    protected final AuthenticationNotifier _authenticationNotifier = new AuthenticationNotifier();
    protected boolean _attemptDefaultCredentials;

    public JniorConnection() {
    }

    public JniorConnection(String hostAddress, int port) {
        this._hostAddress = hostAddress;
        this._port = port;
    }

    public String getHostAddress() {
        return this._hostAddress;
    }

    public int getPort() {
        return this._port;
    }

    public String getClientString() {
        return String.format("%s:%d", this._hostAddress, this._port);
    }

    public void addConnectionListener(ConnectionListener listener) {
        this._connectionNotifier.addEventListener(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this._connectionNotifier.removeEventListener(listener);
    }

    public void addAuthenticationListener(AuthenticationListener listener) {
        this._authenticationNotifier.addEventListener(listener);
    }

    public void removeAuthenticationListener(AuthenticationListener listener) {
        this._authenticationNotifier.removeEventListener(listener);
    }

    public void setAttemptDefaultCredentials(boolean attemptDefaultCredentials) {
        this._attemptDefaultCredentials = attemptDefaultCredentials;
    }

    public void connect() {
        this.connect(5000);
    }

    public void connect(int timeout) {
        if (this.isConnected()) {
            return;
        }
        try {
            this._connectionNotifier.fireConnectionConnecting(new ConnectionEvent(this));
            this._socket = new Socket();
            this._socket.connect(new InetSocketAddress(this._hostAddress, this._port), timeout);
            this._socket.setSoTimeout(15000);
            this.createStreams();
            this.connected();
            this.runReceiverThread();
            this._connectionNotifier.fireConnectionConnected(new ConnectionEvent(this));
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to connect to " + this.toString(), ex);
        }
    }

    protected abstract void connected() throws Exception;

    public void close() throws Exception {
        if (null != this._socket) {
            this._socket.close();
            this._socket = null;
            this._connectionNotifier.fireConnectionClosed(new ConnectionEvent(this));
        }
    }

    public boolean isConnected() {
        return null != this._socket && this._socket.isConnected();
    }

    protected void createStreams() {
        try {
            InputStream _inputStream = this._socket.getInputStream();
            this._dataInputStream = new DataInputStream(_inputStream);
            this._outputStream = this._socket.getOutputStream();
        }
        catch (IOException ex) {
            throw new RuntimeException("unable to create streams", ex);
        }
    }

    protected abstract void runReceiverThread();

    protected abstract byte[] getMessage();

    public String toString() {
        Object s = String.format("%s:%d", this._hostAddress, this._port);
        if (this.isConnected()) {
            s = (String)s + String.format(" using local port: %d", this._socket.getLocalPort());
        }
        return s;
    }
}

