/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.backup;

import com.integ.janoslib.utils.PathUtils;
import com.integ.supporter.Constants;
import com.integ.supporter.backup.DownloadLogic;
import com.integ.supporter.backup.DownloadLogicFactory;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONObject;

public class DateStampDownloadLogic
extends DownloadLogic {
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmm");

    public DateStampDownloadLogic(JSONObject fileJson) {
        super(fileJson);
    }

    @Override
    public String getStorageDirectory() {
        String storagePath = PathUtils.combine(Constants.BACKUP_DIRECTORY, String.valueOf(this.getSerialNumber()), "files");
        return storagePath;
    }

    @Override
    public String getLocalPath() {
        return this.getNewFileName();
    }

    private String getNewFileName() {
        String storagePath = this.getStorageDirectory();
        String fileParentDirectory = this._filepath.substring(0, this._filepath.lastIndexOf("/"));
        String filename = this._filepath.substring(fileParentDirectory.length() + 1);
        String fileExtension = PathUtils.getFileExtension(filename);
        filename = filename.substring(0, filename.length() - (fileExtension.length() + 1));
        long dateTimestamp = this._fileJson.getLong("date") * 1000L;
        Date fileDate = new Date(dateTimestamp);
        String newFilePath = PathUtils.combine(fileParentDirectory, String.format("%s_%s.%s", filename, SIMPLE_DATE_FORMAT.format(fileDate), fileExtension));
        newFilePath = PathUtils.combine(storagePath, newFilePath);
        return newFilePath;
    }

    @Override
    public boolean isFileNeeded() {
        boolean isFileNeeded;
        String newFilePath = this.getNewFileName();
        boolean bl = isFileNeeded = !new File(newFilePath).exists();
        if (isFileNeeded) {
            DownloadLogicFactory.LOGGER.info(String.format("%s does not exist", newFilePath));
        }
        return isFileNeeded;
    }

    @Override
    public String whyNotNeeded() {
        return String.format("%s exists as %s", this._filepath, this.getNewFileName());
    }

    @Override
    public File saveFileAs(byte[] fileContentBytes) {
        try {
            String localPath = this.getLocalPath();
            this.saveFileAs(localPath, fileContentBytes);
            return new File(localPath);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

