/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema;

import com.integ.beacon.JniorInfo;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.cinema.macro.LocalMacroFile;
import com.integ.supporter.cinema.macro.MacroTab;
import com.integ.supporter.dialogs.JniorSelectionDialog;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JTabbedPane;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class RemoteMacroFileOpener {
    private FTPClient _ftpClient;
    private JniorInfo _selectedJnior = this.getSelectedJnior();
    private File _localTempMacroFile = null;

    public RemoteMacroFileOpener(Component parent) throws IOException {
        if (null != this._selectedJnior) {
            String remoteMacroFilePath;
            FTPFile[] fileEntries;
            this._ftpClient = new FTPClient();
            this._ftpClient.addProtocolCommandListener(new PrintCommandListener(new PrintWriter(System.out)));
            this._ftpClient.connect(this._selectedJnior.IpAddress, 21);
            int reply = this._ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion(reply)) {
                this._ftpClient.disconnect();
                throw new IOException("Exception in connecting to FTP Server");
            }
            if (!this._ftpClient.login(this._selectedJnior.UserName, this._selectedJnior.Password)) {
                throw new RuntimeException("unabe to login to ftp server");
            }
            ArrayList<String> macroFiles = new ArrayList<String>();
            for (FTPFile fileEntry : fileEntries = this._ftpClient.listFiles("/")) {
                if (!fileEntry.getName().startsWith("macro") || !fileEntry.getName().endsWith(".csv")) continue;
                macroFiles.add(fileEntry.getName());
            }
            if (1 == macroFiles.size() && this.downloadMacroFile(remoteMacroFilePath = (String)macroFiles.get(0))) {
                LocalMacroFile macroFile = this.loadMacroFile(this._localTempMacroFile);
                MacroTab macroTab = new MacroTab(macroFile);
                JTabbedPane tabbedPane = SupporterMain.getTabPane();
                String title = String.format("Remote Macro - %s", macroFile.getTitle());
                int tabCount = tabbedPane.getTabCount();
                tabbedPane.insertTab(title, null, macroTab, title, tabCount);
                tabbedPane.setSelectedIndex(tabCount);
            }
        }
    }

    private JniorInfo getSelectedJnior() {
        JniorSelectionDialog dlg = new JniorSelectionDialog(null, true);
        dlg.setVisible(true);
        JniorInfo[] selectedJniors = dlg.getSelectedJniors();
        if (null != selectedJniors && 1 == selectedJniors.length) {
            return selectedJniors[0];
        }
        return null;
    }

    private LocalMacroFile loadMacroFile(File file) {
        return new LocalMacroFile(file);
    }

    private boolean downloadMacroFile(String remoteMacroFilePath) throws FileNotFoundException, IOException {
        File jniorTempDirectory;
        File tempDirectory = new File(SupporterMain.TEMP_DIRECTORY);
        if (!tempDirectory.exists()) {
            tempDirectory.mkdir();
        }
        if (!(jniorTempDirectory = new File(SupporterMain.TEMP_DIRECTORY + File.separator + this._selectedJnior.getSerialNumber())).exists()) {
            jniorTempDirectory.mkdir();
        }
        this._localTempMacroFile = new File(jniorTempDirectory.getPath() + File.separator + remoteMacroFilePath);
        FileOutputStream out = new FileOutputStream(this._localTempMacroFile.getPath());
        return this._ftpClient.retrieveFile(remoteMacroFilePath, out);
    }
}

