/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.SupporterMain;
import java.io.IOException;
import java.util.Hashtable;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class RollingLog {
    private static final int LIMIT = 262144;
    private static final int LOG_COUNT = 5;
    private static final Hashtable<String, Logger> LOG_CACHE = new Hashtable();
    private static Logger GlobalLogger = null;

    public static void redirectAllLogging() {
        Logger.getLogger("").addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                String loggerName = record.getLoggerName();
                RollingLog.getLogger(loggerName).log(record);
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String name) {
        Hashtable<String, Logger> hashtable = LOG_CACHE;
        synchronized (hashtable) {
            if (!LOG_CACHE.containsKey(name)) {
                try {
                    Logger logger = Logger.getLogger(name);
                    String filename = String.format("%s%s.%%g.log", SupporterMain.LOGS_DIRECTORY, name);
                    FileHandler fileHandler = new FileHandler(filename, 262144, 5, true);
                    fileHandler.setFormatter(new SimpleFormatter());
                    logger.setUseParentHandlers(false);
                    logger.addHandler(fileHandler);
                    LOG_CACHE.put(name, logger);
                    logger.info("-------------------------");
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    String stackTrace = ExceptionUtils.getStackTrace(ex);
                    Logger.getGlobal().severe(String.format("%s: %s", ex.getMessage(), stackTrace));
                    LOG_CACHE.put(name, Logger.getGlobal());
                }
                catch (SecurityException ex) {
                    ex.printStackTrace();
                    String stackTrace = ExceptionUtils.getStackTrace(ex);
                    Logger.getGlobal().severe(String.format("%s: %s", ex.getMessage(), stackTrace));
                    LOG_CACHE.put(name, Logger.getGlobal());
                }
            }
            return LOG_CACHE.get(name);
        }
    }

    static void setGlobalLogger(Logger logger) {
        LOG_CACHE.put("global", logger);
    }
}

