/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.json.JSONObject;

public class ConfigFile {
    protected JSONObject _configJson = new JSONObject();
    private final File _file;
    private long _lastModifiedTime = 0L;

    protected ConfigFile(File file) {
        this._file = file;
    }

    protected void shouldReloadConfig() {
        if (this._file.exists() && this._lastModifiedTime != this._file.lastModified()) {
            this._lastModifiedTime = this._file.lastModified();
            this.loadConfig();
        }
    }

    protected void loadConfig() {
        long configLoadStart = System.currentTimeMillis();
        if (this._file.exists()) {
            try {
                String _jniorsConfigJsonFileContent = FileUtils.readAllText(this._file.getPath());
                this._configJson = new JSONObject(_jniorsConfigJsonFileContent);
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).severe(ExceptionUtils.getStackTrace(ex));
            }
        }
        long configLoadElapsed = System.currentTimeMillis() - configLoadStart;
        Logger.getLogger(this.getClass().getName()).info(String.format("took %.2f to load the jniors config file", (double)configLoadElapsed / 1000.0));
    }

    protected void saveConfig() {
        try {
            String fileContentString = this._configJson.toString(2);
            byte[] fileContentBytes = fileContentString.getBytes();
            FileUtils.writeAllBytes(this._file.getPath(), fileContentBytes);
            this._lastModifiedTime = this._file.lastModified();
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).severe(ExceptionUtils.getStackTrace(ex));
        }
    }
}

