/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater;

import com.integ.janoslib.utils.FileUtils;
import com.integ.supporter.DetailsFileChooser;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.updater.EditProjectListCellRenderer;
import com.integ.supporter.updater.UpdateProjectFile;
import com.integ.supporter.updater.UpdateTab;
import com.integ.supporter.updater.steps.CleanupStep;
import com.integ.supporter.updater.steps.CleanupStepPanel;
import com.integ.supporter.updater.steps.DeleteFileStep;
import com.integ.supporter.updater.steps.DeleteFileStepPanel;
import com.integ.supporter.updater.steps.FtpStep;
import com.integ.supporter.updater.steps.FtpStepPanel;
import com.integ.supporter.updater.steps.MkDirStep;
import com.integ.supporter.updater.steps.MkDirStepPanel;
import com.integ.supporter.updater.steps.ProjectStep;
import com.integ.supporter.updater.steps.ProjectStepPanel;
import com.integ.supporter.updater.steps.RebootStep;
import com.integ.supporter.updater.steps.RebootStepPanel;
import com.integ.supporter.updater.steps.RegistryStep;
import com.integ.supporter.updater.steps.RegistryStepPanel;
import com.integ.supporter.updater.steps.TelnetStep;
import com.integ.supporter.updater.steps.TelnetStepPanel;
import com.integ.supporter.updater.steps.UpdateSeries4OSStep;
import com.integ.supporter.updater.steps.UpdateSeries4OSStepPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UpdateProjectEditorDialog
extends JDialog {
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    private UpdateProjectFile _updateProjectFile;
    private DefaultListModel _model;
    private File _originalUpdateProjectFile;
    private File _resultFile;
    private int _result = 1;
    private JPopupMenu addActionPopupMenu;
    private JMenuItem addCleanupMenuItem;
    private JMenuItem addFtpMenuItem;
    private JMenuItem addMkDirMenuItem;
    private JButton addProjectStep;
    private JMenuItem addRebootMenuItem;
    private JMenuItem addRegistryMenuItem;
    private JMenuItem addTelnetMenuItem;
    private JMenuItem addUpdateSeries4OsMenuItem;
    private JMenuItem addUpldateSeries3OsMenuItem;
    private JButton cancelButton;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JScrollPane jScrollPane2;
    private JButton moveStepDown;
    private JButton moveStepUp;
    private JButton packageButton;
    private JScrollPane propertiesScrollPane;
    private JButton removeStepButton;
    private JTextField titleTextField;
    private JList<String> updateStepList;

    public UpdateProjectEditorDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.updateStepList.setCellRenderer(new EditProjectListCellRenderer());
        this.updateStepList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                System.out.println("ListSelectionEvent = " + e);
                if (!e.getValueIsAdjusting()) {
                    int selectedIndex = UpdateProjectEditorDialog.this.updateStepList.getSelectedIndex();
                    if (-1 != selectedIndex) {
                        UpdateProjectEditorDialog.this.moveStepUp.setEnabled(0 < selectedIndex);
                        UpdateProjectEditorDialog.this.moveStepDown.setEnabled(UpdateProjectEditorDialog.this._model.getSize() > selectedIndex + 1);
                        ProjectStep step = (ProjectStep)UpdateProjectEditorDialog.this._model.elementAt(selectedIndex);
                        System.out.println("step = " + step);
                        try {
                            ProjectStepPanel projectStepPanel = null;
                            if (step instanceof UpdateSeries4OSStep) {
                                projectStepPanel = new UpdateSeries4OSStepPanel(step);
                            } else if (step instanceof FtpStep) {
                                projectStepPanel = new FtpStepPanel(step);
                            } else if (step instanceof CleanupStep) {
                                projectStepPanel = new CleanupStepPanel(step);
                            } else if (step instanceof TelnetStep) {
                                projectStepPanel = new TelnetStepPanel(step);
                            } else if (step instanceof MkDirStep) {
                                projectStepPanel = new MkDirStepPanel(step);
                            } else if (step instanceof RegistryStep) {
                                projectStepPanel = new RegistryStepPanel(step);
                            } else if (step instanceof DeleteFileStep) {
                                projectStepPanel = new DeleteFileStepPanel(step);
                            } else if (step instanceof RebootStep) {
                                projectStepPanel = new RebootStepPanel(step);
                            } else {
                                System.out.println("unknown " + step);
                            }
                            ((ProjectStepPanel)projectStepPanel).init();
                            JPanel propertiesPanel = new JPanel();
                            propertiesPanel.setLayout(new BorderLayout());
                            propertiesPanel.add((Component)projectStepPanel, "North");
                            UpdateProjectEditorDialog.this.propertiesScrollPane.setViewportView(propertiesPanel);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    } else {
                        UpdateProjectEditorDialog.this.moveStepUp.setEnabled(true);
                        UpdateProjectEditorDialog.this.moveStepDown.setEnabled(true);
                    }
                }
            }
        });
        this.titleTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.warn();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.warn();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.warn();
            }

            private void warn() {
                UpdateProjectEditorDialog.this._updateProjectFile.setTitle(UpdateProjectEditorDialog.this.titleTextField.getText());
            }
        });
    }

    public int showEditorDialog() {
        if (null == this._updateProjectFile) {
            try {
                File tempFile = File.createTempFile("newupdateproject_", "temp", SupporterMain.getTempDirectory());
                this._updateProjectFile = new UpdateProjectFile(tempFile);
            }
            catch (IOException ex) {
                Logger.getLogger(UpdateProjectEditorDialog.class.getName()).severe(ex.getMessage());
            }
        }
        this.setVisible(true);
        return this._result;
    }

    public void setUpdateProject(UpdateProjectFile updateProjectFile) {
        try {
            this._originalUpdateProjectFile = updateProjectFile.getFile();
            if (null != updateProjectFile.getFile()) {
                String filename = updateProjectFile.getFile().getName();
                String extension = "temp";
                int periodPos = filename.lastIndexOf(".");
                if (-1 != periodPos) {
                    extension = filename.substring(periodPos);
                }
                File tempFile = File.createTempFile(filename + "_", extension, SupporterMain.getTempDirectory());
                FileUtils.copyfile(updateProjectFile.getFile(), 0, tempFile, 0);
                updateProjectFile = new UpdateProjectFile(tempFile);
            }
            this._updateProjectFile = updateProjectFile;
            this._updateProjectFile.load();
            this.titleTextField.setText(updateProjectFile.getTitle());
            this.updateSteps();
        }
        catch (IOException ex) {
            Logger.getLogger(UpdateProjectEditorDialog.class.getName()).severe(ex.getMessage());
        }
    }

    private void updateSteps() {
        try {
            this._model = new DefaultListModel();
            for (ProjectStep step : this._updateProjectFile.getSteps()) {
                this._model.addElement(step);
            }
            this.updateStepList.setModel(this._model);
        }
        catch (Exception ex) {
            Logger.getLogger(UpdateProjectEditorDialog.class.getName()).severe(ex.getMessage());
        }
    }

    public File getFile() {
        return this._resultFile;
    }

    private void initComponents() {
        this.addActionPopupMenu = new JPopupMenu();
        this.addCleanupMenuItem = new JMenuItem();
        this.addFtpMenuItem = new JMenuItem();
        this.addMkDirMenuItem = new JMenuItem();
        this.addRebootMenuItem = new JMenuItem();
        this.addRegistryMenuItem = new JMenuItem();
        this.addTelnetMenuItem = new JMenuItem();
        this.addUpdateSeries4OsMenuItem = new JMenuItem();
        this.addUpldateSeries3OsMenuItem = new JMenuItem();
        this.jPanel6 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.updateStepList = new JList();
        this.jPanel7 = new JPanel();
        this.moveStepUp = new JButton();
        this.moveStepDown = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.addProjectStep = new JButton();
        this.removeStepButton = new JButton();
        this.jPanel2 = new JPanel();
        this.packageButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel5 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel1 = new JLabel();
        this.titleTextField = new JTextField();
        this.propertiesScrollPane = new JScrollPane();
        this.addCleanupMenuItem.setText("Remove Files");
        this.addCleanupMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateProjectEditorDialog.this.addCleanupMenuItemActionPerformed(evt);
            }
        });
        this.addActionPopupMenu.add(this.addCleanupMenuItem);
        this.addFtpMenuItem.setText("File Transfer");
        this.addFtpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateProjectEditorDialog.this.addFtpMenuItemActionPerformed(evt);
            }
        });
        this.addActionPopupMenu.add(this.addFtpMenuItem);
        this.addMkDirMenuItem.setText("Make Directory");
        this.addMkDirMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateProjectEditorDialog.this.addMkDirMenuItemActionPerformed(evt);
            }
        });
        this.addActionPopupMenu.add(this.addMkDirMenuItem);
        this.addRebootMenuItem.setText("Reboot");
        this.addRebootMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateProjectEditorDialog.this.addRebootMenuItemActionPerformed(evt);
            }
        });
        this.addActionPopupMenu.add(this.addRebootMenuItem);
        this.addRegistryMenuItem.setText("Write Registry");
        this.addRegistryMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateProjectEditorDialog.this.addRegistryMenuItemActionPerformed(evt);
            }
        });
        this.addActionPopupMenu.add(this.addRegistryMenuItem);
        this.addTelnetMenuItem.setText("Telnet Command");
        this.addTelnetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateProjectEditorDialog.this.addTelnetMenuItemActionPerformed(evt);
            }
        });
        this.addActionPopupMenu.add(this.addTelnetMenuItem);
        this.addUpdateSeries4OsMenuItem.setText("Update Series 4 OS");
        this.addUpdateSeries4OsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateProjectEditorDialog.this.addUpdateSeries4OsMenuItemActionPerformed(evt);
            }
        });
        this.addActionPopupMenu.add(this.addUpdateSeries4OsMenuItem);
        this.addUpldateSeries3OsMenuItem.setText("Upload File");
        this.addUpldateSeries3OsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateProjectEditorDialog.this.addUpldateSeries3OsMenuItemActionPerformed(evt);
            }
        });
        this.addActionPopupMenu.add(this.addUpldateSeries3OsMenuItem);
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(new Dimension(800, 600));
        this.jPanel6.setLayout(new BorderLayout());
        this.jScrollPane2.setPreferredSize(new Dimension(300, 130));
        this.updateStepList.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.updateStepList.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.updateStepList);
        this.jPanel6.add((Component)this.jScrollPane2, "Center");
        this.moveStepUp.setText("UP");
        this.moveStepUp.setEnabled(false);
        this.moveStepUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateProjectEditorDialog.this.moveStepUpActionPerformed(evt);
            }
        });
        this.moveStepDown.setText("DN");
        this.moveStepDown.setEnabled(false);
        this.moveStepDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateProjectEditorDialog.this.moveStepDownActionPerformed(evt);
            }
        });
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.moveStepUp).addComponent(this.moveStepDown)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addGap(103, 103, 103).addComponent(this.moveStepUp).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.moveStepDown).addContainerGap()));
        this.jPanel6.add((Component)this.jPanel7, "After");
        this.getContentPane().add((Component)this.jPanel6, "West");
        this.jPanel1.setLayout(new BorderLayout());
        this.addProjectStep.setText("Add");
        this.addProjectStep.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                UpdateProjectEditorDialog.this.addProjectStepMouseClicked(evt);
            }
        });
        this.jPanel3.add(this.addProjectStep);
        this.removeStepButton.setText("Remove");
        this.removeStepButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateProjectEditorDialog.this.removeStepButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.removeStepButton);
        this.jPanel1.add((Component)this.jPanel3, "West");
        this.packageButton.setText("Package");
        this.packageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateProjectEditorDialog.this.packageButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.packageButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateProjectEditorDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.cancelButton);
        this.jPanel1.add((Component)this.jPanel2, "East");
        this.jPanel5.setPreferredSize(new Dimension(529, 10));
        this.jPanel1.add((Component)this.jPanel5, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Last");
        this.jPanel4.setMinimumSize(new Dimension(41, 100));
        this.jLabel1.setText("Title");
        this.jPanel4.add(this.jLabel1);
        this.titleTextField.setPreferredSize(new Dimension(300, 20));
        this.jPanel4.add(this.titleTextField);
        this.getContentPane().add((Component)this.jPanel4, "First");
        this.propertiesScrollPane.setBorder(null);
        this.getContentPane().add((Component)this.propertiesScrollPane, "Center");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this._result = 1;
        this.setVisible(false);
    }

    private void packageButtonActionPerformed(ActionEvent evt) {
        DetailsFileChooser fileChooser = new DetailsFileChooser();
        File file = new File(this.titleTextField.getText() + ".zip");
        fileChooser.setSelectedFile(file);
        if (null != this._originalUpdateProjectFile) {
            fileChooser.setCurrentDirectory(new File(this._originalUpdateProjectFile.getParent()));
        } else {
            fileChooser.setCurrentDirectory(new File(UpdateTab.UPDATE_PROJECTS_FOLDER));
        }
        int result = fileChooser.showSaveDialog(this);
        if (0 == result) {
            try {
                this._resultFile = fileChooser.getSelectedFile();
                File tempFile = null != this._updateProjectFile.getFile() ? this._updateProjectFile.getFile() : File.createTempFile("newupdateproject_", ".tmp", SupporterMain.getTempDirectory());
                this._updateProjectFile.setFile(tempFile);
                this._updateProjectFile.save(tempFile);
                this.setVisible(false);
                if (this._resultFile.exists()) {
                    this._resultFile.delete();
                }
                this._updateProjectFile.getFile().renameTo(this._resultFile);
                this._result = 0;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void moveStepUpActionPerformed(ActionEvent evt) {
        int selectedIndex = this.updateStepList.getSelectedIndex();
        ProjectStep projectStep = (ProjectStep)this._model.elementAt(selectedIndex);
        int newIndex = selectedIndex - 1;
        this._updateProjectFile.getSteps().remove(projectStep);
        this._updateProjectFile.getSteps().add(newIndex, projectStep);
        this._model.removeElement(projectStep);
        this._model.add(newIndex, projectStep);
        this.updateStepList.setSelectedIndex(newIndex);
        this.moveStepUp.setEnabled(0 < newIndex);
    }

    private void moveStepDownActionPerformed(ActionEvent evt) {
        int selectedIndex = this.updateStepList.getSelectedIndex();
        ProjectStep projectStep = (ProjectStep)this._model.elementAt(selectedIndex);
        int newIndex = selectedIndex + 1;
        this._updateProjectFile.getSteps().remove(projectStep);
        this._updateProjectFile.getSteps().add(newIndex, projectStep);
        this._model.removeElement(projectStep);
        this._model.add(newIndex, projectStep);
        this.updateStepList.setSelectedIndex(newIndex);
        this.moveStepDown.setEnabled(this._model.getSize() > newIndex + 1);
    }

    private void addUpdateSeries4OsMenuItemActionPerformed(ActionEvent evt) {
        FtpStep projectStep = new FtpStep("New Update Series 4 OS");
        this.addProjectStep(projectStep);
    }

    private void addProjectStepMouseClicked(MouseEvent evt) {
        this.addActionPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
    }

    private void addTelnetMenuItemActionPerformed(ActionEvent evt) {
        TelnetStep projectStep = new TelnetStep("New Telnet Action");
        this.addProjectStep(projectStep);
    }

    private void addRebootMenuItemActionPerformed(ActionEvent evt) {
        RebootStep projectStep = new RebootStep("New Reboot Action");
        this.addProjectStep(projectStep);
    }

    private void removeStepButtonActionPerformed(ActionEvent evt) {
        int selectedIndex = this.updateStepList.getSelectedIndex();
        ProjectStep projectStep = (ProjectStep)this._model.elementAt(selectedIndex);
        this._updateProjectFile.getSteps().remove(projectStep);
        this._model.removeElement(projectStep);
    }

    private void addCleanupMenuItemActionPerformed(ActionEvent evt) {
        CleanupStep projectStep = new CleanupStep("New Remove Files");
        this.addProjectStep(projectStep);
    }

    private void addFtpMenuItemActionPerformed(ActionEvent evt) {
        FtpStep projectStep = new FtpStep("New File Transfer");
        this.addProjectStep(projectStep);
    }

    private void addUpldateSeries3OsMenuItemActionPerformed(ActionEvent evt) {
    }

    private void addMkDirMenuItemActionPerformed(ActionEvent evt) {
        MkDirStep projectStep = new MkDirStep("New Make Directory");
        this.addProjectStep(projectStep);
    }

    private void addRegistryMenuItemActionPerformed(ActionEvent evt) {
        RegistryStep projectStep = new RegistryStep("New Registry Write");
        this.addProjectStep(projectStep);
    }

    private void addProjectStep(ProjectStep projectStep) {
        projectStep.setUpdateProject(this._updateProjectFile);
        this._model.addElement(projectStep);
        this._updateProjectFile.getSteps().add(projectStep);
        this.updateStepList.setSelectedIndex(this._updateProjectFile.getSteps().size() - 1);
        this.moveStepUp.setEnabled(true);
        this.moveStepDown.setEnabled(false);
    }
}

