/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.snapshot;

import com.integ.beacon.BeaconListener;
import com.integ.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.FileUtils;
import com.integ.supporter.ApplicationConfig;
import com.integ.supporter.RollingLog;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.beacon.DateStringComparator;
import com.integ.supporter.dialogs.JniorSelectionDialog;
import com.integ.supporter.dialogs.LoginDialog2;
import com.integ.supporter.helpers.IP4Validator;
import com.integ.supporter.snapshot.AnalyzeSnapshots;
import com.integ.supporter.snapshot.JniorSnapshotTab;
import com.integ.supporter.snapshot.Snapshot;
import com.integ.supporter.snapshot.SnapshotFile;
import com.integ.supporter.snapshot.SnapshotFileCollection;
import com.integ.supporter.snapshot.SnapshotInProgressCollection;
import com.integ.supporter.snapshot.SnapshotJniorSelectionTableModel;
import com.integ.supporter.snapshot.SnapshotListener;
import com.integ.supporter.snapshot.SnapshotLogFile;
import com.integ.supporter.snapshot.SnapshotMenu;
import com.integ.supporter.snapshot.SnapshotNeededAlertDialog;
import com.integ.supporter.snapshot.SnapshotResult;
import com.integ.supporter.snapshot.SnapshotTreeModel;
import com.integ.supporter.snapshot.ZipEntryNode;
import com.integ.supporter.snapshot.ZipFileNode;
import com.integ.supporter.snapshot.library.SnapshotLibrary;
import com.integ.supporter.snapshot.library.SnapshotLibraryEvent;
import com.integ.supporter.snapshot.library.SnapshotLibraryListener;
import com.integ.supporter.ui.PercentageTabbedPaneUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class SnapshotTab
extends JPanel
implements Runnable,
BeaconListener,
SnapshotListener {
    private static final Logger LOGGER = RollingLog.getLogger("SnapshotTab");
    private final SnapshotLibrary _snapshotLibrary;
    private boolean snapshotNeededAlertDialogShown = false;
    private SnapshotTreeModel _treeModel;
    private DefaultMutableTreeNode _rootNode;
    private final JMenuItem _abortMenuItem = new JMenuItem("Abort");
    private final JMenuItem _removeTabMenuItem = new JMenuItem("Remove Tab");
    private JButton abortToolbarButton;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JToolBar jToolBar1;
    private JTree jTree1;
    private JTabbedPane snapshotsTabPane;
    private JButton takeSnapshotToolbarButton;

    public SnapshotTab() {
        this.initComponents();
        this._snapshotLibrary = new SnapshotLibrary(SupporterMain.SNAPSHOTS_FOLDER);
        this._snapshotLibrary.addEventListener(new SnapshotLibraryListener(){

            @Override
            public void fileLoaded(SnapshotLibraryEvent snapshotLibraryEvent) {
                SnapshotFileCollection.add(snapshotLibraryEvent.getSnapshotFile());
                int count = SnapshotFileCollection.getCount();
                System.out.println("SnapshotFileCollection count = " + count);
            }

            @Override
            public void libraryLoaded(SnapshotLibraryEvent snapshotLibraryEvent) {
                SnapshotTab.this._treeModel.refresh();
                ArrayList snapshotFiles = SnapshotFileCollection.getCollection();
                ArrayList snapshotFiles2 = (ArrayList)snapshotFiles.clone();
                AnalyzeSnapshots.analyze(snapshotFiles2);
            }
        });
        JPopupMenu tabbedPanePopupMenu = this.createTabbedPanePopupMenu();
        this.snapshotsTabPane.setComponentPopupMenu(tabbedPanePopupMenu);
        this.snapshotsTabPane.setUI(new PercentageTabbedPaneUI());
        this.addTabChangeListener();
        this.addTreeMouseListener();
        JPopupMenu treePopupMenu = new JPopupMenu();
        JMenuItem openFolderLocationMenuItem = new JMenuItem("Show in Folder");
        openFolderLocationMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ZipFileNode selectedZipFileNode = (ZipFileNode)SnapshotTab.this.jTree1.getLastSelectedPathComponent();
                            File file = selectedZipFileNode.getFile();
                            File parentFolder = file.getParentFile();
                            boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
                            if (isWindows) {
                                Runtime.getRuntime().exec("explorer.exe /select," + file.getPath());
                            } else {
                                Desktop desktop = Desktop.getDesktop();
                                desktop.open(parentFolder);
                            }
                        }
                        catch (IOException | IllegalArgumentException ex) {
                            Logger.getLogger(SnapshotMenu.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
                        }
                    }
                });
            }
        });
        treePopupMenu.add(openFolderLocationMenuItem);
        this.jTree1.setComponentPopupMenu(treePopupMenu);
        this.snapshotsTabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SnapshotTab.this.updateMenuStatus();
            }
        });
        this.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent evt) {
                try {
                    evt.acceptDrop(1);
                    System.out.println("evt = " + evt);
                    Transferable transferable = evt.getTransferable();
                    List droppedFiles = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    for (File file : droppedFiles) {
                        SnapshotTab.this.doSnapshotAnalysis(file);
                        SnapshotTab.this._snapshotLibrary.addSnapshotFile(file);
                        SnapshotTab.this._treeModel.refresh();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport info) {
                return info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport info) {
                ArrayList data;
                if (!info.isDrop()) {
                    return false;
                }
                if (!info.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    this.displayDropLocation("List doesn't accept a drop of this type.");
                    return false;
                }
                Transferable t = info.getTransferable();
                try {
                    data = (ArrayList)t.getTransferData(DataFlavor.javaFileListFlavor);
                }
                catch (Exception e) {
                    return false;
                }
                for (Object file : data) {
                    System.out.println("file = " + file);
                }
                return true;
            }

            private void displayDropLocation(String string) {
                System.out.println(string);
            }
        });
        new Thread(this).start();
    }

    private void doSnapshotAnalysis(File file) {
        JTextArea textArea = null;
        SnapshotFile snapshotFile = null;
        SnapshotLogFile snapshotLogFile = null;
        try {
            textArea = new JTextArea();
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setViewportView(textArea);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)scrollPane, "Center");
            if (-1 == this.findTabByName(file.getName())) {
                boolean errorsLogExists;
                this.snapshotsTabPane.insertTab(file.getName(), null, jPanel, file.getName(), 0);
                this.snapshotsTabPane.setSelectedComponent(jPanel);
                snapshotFile = new SnapshotFile(file);
                snapshotLogFile = new SnapshotLogFile(snapshotFile);
                snapshotLogFile.analyze();
                System.out.println("snapshotLogFile.getSnapshotLogContent() = " + snapshotLogFile.getSnapshotLogContent());
                String supportToolVersion = snapshotLogFile.getSupportToolVersion();
                textArea.append("Support Tool Version = " + supportToolVersion + "\r\n\r\n");
                textArea.append("SerialNumber = " + snapshotLogFile.getSerialNumber() + "\r\n");
                textArea.append("Series = " + snapshotLogFile.getSeries() + "\r\n");
                textArea.append("Model = " + snapshotLogFile.getModel() + "\r\n\r\n");
                String osVersion = snapshotLogFile.getOsVersion();
                textArea.append("osVersion = " + osVersion + "\r\n\r\n");
                int recordUptime = snapshotLogFile.getRecordUptime();
                textArea.append("record uptime = " + recordUptime + " days\r\n\r\n");
                int totalUptime = snapshotLogFile.getTotalUptime();
                textArea.append("total uptime = " + totalUptime + " days\r\n\r\n");
                ArrayList<String> applications = snapshotLogFile.getApplications();
                textArea.append("applications:\r\n");
                for (String string : applications) {
                    textArea.append("  " + string + "\r\n");
                }
                textArea.append("\r\n");
                ArrayList<String> listeningPorts = snapshotLogFile.getListeningPorts();
                textArea.append("Listening Ports:\r\n");
                for (String listeningPort : listeningPorts) {
                    textArea.append("  " + listeningPort + "\r\n");
                }
                textArea.append("\r\n");
                boolean bl = snapshotFile.dumpLogExists();
                if (bl) {
                    textArea.append("dump.log exists!\r\n");
                }
                if (errorsLogExists = snapshotFile.errorsLogExists()) {
                    textArea.append("errors.log exists!\r\n");
                }
            }
        }
        catch (Exception ex) {
            if (null != snapshotFile) {
                textArea.append("error with snapshotFile = " + snapshotFile.getFile().getPath() + "\r\n");
                if (null != snapshotLogFile) {
                    textArea.append(snapshotLogFile.getSnapshotLogContent() + "\r\n");
                }
            }
            ex.printStackTrace();
            Logger.getLogger(AnalyzeSnapshots.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
        }
    }

    public int findTabByName(String title) {
        int tabCount = this.snapshotsTabPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            String tabTitle = this.snapshotsTabPane.getTitleAt(i);
            if (!tabTitle.equals(title)) continue;
            return i;
        }
        return -1;
    }

    private void addTabChangeListener() {
        this.snapshotsTabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component selectedComponent = SnapshotTab.this.snapshotsTabPane.getSelectedComponent();
                if (null != selectedComponent && SnapshotTab.this.snapshotsTabPane.getSelectedComponent() instanceof JniorSnapshotTab) {
                    JniorSnapshotTab jniorSnapshotTab = (JniorSnapshotTab)selectedComponent;
                    SnapshotTab.this.abortToolbarButton.setEnabled(!jniorSnapshotTab.isComplete());
                }
            }
        });
    }

    private void addTreeMouseListener() {
        this.jTree1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selectedRow = SnapshotTab.this.jTree1.getRowForLocation(e.getX(), e.getY());
                TreePath selelectedPath = SnapshotTab.this.jTree1.getPathForLocation(e.getX(), e.getY());
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selelectedPath.getLastPathComponent();
                if (-1 != selectedRow) {
                    ZipFileNode zipFileNode;
                    File file;
                    if (2 == e.getClickCount()) {
                        try {
                            if (!(treeNode instanceof ZipFileNode) && treeNode instanceof ZipEntryNode && treeNode.isLeaf()) {
                                ZipEntryNode contentNode = (ZipEntryNode)treeNode;
                                byte[] contents = contentNode.getContents();
                                String tempFileName = String.format("%s%s", SupporterMain.TEMP_DIRECTORY, contentNode.toString());
                                FileUtils.writeAllBytes(tempFileName, contents);
                                Desktop desktop = Desktop.getDesktop();
                                desktop.open(new File(tempFileName));
                            }
                        }
                        catch (Exception ex) {
                            Logger.getLogger(SnapshotMenu.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
                        }
                    } else if (treeNode instanceof ZipFileNode && (file = (zipFileNode = (ZipFileNode)treeNode).getFile()).exists()) {
                        SnapshotTab.this.doSnapshotAnalysis(file);
                    }
                }
            }
        });
    }

    private void updateMenuStatus() {
        JniorSnapshotTab jniorSnapshotTab = this.getSelectedSnapshotTab();
        if (null != jniorSnapshotTab) {
            boolean isRunning = !jniorSnapshotTab.isComplete();
            this.abortToolbarButton.setEnabled(isRunning);
        }
    }

    @Override
    public void run() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        SnapshotTab snapshotTab = this;
        synchronized (snapshotTab) {
            try {
                File fileRoot = new File(SupporterMain.SNAPSHOTS_FOLDER);
                this._rootNode = new DefaultMutableTreeNode(new FileNode(fileRoot, true));
                this._treeModel = new SnapshotTreeModel(this._rootNode, this._snapshotLibrary);
                this.jTree1.setModel(this._treeModel);
                this.jTree1.setShowsRootHandles(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void loginFailed() {
    }

    @Override
    public void downloadFileAttempt(int index, int total, String remoteFileName) {
    }

    @Override
    public void downloadFileResult(int index, int total, String remoteFileName, boolean result) {
    }

    @Override
    public void snapshotResult(Snapshot snapshot, SnapshotResult result) {
        JniorSnapshotTab selectedSnapshotTab = this.getSelectedSnapshotTab();
        if (null != selectedSnapshotTab) {
            File snapshotZipFile;
            this.abortToolbarButton.setEnabled(!selectedSnapshotTab.isComplete());
            if (SnapshotResult.Success == result && null != (snapshotZipFile = snapshot.getZipFile())) {
                this._snapshotLibrary.addSnapshotFile(snapshotZipFile);
                this._treeModel.refresh();
            }
            this.updateTitle();
        }
    }

    @Override
    public void unitUpdated(JniorInfo jniorInfo) {
        System.out.println(String.format("%s has been announced, the last snapshot was taken: %s", jniorInfo.getSerialNumber(), new Date()));
    }

    public void startSnapshot(JniorInfo jniorInfo) {
        JniorSnapshotTab jniorSnapshotTab = new JniorSnapshotTab(jniorInfo);
        jniorSnapshotTab.setSnapshotListener(this);
        if (SnapshotInProgressCollection.startSnapshot(jniorInfo, jniorSnapshotTab)) {
            this.snapshotsTabPane.insertTab("Snapshot - " + jniorInfo.IpAddress, null, jniorSnapshotTab, "Taking a snapshot of " + jniorInfo.IpAddress, 0);
            this.snapshotsTabPane.setSelectedComponent(jniorSnapshotTab);
            jniorSnapshotTab.start();
            this.updateTitle();
        }
        this.updateMenuStatus();
    }

    public void updateTitle() {
        String title = "Snapshot";
        int count = SnapshotInProgressCollection.getInProgressCount();
        if (0 < count) {
            title = String.format("Snapshot (%d)", count);
        }
        SupporterMain.setTabTitle(this, title);
    }

    private JPopupMenu createTabbedPanePopupMenu() {
        System.out.println(String.format("%s create popup menu", this.getClass().getName()));
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setMinimumSize(new Dimension(200, 1));
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                System.out.println(String.format("%s popup will become visible", this.getClass().getName()));
                JniorSnapshotTab selectedSnapshotTab = SnapshotTab.this.getSelectedSnapshotTab();
                if (null != selectedSnapshotTab) {
                    SnapshotTab.this._abortMenuItem.setEnabled(!selectedSnapshotTab.isComplete());
                    SnapshotTab.this._removeTabMenuItem.setEnabled(selectedSnapshotTab.isComplete());
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this._abortMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JniorSnapshotTab jniorSnapshotTab = SnapshotTab.this.getSelectedSnapshotTab();
                if (null != jniorSnapshotTab) {
                    jniorSnapshotTab.abort();
                }
            }
        });
        popupMenu.add(this._abortMenuItem);
        this._removeTabMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component selectedTabComponent = SnapshotTab.this.snapshotsTabPane.getSelectedComponent();
                SnapshotTab.this.snapshotsTabPane.remove(selectedTabComponent);
            }
        });
        popupMenu.add(this._removeTabMenuItem);
        return popupMenu;
    }

    public JniorSnapshotTab getSelectedSnapshotTab() {
        JniorSnapshotTab selectedTabbedPane = null;
        Component selectedComponent = this.snapshotsTabPane.getSelectedComponent();
        if (null != selectedComponent && this.snapshotsTabPane.getSelectedComponent() instanceof JniorSnapshotTab) {
            selectedTabbedPane = (JniorSnapshotTab)this.snapshotsTabPane.getSelectedComponent();
        }
        return selectedTabbedPane;
    }

    public void removeCompleted() {
        for (int i = 0; i < this.snapshotsTabPane.getTabCount(); ++i) {
            JniorSnapshotTab jniorSnapshotTab;
            Component component = this.snapshotsTabPane.getComponentAt(i);
            if (!(component instanceof JniorSnapshotTab) || !(jniorSnapshotTab = (JniorSnapshotTab)component).isComplete()) continue;
            this.snapshotsTabPane.remove(jniorSnapshotTab);
            --i;
        }
    }

    public void shouldShowSnapshotNeededNotification() {
        if (System.currentTimeMillis() >= ApplicationConfig.getNextSnapshotAlertTime() && !this.snapshotNeededAlertDialogShown) {
            this.snapshotNeededAlertDialogShown = true;
            SnapshotNeededAlertDialog dialog = new SnapshotNeededAlertDialog(null, true);
            dialog.setVisible(true);
        }
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.snapshotsTabPane = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.takeSnapshotToolbarButton = new JButton();
        this.abortToolbarButton = new JButton();
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerLocation(500);
        this.jScrollPane1.setViewportView(this.jTree1);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.snapshotsTabPane.setTabPlacement(4);
        this.jSplitPane1.setRightComponent(this.snapshotsTabPane);
        this.add((Component)this.jSplitPane1, "Center");
        this.jPanel1.setLayout(new FlowLayout(0));
        this.jToolBar1.setBorder(null);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.takeSnapshotToolbarButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/disk.png")));
        this.takeSnapshotToolbarButton.setText("Take Snapshot");
        this.takeSnapshotToolbarButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.takeSnapshotToolbarButton.setFocusable(false);
        this.takeSnapshotToolbarButton.setVerticalTextPosition(3);
        this.takeSnapshotToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnapshotTab.this.takeSnapshotToolbarButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.takeSnapshotToolbarButton);
        this.abortToolbarButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/stop.png")));
        this.abortToolbarButton.setText("Abort");
        this.abortToolbarButton.setToolTipText("Close");
        this.abortToolbarButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.abortToolbarButton.setEnabled(false);
        this.abortToolbarButton.setFocusable(false);
        this.abortToolbarButton.setVerticalTextPosition(3);
        this.abortToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnapshotTab.this.abortToolbarButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.abortToolbarButton);
        this.jPanel1.add(this.jToolBar1);
        this.add((Component)this.jPanel1, "First");
    }

    private void abortToolbarButtonActionPerformed(ActionEvent evt) {
        JniorSnapshotTab selectedSnapshot = this.getSelectedSnapshotTab();
        if (null != selectedSnapshot) {
            selectedSnapshot.abort();
        }
    }

    private void takeSnapshotToolbarButtonActionPerformed(ActionEvent evt) {
        JniorInfo[] selectedJniors;
        JniorSelectionDialog dlg = new JniorSelectionDialog(null, new SnapshotJniorSelectionTableModel());
        dlg.addRowSorter(6, new DateStringComparator());
        dlg.setMinimumSize(new Dimension(1200, 600));
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
        for (JniorInfo selectedRemoteJniorInfo : selectedJniors = dlg.getSelectedJniors()) {
            this.startSnapshot(selectedRemoteJniorInfo);
        }
        String manuallyEnteredIPAddress = dlg.getManuallyEneteredIPAddress();
        if (IP4Validator.isValid(manuallyEnteredIPAddress)) {
            JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(this);
            LoginDialog2 loginDialog = new LoginDialog2((Frame)topFrame, true);
            loginDialog.setTitle("Snapshot for " + manuallyEnteredIPAddress + " needs credentials");
            loginDialog.centerParent();
            loginDialog.setVisible(true);
            if (loginDialog.getResult() == 1) {
                JniorInfo jniorInfo = new JniorInfo(0);
                jniorInfo.IpAddress = manuallyEnteredIPAddress;
                jniorInfo.UserName = loginDialog.getUsername();
                jniorInfo.Password = loginDialog.getPassword();
                this.startSnapshot(jniorInfo);
            }
        }
    }

    public class FileNode {
        private File file;
        private boolean showFullPath = false;

        public FileNode(File file) {
            this.file = file;
        }

        public FileNode(File file, boolean showFullPath) {
            this.file = file;
            this.showFullPath = showFullPath;
        }

        public String toString() {
            String name = this.file.getName();
            if (name.equals("") || this.showFullPath) {
                return this.file.getAbsolutePath();
            }
            return name;
        }
    }
}

