/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema.macro;

import com.integ.beacon.JniorInfo;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.cinema.macro.LocalMacroFile;
import com.integ.supporter.cinema.macro.MacroFile;
import com.integ.supporter.cinema.macro.MacroTab;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.JTabbedPane;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class RemoteMacroFile
extends MacroFile {
    private Logger _logger = Logger.getGlobal();
    private final JniorInfo _jniorInfo;
    private FTPClient _ftpClient;
    private File _localTempMacroFile;
    private LocalMacroFile _macroFile;

    public RemoteMacroFile(JniorInfo jniorInfo) {
        this._jniorInfo = jniorInfo;
        try {
            this._ftpClient = new FTPClient();
            this._ftpClient.connect(this._jniorInfo.IpAddress, 21);
            int reply = this._ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion(reply)) {
                this._ftpClient.disconnect();
                throw new IOException("Exception in connecting to FTP Server");
            }
            this._logger.info("  logging into ftp client...");
            if (this._ftpClient.login(this._jniorInfo.UserName, this._jniorInfo.Password)) {
                String remoteMacroFilePath;
                FTPFile[] fileEntries;
                this._logger.info("  ftp client ready.");
                ArrayList<String> macroFiles = new ArrayList<String>();
                for (FTPFile ftpFile : fileEntries = this._ftpClient.listFiles("/")) {
                    if (!ftpFile.getName().startsWith("macro") || !ftpFile.getName().endsWith(".csv")) continue;
                    macroFiles.add(ftpFile.getName());
                }
                if (1 == macroFiles.size() && this.downloadMacroFile(remoteMacroFilePath = (String)macroFiles.get(0))) {
                    LocalMacroFile macroFile = new LocalMacroFile(this._localTempMacroFile);
                    MacroTab macroTab = new MacroTab(macroFile);
                    JTabbedPane tabbedPane = SupporterMain.getTabPane();
                    String title = String.format("Remote Macro - %s", macroFile.getTitle());
                    int tabCount = tabbedPane.getTabCount();
                    tabbedPane.insertTab(title, null, macroTab, title, tabCount);
                    tabbedPane.setSelectedIndex(tabCount);
                }
            }
        }
        catch (Exception ex) {
            this._logger.severe(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadMacroFile(String remoteMacroFilePath) {
        FileOutputStream fileOutputStream = null;
        try {
            File tempDirectory = SupporterMain.getTempDirectory();
            File jniorTempDirectory = new File(SupporterMain.TEMP_DIRECTORY + File.separator + this._jniorInfo.getSerialNumber());
            if (!jniorTempDirectory.exists()) {
                jniorTempDirectory.mkdir();
            }
            this._localTempMacroFile = new File(jniorTempDirectory.getPath() + File.separator + remoteMacroFilePath);
            fileOutputStream = new FileOutputStream(this._localTempMacroFile);
            boolean bl = this._ftpClient.retrieveFile(remoteMacroFilePath, fileOutputStream);
            return bl;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(RemoteMacroFile.class.getName()).severe(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            Logger.getLogger(RemoteMacroFile.class.getName()).severe(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException ex) {
                Logger.getLogger(RemoteMacroFile.class.getName()).severe(ex.getMessage());
            }
        }
    }

    @Override
    public void save() throws IOException {
    }
}

