/*
 * Decompiled with CFR 0.152.
 */
package com.integ.beacon;

import com.integ.beacon.BeaconListener;
import com.integ.beacon.JniorCollection;
import com.integ.beacon.JniorInfo;
import com.integ.beacon.Version;
import com.integ.beacon.commands.BeaconCommand;
import com.integ.beacon.commands.QueryAllCommand;
import com.integ.janoslib.net.IClient;
import com.integ.janoslib.net.UdpConnectionListener;
import com.integ.janoslib.net.UdpServer;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.HexUtils;
import com.integ.janoslib.utils.NetworkUtils;
import com.integ.supporter.RollingLog;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class Beacon
implements UdpConnectionListener {
    public static final Logger LOGGER = RollingLog.getLogger("Beacon");
    private static final Beacon INSTANCE = new Beacon();
    private final int _port = 4444;
    private final UdpServer _udpServer = new UdpServer(4444);
    private final ArrayList<BeaconListener> _beaconListeners = new ArrayList();
    private final ArrayList<InetAddress> _broadcastAddresses = new ArrayList();
    private final ArrayList<JniorInfo> _jniorListing = new ArrayList();
    private final Hashtable<InetAddress, JniorInfo> _queriedJniors = new Hashtable();

    public static Beacon getInstance() {
        return INSTANCE;
    }

    private Beacon() {
        this._jniorListing.add(new JniorInfo(0).setPublicHostAddress("dyndns.dodecabogey.com"));
        this._jniorListing.add(new JniorInfo(0).setPublicHostAddress("10.0.0.255"));
    }

    static ArrayList<InetAddress> getBroadcastAddressesFor(NetworkInterface networkInterface) {
        ArrayList<InetAddress> allInetAddresses = new ArrayList<InetAddress>();
        List<InterfaceAddress> interfaceAddresses = networkInterface.getInterfaceAddresses();
        for (InterfaceAddress interfaceAddress : interfaceAddresses) {
            InetAddress broadcastInetAddress = interfaceAddress.getBroadcast();
            if (null == broadcastInetAddress) continue;
            LOGGER.info(String.format("Add %s to broadcast addresses", broadcastInetAddress));
            allInetAddresses.add(broadcastInetAddress);
        }
        return allInetAddresses;
    }

    static void displayInterfaceInformation(NetworkInterface networkInterface) throws SocketException {
        ArrayList<InetAddress> inetAddresses = Collections.list(networkInterface.getInetAddresses());
        if (0 < inetAddresses.size()) {
            LOGGER.info(String.format("Display name: %s", networkInterface.getDisplayName()));
            LOGGER.info(String.format("   Name: %s", networkInterface.getName()));
            LOGGER.info(String.format("   Is Up: %s", networkInterface.isUp()));
            LOGGER.info(String.format("   Is Loopback: %s", networkInterface.isLoopback()));
            LOGGER.info(String.format("   Is Virtual: %s", networkInterface.isVirtual()));
            LOGGER.info(String.format("   Is Point to Point: %s", networkInterface.isPointToPoint()));
            LOGGER.info(String.format("   Interface Count: %d", networkInterface.getInterfaceAddresses().size()));
            for (InetAddress inetAddress : inetAddresses) {
                LOGGER.info(String.format("   InetAddress: %s", inetAddress));
            }
            List<InterfaceAddress> interfaceAddresses = networkInterface.getInterfaceAddresses();
            for (InterfaceAddress interfaceAddress : interfaceAddresses) {
                InetAddress broadcasInetAddress = interfaceAddress.getBroadcast();
                if (null == broadcasInetAddress) continue;
                short subnetMaskBitLength = interfaceAddress.getNetworkPrefixLength();
                LOGGER.info(String.format("   broadcasInetAddress: %s/%d", broadcasInetAddress, (int)subnetMaskBitLength));
            }
            ArrayList<NetworkInterface> arrayList = Collections.list(networkInterface.getSubInterfaces());
            LOGGER.info(String.format("   SubInterface count: %d", arrayList.size()));
        }
    }

    public void start() {
        this._udpServer.setLog(LOGGER);
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface networkInterface : Collections.list(nets)) {
                if (networkInterface.isLoopback() || !networkInterface.isUp() || networkInterface.isPointToPoint()) continue;
                Beacon.displayInterfaceInformation(networkInterface);
                ArrayList<InetAddress> broadcastAddressesForInterface = Beacon.getBroadcastAddressesFor(networkInterface);
                this._broadcastAddresses.addAll(broadcastAddressesForInterface);
            }
            try {
                this._broadcastAddresses.add(InetAddress.getByName("255.255.255.255"));
            }
            catch (UnknownHostException ex) {
                LOGGER.severe(ExceptionUtils.getStackTrace(ex));
            }
            for (InetAddress broadcastAddress : this._broadcastAddresses) {
                LOGGER.info("broadcast address: " + broadcastAddress);
            }
        }
        catch (SocketException ex) {
            String stacktrace = ExceptionUtils.getStackTrace(ex);
            LOGGER.severe(stacktrace);
        }
        this._udpServer.setListener(this);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                    Beacon.this._udpServer.start();
                }
                catch (InterruptedException ex) {
                    String stacktrace = ExceptionUtils.getStackTrace(ex);
                    LOGGER.severe(stacktrace);
                }
            }
        });
        thread.setName(this.getClass().getName());
        thread.setDaemon(true);
        thread.start();
    }

    public void addBeaconListener(BeaconListener beaconListener) {
        this._beaconListeners.add(beaconListener);
    }

    public void removeBeaconListener(BeaconListener beaconListener) {
        this._beaconListeners.remove(beaconListener);
    }

    @Override
    public void serverListening() {
        LOGGER.info("Listening for clients on udp port 4444.");
        this.broadcastCommand(new QueryAllCommand());
        for (JniorInfo additionalJniorInfo : this._jniorListing) {
            try {
                InetAddress inetAddress = InetAddress.getByName(additionalJniorInfo.getPublicHostAddress());
                this._queriedJniors.put(inetAddress, additionalJniorInfo);
                this.send(inetAddress, additionalJniorInfo.BeaconPort, new QueryAllCommand());
            }
            catch (IOException ex) {
                Logger.getLogger(Beacon.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void processMessage(IClient client, DatagramPacket packet) {
        block13: {
            byte[] message = packet.getData();
            InetAddress senderAddress = packet.getAddress();
            try {
                InetAddress localAddress = NetworkUtils.getLocalAddressFor(senderAddress);
                if (null != localAddress && localAddress.equals(senderAddress)) {
                    return;
                }
                if (null == localAddress) {
                    System.out.println("device is not accessible from the local machine");
                }
            }
            catch (SocketException ex) {
                Logger.getLogger(Beacon.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
            }
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(message);
                DataInputStream dis = new DataInputStream(bais);
                int length = dis.readUnsignedShort();
                int serialNumber = dis.readInt() & 0xFFFFFFFF;
                JniorInfo jniorInfo = null;
                if (this._queriedJniors.containsKey(senderAddress)) {
                    jniorInfo = this._queriedJniors.remove(senderAddress);
                    jniorInfo.setSerialNumber(serialNumber);
                } else {
                    jniorInfo = JniorCollection.getJniorInfoBySerialNumber(serialNumber);
                }
                String command = Beacon.readString(dis);
                InetAddress localAddress = NetworkUtils.getLocalAddressFor(senderAddress);
                jniorInfo.AccessibleFromLocalMachine = null != localAddress;
                jniorInfo.LastAnnounced = new Date();
                System.out.println("command: " + command);
                try {
                    if ("i_am_jnior".equalsIgnoreCase(command)) {
                        byte[] announcementBytes = new byte[length - 4 - command.length() - 2];
                        dis.read(announcementBytes);
                        this.processAnnouncement(announcementBytes, jniorInfo);
                        jniorInfo.Status = 0;
                        this.fireUnitUpdated(jniorInfo);
                        break block13;
                    }
                    if ("all_info".equalsIgnoreCase(command)) {
                        byte[] announcementBytes = new byte[length - 4 - command.length() - 2];
                        dis.read(announcementBytes);
                        this.processAllInfo(announcementBytes, jniorInfo);
                        jniorInfo.notifyInfo();
                        break block13;
                    }
                    if ("death".equalsIgnoreCase(command)) {
                        jniorInfo.Status = 2;
                        this.fireUnitUpdated(jniorInfo);
                        break block13;
                    }
                    System.out.println("");
                }
                catch (Exception ex) {
                    String stacktrace = ExceptionUtils.getStackTrace(ex);
                    LOGGER.severe(stacktrace);
                }
            }
            catch (IOException ex) {
                String stacktrace = ExceptionUtils.getStackTrace(ex);
                LOGGER.severe(stacktrace);
            }
        }
    }

    public void broadcastCommand(BeaconCommand beaconCommand) {
        try {
            LOGGER.info(String.format("broadcasting %s\r\n%s", beaconCommand.getClass().getName(), HexUtils.hexDump(beaconCommand.getBytes(), 0, beaconCommand.getBytes().length)));
            for (InetAddress broadcastAddress : this._broadcastAddresses) {
                this.send(broadcastAddress, 4444, beaconCommand);
            }
        }
        catch (SocketException ex) {
            String stacktrace = ExceptionUtils.getStackTrace(ex);
            LOGGER.severe(stacktrace);
        }
    }

    public void send(final InetAddress inetAddress, final int port, final BeaconCommand beaconCommand) throws SocketException {
        if (null == inetAddress) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                byte[] beaconMessageBytes = beaconCommand.getBytes();
                DatagramPacket packet = new DatagramPacket(beaconMessageBytes, beaconMessageBytes.length, inetAddress, port);
                try {
                    DatagramSocket socket = new DatagramSocket();
                    try {
                        socket.send(packet);
                        LOGGER.info(String.format("sending %s to %s", beaconCommand.getClass().getName(), inetAddress));
                        socket.setSoTimeout(250);
                        while (true) {
                            packet = new DatagramPacket(new byte[1024], 1024);
                            socket.receive(packet);
                            socket.setSoTimeout(10);
                            Beacon.this.processMessage(Beacon.this._udpServer, packet);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SocketTimeoutException socket) {
                }
                catch (Exception ex2) {
                    IOException ex2 = new IOException("error sending " + beaconCommand.getClass().getName() + " to " + inetAddress, ex2);
                    String stacktrace = ExceptionUtils.getStackTrace(ex2);
                    LOGGER.severe(stacktrace);
                }
            }
        }).start();
    }

    public static String readString(DataInputStream dis) throws IOException {
        int length = dis.readUnsignedShort();
        byte[] stringBytes = new byte[length];
        dis.read(stringBytes);
        return new String(stringBytes);
    }

    private JniorInfo processAnnouncement(byte[] announcementBytes, JniorInfo jniorInfo) {
        String dateString = null;
        try {
            byte[] buildTagBytes;
            int bytesRead;
            ByteArrayInputStream bais = new ByteArrayInputStream(announcementBytes);
            DataInputStream dis = new DataInputStream(bais);
            jniorInfo.AutoAnnounce = dis.readBoolean();
            jniorInfo.IpAddress = Beacon.readString(dis);
            jniorInfo.SubnetMask = Beacon.readString(dis);
            jniorInfo.Hostname = Beacon.readString(dis);
            jniorInfo.PhysicalAddress = Beacon.readString(dis);
            jniorInfo.OsVersion = Version.parse(Beacon.readString(dis));
            jniorInfo.ProtocolPort = dis.readUnsignedShort();
            dateString = Beacon.readString(dis);
            try {
                SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("EEE MMM d HH:mm:ss Z yyyy");
                jniorInfo.BootTime = SIMPLE_DATE_FORMAT.parse(dateString);
            }
            catch (Exception ex) {
                Exception ex3 = new Exception("Could not parse " + dateString, ex);
                ex3.printStackTrace();
                String stacktrace = ExceptionUtils.getStackTrace(ex3);
                LOGGER.severe(stacktrace);
                LOGGER.severe("processAnnouncement:\n" + HexUtils.hexDump(announcementBytes, 0, announcementBytes.length));
            }
            if (0 < dis.available()) {
                boolean ex = dis.readBoolean();
            }
            if (0 < dis.available()) {
                jniorInfo.AttentionInfo = dis.readByte();
            }
            if (0 < dis.available()) {
                long utcDate = dis.readLong();
                jniorInfo.CurrentTime = new Date(utcDate);
            }
            if (0 < dis.available()) {
                short utcDate = dis.readShort();
            }
            if (0 < dis.available() && 6 == (bytesRead = dis.read(buildTagBytes = new byte[6]))) {
                Version versionFromBuildTagString = Version.getVersionFromBuildTag(HexUtils.bytesToHex(buildTagBytes));
                System.out.println("versionFromBuildTagString = " + versionFromBuildTagString);
                jniorInfo.OsVersion = versionFromBuildTagString;
            }
            return jniorInfo;
        }
        catch (Exception ex) {
            Exception ex2 = new Exception(jniorInfo.getSerialNumber() + " error", ex);
            String stacktrace = ExceptionUtils.getStackTrace(ex2);
            LOGGER.severe(stacktrace);
            LOGGER.severe("processAnnouncement:\n" + HexUtils.hexDump(announcementBytes, 0, announcementBytes.length));
            return null;
        }
    }

    private JniorInfo processAllInfo(byte[] announcementBytes, JniorInfo jniorInfo) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(announcementBytes);
            DataInputStream dis = new DataInputStream(bais);
            jniorInfo.Gateway = Beacon.readString(dis);
            jniorInfo.PrimaryDns = Beacon.readString(dis);
            jniorInfo.SecondaryDns = Beacon.readString(dis);
            jniorInfo.DnsTimeout = dis.readInt();
            jniorInfo.DhcpServer = Beacon.readString(dis);
            jniorInfo.DomainName = Beacon.readString(dis);
            jniorInfo.Timezone = Beacon.readString(dis);
            jniorInfo.DhcpEnabled = dis.readBoolean();
            if (0 < dis.available()) {
                jniorInfo.Nonce = Beacon.readString(dis);
            }
            jniorInfo.LastAnnounced = new Date();
            return jniorInfo;
        }
        catch (Exception ex) {
            Exception ex2 = new Exception(jniorInfo.getSerialNumber() + " error", ex);
            String stacktrace = ExceptionUtils.getStackTrace(ex2);
            LOGGER.severe(stacktrace);
            LOGGER.severe("processAllInfo:\n" + HexUtils.hexDump(announcementBytes, 0, announcementBytes.length));
            return null;
        }
    }

    private void fireUnitUpdated(JniorInfo jniorInfo) {
        for (BeaconListener beaconListener : this._beaconListeners) {
            beaconListener.unitUpdated(jniorInfo);
            JSONObject json = jniorInfo.toJSON();
            JniorInfo jniorInfo2 = JniorInfo.fromJSON(json);
        }
    }
}

