/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.janoslib.net.beacon.BeaconNetworkInterface;
import com.integ.janoslib.utils.ExceptionUtils;
import java.awt.Component;
import java.awt.Frame;
import java.net.InterfaceAddress;
import java.net.SocketException;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class ShowNetworkInterfacesDialog
extends JDialog {
    private JScrollPane jScrollPane1;
    private JTextPane txtPane;

    public ShowNetworkInterfacesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        StringBuilder stringBuffer = new StringBuilder();
        try {
            this.initComponents();
            ArrayList<BeaconNetworkInterface> beaconInterfaces = BeaconNetworkInterface.getBeaconInterfaces();
            for (BeaconNetworkInterface beaconNetworkInterface : beaconInterfaces) {
                stringBuffer.append(String.format("Network Interface: %s\n", beaconNetworkInterface.getNetworkInterface().getDisplayName()));
                ArrayList<InterfaceAddress> interfaceAddresses = beaconNetworkInterface.getInterfaceAddresses();
                for (int i = 0; i < interfaceAddresses.size(); ++i) {
                    InterfaceAddress interfaceAddress = interfaceAddresses.get(i);
                    stringBuffer.append(String.format("  IP Address %d: %s/%d\n", i + 1, interfaceAddress.getAddress().getHostAddress(), interfaceAddress.getNetworkPrefixLength()));
                }
            }
        }
        catch (SocketException ex) {
            stringBuffer.append(ex.getMessage());
            stringBuffer.append("\n");
            stringBuffer.append(ExceptionUtils.getStackTrace(ex));
        }
        this.txtPane.setText(stringBuffer.toString());
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.txtPane = new JTextPane();
        this.setDefaultCloseOperation(2);
        this.setTitle("Network Interfaces");
        this.jScrollPane1.setViewportView(this.txtPane);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }
}

