/*
 * Decompiled with CFR 0.152.
 */
package com.integ.protocols.websockets;

import java.io.DataInputStream;
import java.io.IOException;

class WebSocketFrame {
    private final DataInputStream _dataInputStream;
    private boolean _isFin = false;
    private int _opCode;
    private byte[] _bytes;

    static WebSocketFrame getFrame(DataInputStream dataInputStream) throws IOException {
        WebSocketFrame webSocketFrame = new WebSocketFrame(dataInputStream);
        webSocketFrame.process();
        return webSocketFrame;
    }

    private WebSocketFrame(DataInputStream dataInputStream) {
        this._dataInputStream = dataInputStream;
    }

    public void process() throws IOException {
        byte byte1 = this._dataInputStream.readByte();
        this._isFin = 1 == (byte1 >> 7 & 1);
        this._opCode = byte1 & 0xF;
        byte byte2 = this._dataInputStream.readByte();
        long len = byte2 & 0x7F;
        if (len == 126L) {
            len = this._dataInputStream.readUnsignedShort();
        } else if (len == 127L) {
            len = this._dataInputStream.readLong();
        }
        this._bytes = new byte[(int)len];
        int pos = 0;
        while ((long)pos < len) {
            pos += this._dataInputStream.read(this._bytes, pos, (int)(len - (long)pos));
        }
    }

    public boolean isFin() {
        return this._isFin;
    }

    public boolean isTextFrame() {
        return this._opCode == 1;
    }

    public byte[] getBytes() {
        return this._bytes;
    }

    int getLength() {
        return this._bytes.length;
    }
}

