/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater.steps;

import com.integ.janoslib.utils.ZipUtils;
import com.integ.supporter.updater.JanosUpd;
import com.integ.supporter.updater.JanosVersion;
import com.integ.supporter.updater.steps.FtpStep;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UpdateSeries3OSStep
extends FtpStep {
    protected String _version = "";

    public UpdateSeries3OSStep(String name) {
        super(name);
        this._type = "UpdateSeries3OSProperty";
    }

    public UpdateSeries3OSStep(Element xmlElement) {
        super(xmlElement);
        System.out.println("xmlAElement: " + xmlElement.toString());
        this._version = this.getChildNodeString("Version");
        System.out.println("Version: " + this._version);
    }

    @Override
    public final String getRemoteFolder() {
        return "";
    }

    public String getVersion() {
        return this._version;
    }

    private JanosVersion getLocalVersion() throws Exception {
        String localVersion = this.getVersion();
        JanosVersion localJanosVersion = JanosVersion.getFromString(localVersion);
        ZipEntry zipEntry = this._updateProjectFile.getEntryForFile(this._localFile);
        if (null != zipEntry) {
            byte[] fileContentBytes = ZipUtils.extractEntry(this._updateProjectFile.getFilePath(), zipEntry.getName());
            JanosUpd.JanosFileInformation janosUpdInformation = JanosUpd.getInformation(fileContentBytes);
            if (null != janosUpdInformation.BuildTag) {
                localJanosVersion = JanosVersion.getFromBuildTag(janosUpdInformation.BuildTag);
                localVersion = localJanosVersion.toString();
            }
        }
        return localJanosVersion;
    }

    private JanosVersion getRemoteVersion() throws Exception {
        String remoteVersion = this._jniorUpdateControlConnection.exec("registry $version");
        int equalPos = remoteVersion.indexOf("=");
        if (-1 != equalPos) {
            remoteVersion = remoteVersion.substring(equalPos + 1);
            remoteVersion = remoteVersion.trim();
            this._logger.info(String.format("  remote version: %s", remoteVersion));
        }
        JanosVersion remoteJanosVersion = JanosVersion.getFromString(remoteVersion);
        String buildTag = this._jniorUpdateControlConnection.exec("registry $buildtag");
        if (!"".equals(buildTag) && !buildTag.contains("not defined") && -1 != (equalPos = buildTag.indexOf("="))) {
            int eolPos = buildTag.indexOf("\r\n", equalPos);
            if (-1 == eolPos) {
                eolPos = buildTag.length();
            }
            buildTag = buildTag.substring(equalPos + 1, eolPos);
            buildTag = buildTag.trim();
            this._logger.info(String.format("  buildTag: %s", buildTag));
            remoteJanosVersion = JanosVersion.getFromBuildTag(buildTag);
            remoteVersion = remoteJanosVersion.toString();
        }
        return remoteJanosVersion;
    }

    void setVersion(String version) {
        String oldVersion = this._version;
        this._version = version;
        this._changes.firePropertyChange("Version", oldVersion, version);
    }

    @Override
    public Element getXmlElement(Document document) {
        Element xmlElement = super.getXmlElement(document);
        Element element = document.createElement("Version");
        element.appendChild(document.createTextNode(this._version));
        xmlElement.appendChild(element);
        return xmlElement;
    }

    @Override
    public boolean execute() throws Exception {
        if (3 != this._jniorInfo.getSeries()) {
            throw new RuntimeException("The target JNIOR is not a series 3 jnior");
        }
        String versionResponse = this._jniorUpdateControlConnection.exec("registry $Version");
        int equalPos = versionResponse.indexOf("=");
        if (-1 != equalPos) {
            versionResponse = versionResponse.substring(equalPos + 1);
            versionResponse = versionResponse.trim();
            this._logger.info(String.format("  remote version: %s", versionResponse));
            if (versionResponse.equalsIgnoreCase(this._version)) {
                this._logger.info("  JNIOR " + this._version + " already installed");
                return true;
            }
        }
        super.execute();
        String rebootCommand = "reboot\ny";
        this._logger.info("  rebooting...");
        this._jniorUpdateControlConnection.exec(rebootCommand);
        this._logger.info("  wait for the telnet connection to disconnect");
        long connectionDisconnectTimeout = System.currentTimeMillis() + 60000L;
        while (this._jniorUpdateControlConnection.isCommandConnectionConnected()) {
            Thread.sleep(1000L);
            if (connectionDisconnectTimeout >= System.currentTimeMillis()) continue;
            this._logger.warning("  telnet client disconnection timeout");
            break;
        }
        try {
            this._jniorUpdateControlConnection.disconnect();
        }
        catch (IOException ex) {
            Logger.getLogger(UpdateSeries3OSStep.class.getName()).severe(ex.getMessage());
        }
        long rebootTimeout = System.currentTimeMillis() + 300000L;
        while (System.currentTimeMillis() < rebootTimeout) {
            Thread.sleep(30000L);
            if (!this._jniorUpdateControlConnection.connect()) continue;
            break;
        }
        return true;
    }
}

