/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.janoslib.net.LoginFailedException;
import com.integ.janoslib.net.TelnetClient;
import com.integ.janoslib.net.TelnetClientAuthenticationFailedEvent;
import com.integ.janoslib.net.TelnetClientAuthenticationListener;
import com.integ.janoslib.net.TelnetClientAuthenticationSuccessEvent;
import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.protocols.jmpprotocol.helpers.FileListing;
import com.integ.supporter.JniorControlConnection;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class JniorSeries3ControlConnection
extends JniorControlConnection {
    private TelnetClient _telnetClient = null;
    private FTPClient _ftpClient = null;

    public JniorSeries3ControlConnection(JniorInfo targetJniorInfo, Logger logger) {
        super(targetJniorInfo, logger);
    }

    @Override
    public boolean isLoggedIn() {
        return this._telnetClient.isLoggedIn();
    }

    @Override
    public void allowReconnect(boolean b) {
    }

    private boolean initTelnetClient() {
        this._telnetClient = new TelnetClient(this._targetJniorInfo.IpAddress);
        this._telnetClient.setAuthenticationListener(new TelnetClientAuthenticationListener(){

            @Override
            public void onAuthenticationSuccess(TelnetClientAuthenticationSuccessEvent event) {
            }

            @Override
            public void onAuthenticationFailed(TelnetClientAuthenticationFailedEvent event) {
                JniorSeries3ControlConnection.this._telnetClient.setCredentials(JniorSeries3ControlConnection.this._targetJniorInfo.Username, JniorSeries3ControlConnection.this._targetJniorInfo.Password);
            }
        });
        try {
            this._logger.info("connecting to telnet client...");
            if (this._telnetClient.connect(this._targetJniorInfo.IpAddress)) {
                this._logger.info("logging into telnet client...");
                if (this._telnetClient.login(this._targetJniorInfo.Username, this._targetJniorInfo.Password)) {
                    this._logger.info("telnet client ready.");
                    long timeoutExpiration = System.currentTimeMillis() + 60000L;
                    this._logger.info("  check the boot.log for boot completion");
                    while (System.currentTimeMillis() < timeoutExpiration) {
                        String[] lines;
                        String bootLog = this._telnetClient.exec("cat jniorboot.log");
                        String lastLine = "";
                        for (String line : lines = bootLog.split("\r\n")) {
                            if ("".equals(line) || !line.contains(", ")) continue;
                            lastLine = line;
                        }
                        this._logger.info(String.format("  %s", lastLine));
                        if (bootLog.contains("Boot Completed")) break;
                        Thread.sleep(15000L);
                    }
                    return true;
                }
            }
        }
        catch (Exception ex) {
            this._logger.severe(ex.getMessage());
        }
        return false;
    }

    private boolean initFtpClient() {
        try {
            this._ftpClient = new FTPClient();
            this._logger.info("  connecting to ftp client...");
            this._ftpClient.connect(this._targetJniorInfo.IpAddress, 21);
            int reply = this._ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion(reply)) {
                this._ftpClient.disconnect();
                throw new IOException("Exception in connecting to FTP Server");
            }
            this._logger.info("  logging into ftp client...");
            if (this._ftpClient.login(this._targetJniorInfo.Username, this._targetJniorInfo.Password)) {
                this._logger.info("  ftp client ready.");
                return true;
            }
        }
        catch (UnknownHostException ex) {
            this._logger.severe(ExceptionUtils.getStackTrace(ex));
        }
        catch (IOException ex) {
            this._logger.severe(ExceptionUtils.getStackTrace(ex));
        }
        return false;
    }

    @Override
    public boolean isCommandConnectionConnected() {
        return this._telnetClient.isConnected();
    }

    @Override
    public boolean connect() {
        return this.connect(false);
    }

    @Override
    public boolean connect(boolean force) {
        if (this.initTelnetClient()) {
            return this.initFtpClient();
        }
        boolean connected = this.connect();
        if (connected) {
            try {
                String serialNumberResponse = this.exec("registry $SerialNumber");
                try {
                    Pattern pattern = Pattern.compile("= (?<serial>\\d{9})");
                    Matcher matcher = pattern.matcher(serialNumberResponse);
                    if (matcher.find()) {
                        this._targetJniorInfo.setSerialNumber(Integer.valueOf(matcher.group("serial")));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Logger.getLogger(JniorControlConnection.class.getName()).log(Level.SEVERE, null, ex);
                }
                String hostname = this.exec("registry IpConfig/HostName");
                this._targetJniorInfo.Hostname = hostname = hostname.substring(hostname.indexOf(" = ") + 3);
            }
            catch (Exception ex) {
                try {
                    this.disconnect();
                }
                catch (IOException ex1) {
                    ex.printStackTrace();
                }
                connected = false;
            }
        }
        return false;
    }

    @Override
    public void disconnect() throws IOException {
        if (null != this._telnetClient) {
            this._telnetClient.disconnect();
            if (this._telnetClient.isConnected()) {
                this._logger.severe("  telnet client did not disconnect");
            } else {
                this._logger.info("  telnet client disconnected");
            }
        }
        if (null != this._ftpClient) {
            this._ftpClient.disconnect();
            if (this._ftpClient.isConnected()) {
                this._logger.severe("  ftp client did not disconnect");
            } else {
                this._logger.info("  ftp client disconnected");
            }
        }
    }

    @Override
    public boolean storeFile(String _remotePath, File localFile) throws IOException {
        this._ftpClient.setFileType(2);
        return this._ftpClient.storeFile(_remotePath, new FileInputStream(localFile));
    }

    @Override
    public void send(String string) throws Exception {
        this._telnetClient.send(string);
    }

    @Override
    public String exec(String command) throws Exception {
        return this.exec(command, 120000);
    }

    @Override
    public String exec(String command, int timeout) throws Exception {
        return this._telnetClient.exec(command);
    }

    @Override
    public boolean retrieveFile(String remotePath, FileOutputStream fileOutputStream) throws IOException {
        return this._ftpClient.retrieveFile(remotePath, fileOutputStream);
    }

    @Override
    public boolean login(String userName, String password) throws LoginFailedException {
        return true;
    }

    @Override
    public FileListing[] listFiles(String directory) throws IOException {
        FTPFile[] ftpFiles = this._ftpClient.listFiles(directory);
        FileListing[] fileListings = new FileListing[ftpFiles.length];
        for (int i = 0; i < ftpFiles.length; ++i) {
            fileListings[i] = new FileListing();
            fileListings[i].setName(ftpFiles[i].getName());
            fileListings[i].setSize(ftpFiles[i].getSize());
            fileListings[i].setTimestamp(ftpFiles[i].getTimestamp().getTimeInMillis());
            fileListings[i].setIsFile(ftpFiles[i].isFile());
        }
        return fileListings;
    }
}

