/*
 * Decompiled with CFR 0.152.
 */
package com.integ.utils;

import java.util.Arrays;

public class HexUtils {
    private static final String HEX_CHAR_STRING = "0123456789ABCDEF";
    private static final char[] HEX_CHAR_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final char[] LOWER_HAX_CHAR_ARRAY = "0123456789ABCDEF".toLowerCase().toCharArray();

    public static String bytesToHex(byte[] bytes) {
        return HexUtils.bytesToHex(bytes, 0, bytes.length);
    }

    public static String bytesToHex(byte[] bytes, int offset, int len) {
        if (null == bytes) {
            return "null";
        }
        char[] hexChars = new char[len * 2];
        int i = 0;
        for (int j = offset; j < offset + len; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[i++] = HEX_CHAR_ARRAY[v >> 4 & 0xF];
            hexChars[i++] = HEX_CHAR_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String hexDump(byte[] bytes) {
        return HexUtils.hexDump(bytes, 0, bytes.length);
    }

    public static String hexDump(byte[] bytes, int offset, int length) {
        StringBuilder sb = new StringBuilder((length / 16 + 1) * 83);
        char[] line = new char[83];
        Arrays.fill(line, ' ');
        line[0] = 48;
        line[1] = 120;
        line[line.length - 2] = 13;
        line[line.length - 1] = 10;
        int endAddress = offset + length;
        for (int lineAddress = offset - offset % 16; lineAddress <= endAddress; lineAddress += 16) {
            char c;
            int address;
            int linePos;
            int charPos = 2;
            line[charPos++] = LOWER_HAX_CHAR_ARRAY[lineAddress >> 12 & 0xF];
            line[charPos++] = LOWER_HAX_CHAR_ARRAY[lineAddress >> 8 & 0xF];
            line[charPos++] = LOWER_HAX_CHAR_ARRAY[lineAddress >> 4 & 0xF];
            line[charPos++] = LOWER_HAX_CHAR_ARRAY[lineAddress & 0xF];
            charPos += 3;
            for (linePos = 0; linePos < 16; ++linePos) {
                address = lineAddress + linePos;
                if (address < offset) {
                    charPos += 3;
                } else if (address < endAddress) {
                    c = bytes[address];
                    line[charPos++] = LOWER_HAX_CHAR_ARRAY[c >> 4 & 0xF];
                    line[charPos++] = LOWER_HAX_CHAR_ARRAY[c & 0xF];
                    ++charPos;
                } else {
                    line[charPos++] = 32;
                    line[charPos++] = 32;
                    ++charPos;
                }
                if (7 != linePos) continue;
                charPos += 2;
            }
            charPos += 3;
            for (linePos = 0; linePos < 16; ++linePos) {
                address = lineAddress + linePos;
                if (address < offset) {
                    ++charPos;
                } else {
                    line[charPos++] = address < endAddress ? (' ' > (c = (char)bytes[address]) || '\u0080' <= c ? 46 : c) : 32;
                }
                if (7 != linePos) continue;
                ++charPos;
            }
            sb.append(line, 0, line.length);
        }
        return sb.toString();
    }

    public static long parseHexAsLong(String s) {
        if (s == null) {
            return 0L;
        }
        int len = s.length();
        long l = Long.parseLong(s.substring(0, len - 8), 16);
        l <<= 32;
        return l += Long.parseLong(s.substring(len - 8), 16);
    }
}

