/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.config;

import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.json.JSONObject;

public class JsonConfigFile {
    protected JSONObject _configJson = new JSONObject();
    private final File _file;
    private long _lastModifiedTime = 0L;
    private final ArrayList<ChangeListener> _listenerList = new ArrayList();

    protected JsonConfigFile(File file) {
        this._file = file;
    }

    public void addChangeListener(ChangeListener listener) {
        this._listenerList.add(listener);
    }

    protected void changed() {
        for (ChangeListener listener : this._listenerList) {
            listener.stateChanged(new ChangeEvent(this));
        }
        this.saveConfig();
    }

    protected void shouldReloadConfig() {
        if (this._file.exists() && this._lastModifiedTime != this._file.lastModified()) {
            this._lastModifiedTime = this._file.lastModified();
            this.loadConfig();
        }
    }

    private void loadConfig() {
        if (this._file.exists()) {
            try {
                String _jniorsConfigJsonFileContent = FileUtils.readAllText(this._file.getPath());
                this._configJson = new JSONObject(_jniorsConfigJsonFileContent);
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).severe(ExceptionUtils.getStackTrace(ex));
            }
        }
    }

    private void saveConfig() {
        try {
            String fileContentString = this._configJson.toString(2);
            byte[] fileContentBytes = fileContentString.getBytes();
            FileUtils.writeAllBytes(this._file.getPath(), fileContentBytes);
            this._lastModifiedTime = this._file.lastModified();
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).severe(ExceptionUtils.getStackTrace(ex));
        }
    }
}

