/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.supporter.ActionResult;
import com.integ.supporter.Notification;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class BackgroundAction
extends Notification
implements Runnable {
    private Thread _thread = null;
    private final ArrayList<ChangeListener> _progressListeners = new ArrayList();
    private final JniorInfo _jniorInfo;
    private long _startedTime;
    private int _percentage = 0;
    private final ActionResult _result;

    protected BackgroundAction(JniorInfo jniorInfo) {
        this._jniorInfo = jniorInfo;
        this._result = new ActionResult();
        this._result.addProgressUpdateListener(e -> this.updateChangeListeners());
    }

    public JniorInfo getJniorInfo() {
        return this._jniorInfo;
    }

    public ActionResult getResult() {
        return this._result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressUpdateListener(ChangeListener changeListener) {
        ArrayList<ChangeListener> arrayList = this._progressListeners;
        synchronized (arrayList) {
            this._progressListeners.add(changeListener);
        }
    }

    protected void update(String description) {
        this.update(description, this._percentage);
    }

    protected void update(String desctiption, int percent) {
        if (null == this._jniorInfo) {
            throw new RuntimeException("Must set Jnior Info object");
        }
        this._timestamp = System.currentTimeMillis();
        this._description = desctiption;
        this._percentage = percent;
        this.updateChangeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateChangeListeners() {
        ArrayList<ChangeListener> arrayList = this._progressListeners;
        synchronized (arrayList) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (ChangeListener changeListener : this._progressListeners) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }

    public void start() {
        if (null == this._thread) {
            this._startedTime = System.currentTimeMillis();
            this._thread = new Thread(this);
            this._thread.start();
        }
    }

    public abstract String getTitle();

    protected long getStartedTime() {
        return this._startedTime;
    }

    public int getPercentage() {
        return this._percentage;
    }

    @Override
    public abstract void run();
}

