/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.dialogs;

import com.integ.janoslib.net.beacon.JniorCollection;
import com.integ.janoslib.net.beacon.JniorCollectionListener;
import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.supporter.SelectedJniorItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class JniorSelectionTableModel
extends AbstractTableModel
implements JniorCollectionListener {
    public static final int SERIAL_INDEX = 1;
    public static final int MODEL_INDEX = 2;
    public static final int HOSTNAME_INDEX = 3;
    public static final int IPADDRESS_INDEX = 4;
    public static final int OSVERSION_INDEX = 5;
    private boolean _hideSeries3;
    private final ArrayList<ColumnInfo> _columns = new ArrayList<ColumnInfo>(Arrays.asList(new ColumnInfo("", 32), new ColumnInfo("Serial Number", 96), new ColumnInfo("Model", 96), new ColumnInfo("HostName", 256), new ColumnInfo("IP Address", 128), new ColumnInfo("OS Version", 128)));
    protected final ArrayList<SelectedJniorItem> _rowData = new ArrayList();
    protected final Hashtable<Integer, SelectedJniorItem> _jniorsBySerial = new Hashtable();

    @Override
    public void jniorAdded(JniorInfo jniorInfo) {
        this.updateJniorInfo(jniorInfo);
    }

    @Override
    public void jniorRemoved(JniorInfo jniorInfo) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void jniorUpdated(JniorInfo jniorInfo) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public JniorSelectionTableModel() {
        JniorCollection.addListener(this);
        ArrayList<JniorInfo> jniors = JniorCollection.getActiveJniors();
        for (JniorInfo jniorInfo : jniors) {
            if (-1 == jniorInfo.getSerialNumber() || null == jniorInfo.IpAddress) continue;
            this.updateJniorInfo(jniorInfo);
        }
    }

    protected void finalize() throws Throwable {
        JniorCollection.removeListener(this);
    }

    public void hideSeries3() {
        this._hideSeries3 = false;
    }

    protected void addColumn(String name, int width) {
        this._columns.add(new ColumnInfo(name, width));
    }

    @Override
    public String getColumnName(int column) {
        return this._columns.get((int)column).Name;
    }

    public int getColumnWidth(int column) {
        return this._columns.get((int)column).Width;
    }

    @Override
    public int getColumnCount() {
        return this._columns.size();
    }

    @Override
    public int getRowCount() {
        return this._rowData.size();
    }

    public Class getColumnClass(int columnIndex) {
        if (0 == columnIndex) {
            return Boolean.class;
        }
        return super.getColumnClass(columnIndex);
    }

    public SelectedJniorItem[] getJniors() {
        return this._rowData.toArray(new SelectedJniorItem[this._rowData.size()]);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SelectedJniorItem selectedJniorItem = this._rowData.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return selectedJniorItem.Selected;
            }
            case 1: {
                return selectedJniorItem.getSerialNumber();
            }
            case 2: {
                return selectedJniorItem.getModel();
            }
            case 3: {
                return selectedJniorItem.getHostname();
            }
            case 4: {
                return selectedJniorItem.getIpAddress();
            }
            case 5: {
                return selectedJniorItem.getOsVersion();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        boolean selected;
        SelectedJniorItem selectedJniorItem = this._rowData.get(rowIndex);
        if (0 == columnIndex && selectedJniorItem.Selected != (selected = ((Boolean)value).booleanValue())) {
            selectedJniorItem.Selected = selected;
            this.fireTableChanged(new TableModelEvent(this, rowIndex, rowIndex, columnIndex));
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return 0 == columnIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJniorInfo(JniorInfo jniorInfo) {
        Hashtable<Integer, SelectedJniorItem> hashtable = this._jniorsBySerial;
        synchronized (hashtable) {
            if (!this._jniorsBySerial.containsKey(jniorInfo.getSerialNumber())) {
                SelectedJniorItem selectedJniorItem = new SelectedJniorItem(jniorInfo);
                this._rowData.add(selectedJniorItem);
                this._jniorsBySerial.put(jniorInfo.getSerialNumber(), selectedJniorItem);
            } else {
                SelectedJniorItem selectedJniorItem = this._jniorsBySerial.get(jniorInfo.getSerialNumber());
                selectedJniorItem.update(jniorInfo);
            }
            this.fireTableChanged(new TableModelEvent(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Hashtable<Integer, SelectedJniorItem> hashtable = this._jniorsBySerial;
        synchronized (hashtable) {
            this._rowData.clear();
            this._jniorsBySerial.clear();
        }
    }

    public SelectedJniorItem getSelectedJniorItemBySerialNumber(int selectedSerialNumber) {
        return this._jniorsBySerial.get(selectedSerialNumber);
    }

    class ColumnInfo {
        public String Name;
        public int Width;

        public ColumnInfo(String name, int width) {
            this.Name = name;
            this.Width = width;
        }
    }
}

