/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui;

import com.formdev.flatlaf.ui.FlatTabbedPaneUI;
import com.integ.supporter.Notification;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.NotificationListener;
import com.integ.supporter.RollingLog;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.ui.FocusedTitleListCellRenderer;
import com.integ.supporter.ui.NotificationListModel;
import com.integ.supporter.ui.toasts.ErrorMessageToast;
import com.integ.supporter.ui.toasts.ToastNotifications;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;

public class NotificationPane
extends JPanel {
    private final NotificationListModel _notificationListModel = new NotificationListModel();
    private String _lastErrorMessage = null;
    private JMenuItem copyDetailsMenuItem;
    private JList<String> jList1;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JMenuItem removeAllNotificationsMenuItem;
    private JMenuItem removeNotificationMenuItem;

    public NotificationPane() {
        this.initComponents();
        FlatTabbedPaneUI flatTabbedPaneUI = new FlatTabbedPaneUI();
        this.jTabbedPane1.setUI(flatTabbedPaneUI);
        this.jTabbedPane1.putClientProperty("JTabbedPane.tabClosable", true);
        this.jTabbedPane1.putClientProperty("JTabbedPane.tabCloseToolTipText", "Close");
        this.jTabbedPane1.putClientProperty("JTabbedPane.tabCloseCallback", (tabPane, tabIndex) -> SupporterMain.getMainFrame().hideNotifications());
        this.jList1.setCellRenderer(new FocusedTitleListCellRenderer());
        this.jList1.setModel(this._notificationListModel);
        this.jList1.setComponentPopupMenu(this.jPopupMenu1);
        NotificationCollection.addListener(new NotificationListener(){

            @Override
            public void notificationAdded(Notification notification) {
                NotificationPane.this.addNotification(notification);
            }

            @Override
            public void notificationRemoved(Notification notification) {
            }
        });
        ArrayList<Notification> notifications = NotificationCollection.getNotifications();
        for (Notification notification : notifications) {
            this.addNotification(notification);
        }
        this.refresh();
    }

    private void addNotification(Notification notification) {
        try {
            Level level = Level.INFO;
            if (4 == notification.getLevel()) {
                level = Level.SEVERE;
            }
            Object descriptionString = notification.getDescription();
            if (null != notification.getUserObject()) {
                descriptionString = (String)descriptionString + "\n" + notification.getUserObject();
            }
            LogRecord logRecord = new LogRecord(level, (String)descriptionString);
            logRecord.setMillis(notification.getTimestamp());
            Logger log = RollingLog.getLogger("Notification");
            log.log(logRecord);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (4 == notification.getLevel()) {
            try {
                if (null == this._lastErrorMessage || !this._lastErrorMessage.equalsIgnoreCase(notification.getDescription())) {
                    this._lastErrorMessage = notification.getDescription();
                    ToastNotifications.getInstance().display(new ErrorMessageToast(notification.getDescription()));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this._notificationListModel.addNotification(notification);
    }

    public Component getPanel() {
        JLabel titleLabel = new JLabel();
        titleLabel.setText(" needs credentials");
        JLabel jLabel1 = new JLabel("Username:");
        JLabel jLabel2 = new JLabel("Password:");
        JTextField usernameTextField = new JTextField();
        JPasswordField passwordTextField = new JPasswordField();
        JPanel credentialsPanel = new JPanel();
        GroupLayout credentialsPanelLayout = new GroupLayout(credentialsPanel);
        credentialsPanel.setLayout(credentialsPanelLayout);
        credentialsPanelLayout.setHorizontalGroup(credentialsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(credentialsPanelLayout.createSequentialGroup().addContainerGap().addComponent(titleLabel).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, credentialsPanelLayout.createSequentialGroup().addContainerGap(21, Short.MAX_VALUE).addGroup(credentialsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel1).addComponent(jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(credentialsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(usernameTextField).addComponent(passwordTextField, -2, 137, -2)).addContainerGap()));
        credentialsPanelLayout.setVerticalGroup(credentialsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(credentialsPanelLayout.createSequentialGroup().addComponent(titleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(credentialsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(usernameTextField, -2, -1, -2).addComponent(jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(credentialsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(passwordTextField, -2, -1, -2)).addGap(0, 23, Short.MAX_VALUE)));
        return credentialsPanel;
    }

    private void refresh() {
        this.jList1.updateUI();
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.removeAllNotificationsMenuItem = new JMenuItem();
        this.removeNotificationMenuItem = new JMenuItem();
        this.copyDetailsMenuItem = new JMenuItem();
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jPopupMenu1.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                NotificationPane.this.jPopupMenu1ComponentShown(evt);
            }
        });
        this.removeAllNotificationsMenuItem.setText("Remove All Notifications");
        this.removeAllNotificationsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotificationPane.this.removeAllNotificationsMenuItemActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.removeAllNotificationsMenuItem);
        this.removeNotificationMenuItem.setText("Remove Notification");
        this.removeNotificationMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotificationPane.this.removeNotificationMenuItemActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.removeNotificationMenuItem);
        this.copyDetailsMenuItem.setText("Copy Details");
        this.copyDetailsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotificationPane.this.copyDetailsMenuItemActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.copyDetailsMenuItem);
        this.setLayout(new BorderLayout());
        this.jTabbedPane1.setFocusable(false);
        this.jList1.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NotificationPane.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jTabbedPane1.addTab("Notifications", this.jScrollPane1);
        this.add((Component)this.jTabbedPane1, "Center");
    }

    private void removeNotificationMenuItemActionPerformed(ActionEvent evt) {
        int selectedIndex = this.jList1.getSelectedIndex();
        if (0 <= selectedIndex) {
            this._notificationListModel.remove(selectedIndex);
            NotificationCollection.getInstance().remove(selectedIndex);
        }
    }

    private void jPopupMenu1ComponentShown(ComponentEvent evt) {
        this.removeNotificationMenuItem.setEnabled(!NotificationCollection.getNotifications().isEmpty());
    }

    private void jList1MouseClicked(MouseEvent evt) {
        ArrayList<Notification> notifications;
        Notification notification;
        int row;
        if (1 == evt.getButton() && 2 == evt.getClickCount() && -1 != (row = this.jList1.getSelectedIndex()) && null != (notification = (notifications = NotificationCollection.getNotifications()).get(notifications.size() - row - 1)).getUserObject()) {
            String stackTrace = String.valueOf(notification.getUserObject());
            JTextArea textArea = new JTextArea(stackTrace);
            textArea.setEditable(false);
            textArea.setLineWrap(false);
            textArea.setWrapStyleWord(false);
            JScrollPane scrollPane = new JScrollPane(textArea);
            scrollPane.setBorder(null);
            scrollPane.setPreferredSize(new Dimension(800, 800));
            JOptionPane.showMessageDialog(this, scrollPane, "Stacktrace", 0);
        }
        if (3 == evt.getButton()) {
            int clickedIndex = this.jList1.locationToIndex(evt.getPoint());
            this.jList1.setSelectedIndex(clickedIndex);
        }
    }

    private void copyDetailsMenuItemActionPerformed(ActionEvent evt) {
        int selectedRow = this.jList1.getSelectedIndex();
        if (-1 != selectedRow) {
            ArrayList<Notification> notifications = NotificationCollection.getNotifications();
            Notification notification = notifications.get(notifications.size() - selectedRow - 1);
            String detailsString = String.format("%s - %s", new Date(notification.getTimestamp()).toString(), notification.getDescription());
            if (null != notification.getUserObject()) {
                String stackTrace = String.valueOf(notification.getUserObject());
                detailsString = String.format("%s\n%s", detailsString, stackTrace);
            }
            StringSelection stringSelection = new StringSelection(detailsString);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
            JOptionPane.showMessageDialog(SupporterMain.getMainFrame(), "Notification Details have been copied to the clipboard");
        }
    }

    private void removeAllNotificationsMenuItemActionPerformed(ActionEvent evt) {
        this._notificationListModel.clear();
        NotificationCollection.getInstance().clear();
    }
}

