/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.net.beacon.commands;

import com.integ.janoslib.net.beacon.Beacon;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class BeaconCommand {
    private static final int BROADCAST_SERIAL = -1;
    public static final String QUERY = "QUERY";
    public static final String QUERY_ALL = "QUERY_ALL";
    public static final String GET_INFO = "GET_INFO";
    public static final String SET_INFO = "SET_INFO";
    public static final String SET_HOSTNAME = "SET_HOSTNAME";
    public static final String SET_DHCP = "SET_DHCP";
    public static final String REBOOT = "REBOOT";
    public static final String ACK_ATTENTION = "ACK_ATTENTION";
    public static final String GET_MEMORY = "GET_MEMORY";
    public static final String IDENTIFY = "IDENTIFY";
    protected final Object _lock = new Object();
    private final String _command;
    private final int _serialNumber;
    private byte[] _bytes = null;

    protected BeaconCommand(String command) {
        this(command, -1);
    }

    protected BeaconCommand(String command, int serialNumber) {
        this._command = command;
        this._serialNumber = serialNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        Object object = this._lock;
        synchronized (object) {
            return this.doCache();
        }
    }

    public int getSerialNumber() {
        return this._serialNumber;
    }

    private byte[] doCache() {
        if (null == this._bytes) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                dos.writeShort(0);
                dos.writeInt(this._serialNumber);
                dos.writeShort((short)this._command.length());
                dos.write(this._command.getBytes(), 0, this._command.length());
                this.appendCommandBytes(dos);
                byte[] bytes = baos.toByteArray();
                int length = bytes.length - 2;
                bytes[0] = (byte)(length >> 8 & 0xFF);
                bytes[1] = (byte)(length & 0xFF);
                this._bytes = bytes;
            }
            catch (Exception ex) {
                throw new RuntimeException("Error building beacon command", ex);
            }
        }
        return this._bytes;
    }

    protected abstract void appendCommandBytes(DataOutputStream var1) throws IOException;

    protected void writeString(DataOutputStream dos, String string) throws IOException {
        dos.writeShort((short)string.length());
        dos.write(string.getBytes(), 0, string.length());
    }

    protected void appendSecurity(DataOutputStream dos, String nonce, String username, String password) throws IOException {
        if (null != nonce) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] hashBytes = (username + ":" + nonce + ":" + password).getBytes();
                md.update(hashBytes);
                byte[] digest = md.digest();
                Object digestString = HexUtils.bytesToHex(digest);
                digestString = username + ":" + (String)digestString;
                this.writeString(dos, (String)digestString);
                nonce = null;
            }
            catch (NoSuchAlgorithmException ex) {
                String stacktrace = ExceptionUtils.getStackTrace(ex);
                Beacon.LOGGER.severe(stacktrace);
            }
        } else {
            throw new IOException("Command is missing the security nonce");
        }
    }
}

