/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.beacon;

import com.integ.supporter.SupporterMain;
import com.integ.supporter.beacon.BeaconTab;
import com.integ.supporter.beacon.BeaconTableColumnModel;
import com.integ.supporter.beacon.dialogs.SelectBeaconColumnsDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class BeaconTableHeaderMouseListener
extends MouseAdapter {
    private final JTable _jtable;

    public BeaconTableHeaderMouseListener(JTable jtable) {
        this._jtable = jtable;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            JPopupMenu popupMenu = this.createHeaderPopupMenu();
            popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
        } else {
            BeaconTableColumnModel tableColumnModel = (BeaconTableColumnModel)this._jtable.getColumnModel();
            int columnIndex = tableColumnModel.getColumnIndexAtX(e.getPoint().x);
            int columnWidth = tableColumnModel.getColumn(columnIndex).getPreferredWidth();
            tableColumnModel.setWidth(columnIndex, columnWidth);
            tableColumnModel.save();
        }
    }

    private JPopupMenu createHeaderPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Select Columns");
        menuItem.addActionListener(e -> {
            JTable table = BeaconTab.getInstance().getTable();
            BeaconTableColumnModel beaconTableColumnModel = (BeaconTableColumnModel)table.getColumnModel();
            SelectBeaconColumnsDialog showBeaconColumnsDialog = new SelectBeaconColumnsDialog((Frame)SupporterMain.getMainFrame(), true);
            showBeaconColumnsDialog.setColumnModel(beaconTableColumnModel);
            showBeaconColumnsDialog.setVisible(true);
            table.getTableHeader().revalidate();
        });
        popupMenu.add(menuItem);
        return popupMenu;
    }
}

