/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui;

import com.integ.supporter.BackgroundAction;
import com.integ.supporter.Notification;
import com.integ.supporter.ui.ColorConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class FocusedTitleListCellRenderer
implements ListCellRenderer {
    private static final Color LIST_SELECTION_BACKGROUND = UIManager.getDefaults().getColor("List.selectionBackground");
    protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        try {
            BackgroundAction backgroundAction;
            Notification notification = (Notification)value;
            Color foregroundColor = Color.BLACK;
            Color backgroundColor = Color.white;
            if (4 == notification.getLevel()) {
                backgroundColor = ColorConstants.PALE_RED;
            } else if (3 == notification.getLevel()) {
                backgroundColor = ColorConstants.PALE_YELLOW;
            } else if (1 == notification.getLevel()) {
                backgroundColor = ColorConstants.PALE_GREEN;
            }
            if (isSelected) {
                foregroundColor = Color.WHITE;
                backgroundColor = LIST_SELECTION_BACKGROUND;
            }
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ColorConstants.LIGHT_GRAY), BorderFactory.createEmptyBorder(2, 2, 0, 2)));
            panel.setForeground(foregroundColor);
            panel.setBackground(backgroundColor);
            JLabel dateLabel = new JLabel(new Date(notification.getTimestamp()).toString());
            dateLabel.setPreferredSize(new Dimension(200, dateLabel.getPreferredSize().height));
            dateLabel.setForeground(foregroundColor);
            panel.add(dateLabel);
            JLabel descriptionLabel = new JLabel(notification.getDescription());
            descriptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 24, 0, 0));
            descriptionLabel.setForeground(foregroundColor);
            panel.add(descriptionLabel);
            if (value instanceof BackgroundAction && !(backgroundAction = (BackgroundAction)value).getResult().hasCompleted()) {
                JProgressBar progressBar = new JProgressBar();
                panel.add(progressBar);
                JViewport viewport = (JViewport)list.getParent();
                progressBar.setPreferredSize(new Dimension(viewport.getWidth(), 2));
                progressBar.setBorder(null);
                double percentage = ((BackgroundAction)value).getPercentage();
                progressBar.setValue((int)percentage);
            }
            return panel;
        }
        catch (Exception ex) {
            return this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

