/*
 * Decompiled with CFR 0.152.
 */
package com.integ.protocols.jmpprotocol.helpers;

import com.integ.protocols.jmpprotocol.JmpProtocolClient;
import com.integ.protocols.jmpprotocol.helpers.FileListing;
import com.integ.protocols.jmpprotocol.messages.FileListingMessage;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class GetFileListingHelper {
    private final JmpProtocolClient _jmpProtocolClient;
    private final String _directory;

    public GetFileListingHelper(JmpProtocolClient jmpProtocolClient, String directory) {
        this._jmpProtocolClient = jmpProtocolClient;
        if (!((String)directory).endsWith("/")) {
            directory = (String)directory + "/";
        }
        this._directory = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<FileListing> getFiles() {
        try {
            ArrayList<FileListing> files = new ArrayList<FileListing>();
            this._jmpProtocolClient.send(new FileListingMessage(this._directory), event -> {
                JSONObject json = event.getJsonMessage();
                System.out.println("json = " + json.toString(2));
                if (!"File List Response".equals(json.getString("Message"))) {
                    throw new RuntimeException("Not a file listing response");
                }
                for (Object fileObject : json.getJSONArray("Content")) {
                    JSONObject fileJson = (JSONObject)fileObject;
                    String name = fileJson.getString("Name");
                    SimpleDateFormat ModParse = new SimpleDateFormat("dd MMM yyyy HH:mm");
                    Date lastModDate = null;
                    try {
                        lastModDate = ModParse.parse(fileJson.getString("Mod"));
                    }
                    catch (ParseException ex) {
                        Logger.getLogger(GetFileListingHelper.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    long lastModMillis = lastModDate.getTime();
                    FileListing ftpFile = new FileListing();
                    ftpFile.setName(name);
                    ftpFile.setSize(fileJson.getLong("Size"));
                    ftpFile.setTimestamp(lastModMillis);
                    ftpFile.setIsFile(!name.endsWith("/"));
                    files.add(ftpFile);
                }
                JmpProtocolClient jmpProtocolClient = this._jmpProtocolClient;
                synchronized (jmpProtocolClient) {
                    this._jmpProtocolClient.notify();
                }
            });
            JmpProtocolClient jmpProtocolClient = this._jmpProtocolClient;
            synchronized (jmpProtocolClient) {
                try {
                    System.out.println("websocket client wait");
                    this._jmpProtocolClient.wait();
                    System.out.println("websocket client notified");
                }
                catch (InterruptedException ex) {
                    Logger.getGlobal().severe(ex.getMessage());
                }
            }
            return files;
        }
        catch (IOException ex) {
            throw new RuntimeException("Error requesting file listing for " + this._directory, ex);
        }
    }
}

