/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema;

import com.integ.protocols.events.AuthenticationFailedEvent;
import com.integ.protocols.events.AuthenticationListener;
import com.integ.protocols.events.AuthenticationSuccessEvent;
import com.integ.protocols.events.ConnectionEvent;
import com.integ.protocols.events.ConnectionListener;
import com.integ.protocols.events.JniorProtocolMessageListener;
import com.integ.protocols.events.JniorProtocolMessageReceivedEvent;
import com.integ.protocols.jniorprotocol.JniorProtocolClient;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.ui.dialogs.LoginDialog;
import com.integ.supporter.ui.toasts.ErrorMessageToast;
import com.integ.supporter.ui.toasts.MessageToast;
import com.integ.supporter.ui.toasts.ToastNotifications;
import com.integ.utils.HexUtils;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class MacroExecutionDialog
extends JDialog {
    private static final Pattern PATTERN = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private String _ipAddress = null;
    private JniorProtocolClient _jniorProtocol = null;
    private JButton connectButton;
    private JButton disconnectButton;
    private JLabel hexStringLabel;
    private JTextArea hexStringTextArea;
    private JLabel ipAddressLabel;
    private JTextField ipAddressTextField;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea1;
    private JLabel macroNameOrNumberLabel;
    private JTextField macroNameTextField;
    private JButton sendButton;
    private JLabel statusLabel;

    public MacroExecutionDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.macroNameOrNumberLabel = new JLabel();
        this.macroNameTextField = new JTextField();
        this.hexStringLabel = new JLabel();
        this.ipAddressLabel = new JLabel();
        this.statusLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.hexStringTextArea = new JTextArea();
        this.sendButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.connectButton = new JButton();
        this.disconnectButton = new JButton();
        this.ipAddressTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Macro Execution Utility");
        this.macroNameOrNumberLabel.setText("Macro Name or Number");
        this.macroNameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MacroExecutionDialog.this.macroNameTextFieldKeyReleased(evt);
            }
        });
        this.hexStringLabel.setText("Hex String");
        this.ipAddressLabel.setText("IP Address");
        this.statusLabel.setText("Not Connected");
        this.hexStringTextArea.setEditable(false);
        this.hexStringTextArea.setColumns(20);
        this.hexStringTextArea.setLineWrap(true);
        this.hexStringTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.hexStringTextArea);
        this.sendButton.setText("Send");
        this.sendButton.setEnabled(false);
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroExecutionDialog.this.sendButtonActionPerformed(evt);
            }
        });
        this.jScrollPane2.setBorder(null);
        this.jScrollPane2.setVerticalScrollBarPolicy(21);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("The Hex String above represents the bytes that would be sent by a \nJNIOR Protocol implementation");
        this.jScrollPane2.setViewportView(this.jTextArea1);
        this.connectButton.setText("Connect");
        this.connectButton.setEnabled(false);
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroExecutionDialog.this.connectButtonActionPerformed(evt);
            }
        });
        this.disconnectButton.setText("Disconnect");
        this.disconnectButton.setEnabled(false);
        this.disconnectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroExecutionDialog.this.disconnectButtonActionPerformed(evt);
            }
        });
        this.ipAddressTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MacroExecutionDialog.this.ipAddressTextFieldKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                MacroExecutionDialog.this.ipAddressTextFieldKeyTyped(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.macroNameOrNumberLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.macroNameTextField, -2, 146, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.sendButton)).addComponent(this.jScrollPane2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hexStringLabel).addComponent(this.statusLabel).addGroup(layout.createSequentialGroup().addComponent(this.ipAddressLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ipAddressTextField, -2, 161, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.connectButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.disconnectButton))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(14, 14, 14).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ipAddressLabel).addComponent(this.connectButton).addComponent(this.disconnectButton).addComponent(this.ipAddressTextField, -2, -1, -2)).addGap(25, 25, 25).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sendButton).addComponent(this.macroNameTextField, -2, -1, -2).addComponent(this.macroNameOrNumberLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.hexStringLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE).addComponent(this.statusLabel).addGap(6, 6, 6)));
        this.pack();
    }

    private void sendButtonActionPerformed(ActionEvent evt) {
        String macroName = this.macroNameTextField.getText();
        byte[] commandBytes = this.getCommandBytes(macroName);
        this._jniorProtocol.sendCommand(commandBytes);
    }

    private void addConnectionListener() {
        this._jniorProtocol.addConnectionListener(new ConnectionListener(){

            @Override
            public void onConnecting(ConnectionEvent connectionEvent) {
                MacroExecutionDialog.this.statusLabel.setText("Connecting...");
            }

            @Override
            public void onConnected(ConnectionEvent connectionEvent) {
                MacroExecutionDialog.this.statusLabel.setText("Connected");
                MacroExecutionDialog.this.ipAddressTextField.setEnabled(false);
                MacroExecutionDialog.this.connectButton.setEnabled(false);
                MacroExecutionDialog.this.disconnectButton.setEnabled(true);
                MacroExecutionDialog.this.sendButton.setEnabled(!"".equals(MacroExecutionDialog.this.macroNameTextField.getText()));
            }

            @Override
            public void onClosed(ConnectionEvent connectionEvent) {
                MacroExecutionDialog.this.statusLabel.setText("Not Connected");
                MacroExecutionDialog.this.ipAddressTextField.setEnabled(true);
                MacroExecutionDialog.this.connectButton.setEnabled(true);
                MacroExecutionDialog.this.disconnectButton.setEnabled(false);
                MacroExecutionDialog.this.sendButton.setEnabled(false);
                MacroExecutionDialog.this._jniorProtocol = null;
            }

            @Override
            public void onError(ConnectionEvent connectionEvent, Exception ex) {
                MacroExecutionDialog.this.statusLabel.setText("Error");
            }
        });
    }

    private void addAuthenticationListener() {
        this._jniorProtocol.addAuthenticationListener(new AuthenticationListener(){

            @Override
            public void onAuthenticaionFailed(AuthenticationFailedEvent authenticationFailedEvent) {
                LoginDialog loginDialog = new LoginDialog((Frame)SupporterMain.getMainFrame(), true);
                loginDialog.setDescription("Beacon for " + MacroExecutionDialog.this._ipAddress + " needs credentials");
                loginDialog.centerParent();
                loginDialog.setVisible(true);
                if (loginDialog.getResult() == 1) {
                    MacroExecutionDialog.this._jniorProtocol.login(loginDialog.getUsername(), loginDialog.getPassword());
                }
            }

            @Override
            public void onAuthenticationSuccess(AuthenticationSuccessEvent authenticationSuccessEvent) {
            }
        });
    }

    private void addMessageListener() {
        this._jniorProtocol.addMessageListener(new JniorProtocolMessageListener(){

            @Override
            public void onMessage(JniorProtocolMessageReceivedEvent event) {
                byte[] messageBytes = event.getBinaryMessage();
                System.out.println(String.format("<-- %s", HexUtils.hexDump(messageBytes)));
                int command = messageBytes[5] & 0xFF;
                System.out.println("command = " + command);
                switch (command) {
                    case 254: {
                        System.out.println("custom command response");
                        MacroExecutionDialog.this.processCustomCommand(messageBytes);
                    }
                }
            }
        });
    }

    private void processCustomCommand(byte[] messageBytes) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(messageBytes));
            dataInputStream.skip(6L);
            int status = dataInputStream.read();
            short payloadSize = dataInputStream.readShort();
            int responseCommandLength = dataInputStream.read();
            String responseCommand = new String(dataInputStream.readNBytes(responseCommandLength));
            System.out.println("responseCommand = " + responseCommand);
            int available = dataInputStream.available();
            if (0 < available) {
                int length = dataInputStream.read();
                dataInputStream.skip(length);
                int commandTypeLength = dataInputStream.read();
                String commandType = new String(dataInputStream.readNBytes(commandTypeLength));
                System.out.println("commandType = " + commandType);
                length = dataInputStream.read();
                dataInputStream.skip(length);
                int responseLength = dataInputStream.read();
                String response = new String(dataInputStream.readNBytes(responseLength));
                System.out.println("response = " + response);
                MessageToast messageToast = new MessageToast(response);
                ToastNotifications.getInstance().display(messageToast);
            }
        }
        catch (IOException ex) {
            NotificationCollection.addError(ex);
        }
    }

    private void macroNameTextFieldKeyReleased(KeyEvent evt) {
        this.sendButton.setEnabled(null != this._jniorProtocol && this._jniorProtocol.isConnected() && !"".equals(this.macroNameTextField.getText()));
        String macroName = this.macroNameTextField.getText();
        byte[] commandBytes = this.getCommandBytes(macroName);
        byte[] messageBytes = this.getSendBytes(commandBytes);
        String hexString = com.integ.janoslib.utils.HexUtils.bytesToHex(messageBytes);
        StringBuilder hexStringWithSpaces = new StringBuilder();
        for (int i = 0; i < hexString.length() / 2; ++i) {
            if (0 < hexStringWithSpaces.length()) {
                hexStringWithSpaces.append(" ");
            }
            hexStringWithSpaces.append(hexString.substring(i * 2, i * 2 + 2));
        }
        this.hexStringTextArea.setText(hexStringWithSpaces.toString() + "\r\n\r\n" + hexString);
    }

    private void connectButtonActionPerformed(ActionEvent evt) {
        try {
            if (!this.ipAddressTextField.isValid()) {
                ToastNotifications.getInstance().display(new ErrorMessageToast("Invalid IP Address"));
                return;
            }
            this._ipAddress = this.ipAddressTextField.getText();
            this._jniorProtocol = new JniorProtocolClient(this._ipAddress);
            this.addConnectionListener();
            this.addAuthenticationListener();
            this.addMessageListener();
            this._jniorProtocol.connect();
            this._jniorProtocol.login("jnior", "jnior");
        }
        catch (Exception ex) {
            NotificationCollection.addError("Unable to connect to " + this._ipAddress, ex);
        }
    }

    private void disconnectButtonActionPerformed(ActionEvent evt) {
        if (null != this._jniorProtocol) {
            try {
                this._jniorProtocol.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void ipAddressTextFieldKeyReleased(KeyEvent evt) {
        String ipAddress = this.ipAddressTextField.getText();
        boolean ipAddressValid = PATTERN.matcher(ipAddress).matches();
        this.connectButton.setEnabled(ipAddressValid);
        this.sendButton.setEnabled(ipAddressValid && !"".equals(this.macroNameTextField.getText()));
    }

    private void ipAddressTextFieldKeyTyped(KeyEvent evt) {
        char c = evt.getKeyChar();
        if ((c < '0' || c > '9') && c != '.' && c != '\b') {
            evt.consume();
        }
    }

    private byte[] getSendBytes(byte[] commandBytes) {
        ByteBuffer dbuf = ByteBuffer.allocate(5 + commandBytes.length);
        dbuf.put((byte)1);
        dbuf.putShort((short)commandBytes.length);
        dbuf.putShort((short)-1);
        dbuf.put(commandBytes);
        return dbuf.array();
    }

    private byte[] getCommandBytes(String macroName) {
        ByteBuffer dbuf = ByteBuffer.allocate(10 + macroName.length());
        dbuf.put((byte)-1);
        String command = "macro";
        dbuf.put((byte)command.length());
        dbuf.put(command.getBytes());
        dbuf.put((byte)1);
        dbuf.put((byte)0);
        dbuf.put((byte)macroName.length());
        dbuf.put(macroName.getBytes());
        return dbuf.array();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MacroExecutionDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MacroExecutionDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MacroExecutionDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MacroExecutionDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MacroExecutionDialog dialog = new MacroExecutionDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

