/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.menus;

import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.supporter.AppLogger;
import com.integ.supporter.OpenTelnetConsole;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.ui.dialogs.JniorSelectionDialog;
import java.awt.Frame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class ToolsMenu
extends JMenu {
    public ToolsMenu() {
        super("Tools");
        this.initMenu();
    }

    private void initMenu() {
        this.addOpenCommandLine();
        this.addOpenTelnet();
    }

    private void addOpenCommandLine() {
        JMenuItem menuItem = new JMenuItem("Open Command Line...");
        menuItem.addActionListener(evt -> {
            AppLogger.getLogger().info(String.format("user selected %s", evt.getActionCommand()));
            new Thread(){

                @Override
                public void run() {
                    OpenTelnetConsole openTelnetConsole = new OpenTelnetConsole("");
                    openTelnetConsole.execute();
                }
            }.start();
        });
        super.add(menuItem);
    }

    private void addOpenTelnet() {
        JMenuItem menuItem = new JMenuItem("Open Telnet...");
        menuItem.addActionListener(evt -> {
            AppLogger.getLogger().info(String.format("user selected %s", evt.getActionCommand()));
            JniorSelectionDialog dlg = new JniorSelectionDialog((Frame)SupporterMain.getMainFrame(), true);
            dlg.setVisible(true);
            JniorInfo[] selectedJniors = dlg.getSelectedJniors();
            if (null != selectedJniors && 0 < selectedJniors.length) {
                for (final JniorInfo jniorInfo : selectedJniors) {
                    new Thread(){

                        @Override
                        public void run() {
                            String ipAddress = jniorInfo.IpAddress + ":23";
                            OpenTelnetConsole openTelnetConsole = new OpenTelnetConsole(ipAddress);
                            openTelnetConsole.execute();
                        }
                    }.start();
                }
            }
        });
        super.add(menuItem);
    }
}

