/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.jtreetable;

import com.integ.supporter.ui.jtreetable.TreeTableModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeTableModel
implements TreeTableModel {
    protected Object root;
    protected EventListenerList listenerList = new EventListenerList();
    private static final int CHANGED = 0;
    private static final int INSERTED = 1;
    private static final int REMOVED = 2;
    private static final int STRUCTURE_CHANGED = 3;

    public AbstractTreeTableModel(Object root) {
        this.root = root;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        int children = this.getChildCount(node);
        return children == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return 0;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    private void fireTreeNode(int changeType, Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = new TreeModelEvent(source, path, childIndices, children);
        block6: for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            switch (changeType) {
                case 0: {
                    ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
                    continue block6;
                }
                case 1: {
                    ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
                    continue block6;
                }
                case 2: {
                    ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
                    continue block6;
                }
                case 3: {
                    ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
                    continue block6;
                }
            }
        }
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        this.fireTreeNode(0, source, path, childIndices, children);
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        this.fireTreeNode(1, source, path, childIndices, children);
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        this.fireTreeNode(2, source, path, childIndices, children);
    }

    public void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        this.fireTreeNode(3, source, path, childIndices, children);
    }
}

