/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.beacon.dialogs;

import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.ui.dialogs.IPAddressFormattedTextField;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class ConfigurationDialog
extends JDialog {
    private JniorInfo _jniorInfo = null;
    private JButton btnCancel;
    private JButton btnOK;
    private JComboBox<String> cmbTimeZone;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel lblMacAddress;
    private JLabel lblSerialNumber;
    private JPanel pnlIpAddress1;
    private JPanel pnlIpAddress2;
    private JRadioButton rbUseDhcp;
    private JRadioButton rbUseStaticAddress;
    private JTextField txtDnsTimeout;
    private JTextField txtDomainName;
    private IPAddressFormattedTextField txtGateway;
    private IPAddressFormattedTextField txtIpAddress;
    private IPAddressFormattedTextField txtPrimaryDnsAddress;
    private IPAddressFormattedTextField txtSecondaryDnsAddress;
    private IPAddressFormattedTextField txtSubnetMask;

    public ConfigurationDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public void setJniorInfo(JniorInfo jniorInfo) {
        this._jniorInfo = jniorInfo;
        this.lblSerialNumber.setText(String.valueOf(jniorInfo.getSerialNumber()));
        this.lblMacAddress.setText(jniorInfo.PhysicalAddress);
        this.setControlEnabledForDhcp();
        this.txtIpAddress.setText(jniorInfo.IpAddress);
        this.txtSubnetMask.setText(jniorInfo.SubnetMask);
        this.txtGateway.setText(jniorInfo.Gateway);
        this.txtPrimaryDnsAddress.setText(jniorInfo.PrimaryDns);
        this.txtSecondaryDnsAddress.setText(jniorInfo.SecondaryDns);
        this.txtDnsTimeout.setText(String.valueOf(jniorInfo.DnsTimeout));
        this.txtDomainName.setText(jniorInfo.DomainName);
        try {
            ComboBoxModel<String> model = this.cmbTimeZone.getModel();
            int size = model.getSize();
            for (int i = 0; i < size; ++i) {
                String element = (String)model.getElementAt(i);
                if (!element.startsWith(jniorInfo.Timezone)) continue;
                this.cmbTimeZone.setSelectedIndex(i);
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public JniorInfo getJniorInfo() {
        if (null != this._jniorInfo) {
            this._jniorInfo.DhcpEnabled = this.rbUseDhcp.isSelected();
            this._jniorInfo.IpAddress = this.txtIpAddress.getText();
            this._jniorInfo.SubnetMask = this.txtSubnetMask.getText();
            this._jniorInfo.Gateway = this.txtGateway.getText();
            this._jniorInfo.PrimaryDns = this.txtPrimaryDnsAddress.getText();
            this._jniorInfo.SecondaryDns = this.txtSecondaryDnsAddress.getText();
            this._jniorInfo.DnsTimeout = Integer.parseInt(this.txtDnsTimeout.getText());
            this._jniorInfo.DomainName = this.txtDomainName.getText();
            String newTimezone = (String)this.cmbTimeZone.getSelectedItem();
            this._jniorInfo.Timezone = newTimezone = newTimezone.substring(0, newTimezone.indexOf(" "));
        }
        return this._jniorInfo;
    }

    private void setControlEnabledForDhcp() {
        this.rbUseDhcp.setSelected(this._jniorInfo.DhcpEnabled);
        this.rbUseStaticAddress.setSelected(!this._jniorInfo.DhcpEnabled);
        this.txtIpAddress.setEnabled(!this._jniorInfo.DhcpEnabled);
        this.txtSubnetMask.setEnabled(!this._jniorInfo.DhcpEnabled);
        this.txtGateway.setEnabled(!this._jniorInfo.DhcpEnabled);
        this.txtPrimaryDnsAddress.setEnabled(!this._jniorInfo.DhcpEnabled);
        this.txtSecondaryDnsAddress.setEnabled(!this._jniorInfo.DhcpEnabled);
        this.txtDnsTimeout.setEnabled(!this._jniorInfo.DhcpEnabled);
    }

    private void initComponents() {
        this.lblSerialNumber = new JLabel();
        this.lblMacAddress = new JLabel();
        this.rbUseDhcp = new JRadioButton();
        this.rbUseStaticAddress = new JRadioButton();
        this.pnlIpAddress1 = new JPanel();
        this.txtGateway = new IPAddressFormattedTextField();
        this.txtSubnetMask = new IPAddressFormattedTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.txtIpAddress = new IPAddressFormattedTextField();
        this.btnOK = new JButton();
        this.btnCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.pnlIpAddress2 = new JPanel();
        this.txtSecondaryDnsAddress = new IPAddressFormattedTextField();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.txtPrimaryDnsAddress = new IPAddressFormattedTextField();
        this.txtDnsTimeout = new JTextField();
        this.jLabel11 = new JLabel();
        this.txtDomainName = new JTextField();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.cmbTimeZone = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("IP Configuration");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ConfigurationDialog.this.formWindowClosing(evt);
            }
        });
        this.lblSerialNumber.setText("000000000");
        this.lblMacAddress.setText("9C:8D:1A:00:00:00");
        this.rbUseDhcp.setText("Use DHCP");
        this.rbUseDhcp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationDialog.this.rbUseDhcpActionPerformed(evt);
            }
        });
        this.rbUseStaticAddress.setText("Use Static Address");
        this.rbUseStaticAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationDialog.this.rbUseStaticAddressActionPerformed(evt);
            }
        });
        this.pnlIpAddress1.setBorder(BorderFactory.createEtchedBorder());
        this.pnlIpAddress1.setName("");
        this.txtGateway.setText("255.255.255.255");
        this.txtSubnetMask.setText("0.0.0.0");
        this.jLabel5.setText("Subnet Mask");
        this.jLabel6.setText("Gateway");
        this.jLabel7.setText("IP Address");
        this.txtIpAddress.setText("0.0.0.0");
        GroupLayout pnlIpAddress1Layout = new GroupLayout(this.pnlIpAddress1);
        this.pnlIpAddress1.setLayout(pnlIpAddress1Layout);
        pnlIpAddress1Layout.setHorizontalGroup(pnlIpAddress1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlIpAddress1Layout.createSequentialGroup().addContainerGap().addGroup(pnlIpAddress1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel7).addComponent(this.jLabel6)).addGroup(pnlIpAddress1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlIpAddress1Layout.createSequentialGroup().addGap(18, 18, 18).addGroup(pnlIpAddress1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtIpAddress, -1, 100, Short.MAX_VALUE).addComponent(this.txtSubnetMask, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, pnlIpAddress1Layout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.txtGateway, -2, 99, -2))).addContainerGap(20, Short.MAX_VALUE)));
        pnlIpAddress1Layout.setVerticalGroup(pnlIpAddress1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlIpAddress1Layout.createSequentialGroup().addContainerGap().addGroup(pnlIpAddress1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.txtIpAddress, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnlIpAddress1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.txtSubnetMask, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnlIpAddress1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.txtGateway, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.btnOK.setText("OK");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationDialog.this.btnOKActionPerformed(evt);
            }
        });
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Serial Number:");
        this.jLabel2.setText("MAC Address:");
        this.pnlIpAddress2.setBorder(BorderFactory.createEtchedBorder());
        this.txtSecondaryDnsAddress.setText("0.0.0.0");
        this.jLabel8.setText("Secondary DNS");
        this.jLabel9.setText("DNS Timeout");
        this.jLabel10.setText("Primary DNS");
        this.txtPrimaryDnsAddress.setText("0.0.0.0");
        this.txtDnsTimeout.setText("5000");
        GroupLayout pnlIpAddress2Layout = new GroupLayout(this.pnlIpAddress2);
        this.pnlIpAddress2.setLayout(pnlIpAddress2Layout);
        pnlIpAddress2Layout.setHorizontalGroup(pnlIpAddress2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlIpAddress2Layout.createSequentialGroup().addContainerGap().addGroup(pnlIpAddress2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.jLabel10).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnlIpAddress2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.txtSecondaryDnsAddress, GroupLayout.Alignment.LEADING, -1, 100, Short.MAX_VALUE).addComponent(this.txtPrimaryDnsAddress, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.txtDnsTimeout)).addGap(0, 9, Short.MAX_VALUE)));
        pnlIpAddress2Layout.setVerticalGroup(pnlIpAddress2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlIpAddress2Layout.createSequentialGroup().addContainerGap().addGroup(pnlIpAddress2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.txtPrimaryDnsAddress, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnlIpAddress2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.txtSecondaryDnsAddress, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnlIpAddress2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.txtDnsTimeout, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel11.setText("Domain Name");
        this.jLabel12.setText("example, integpg.com");
        this.jLabel13.setText("Time Zone");
        this.cmbTimeZone.setModel(new DefaultComboBoxModel<String>(new String[]{"IDLW (-1200) Date_Line", "WST  (-1100) Pacific/Midway", "HST  (-1000) Pacific/Honolulu", "AKST (-0900) America/Anchorage(1)", "PST  (-0800) America/Los_Angeles(1)", "MST  (-0700) America/Denver(1)", "CST  (-0600) America/Chicago(1)", "IET  (-0500) America/Indianapolis", "EST  (-0500) America/New_York(1)", "PRT  (-0400) America/Caracas", "CNT  (-0330) America/St_Johns(1)", "AGT  (-0300) Argentina/Buenos_Aires", "BET  (-0300) Brazil/Brasilia", "MAT  (-0200) Atlantic/Mid", "CAT  (-0100) Atlantic/Cape_Verde", "GMT  (+0000) Greenwich_Mean", "UTC  (+0000) Universal_Coordinated", "WET  (+0000) Western European(5)", "CET  (+0100) Central European(4)", "EET  (+0200) Eastern European(3)", "EAT  (+0300) Asia/Riyadh", "MET  (+0330) Iran/Tehran", "NET  (+0400) Russia/Moscow", "AFT  (+0430) Afghanistan/Kabul", "PLT  (+0500) Russia/Ural_Mountains", "IST  (+0530) India", "ALMT (+0600) Asia/Alma-Ata", "CIT  (+0630) Burma", "VST  (+0700) Mongolia/West", "AWST (+0800) Australia/Perth", "JST  (+0900) Japan", "ACST (+0930) Australia/Adelaide(2)", "AEST (+1000) Australia/Sydney(2)", "LHT  (+1030) Lord Howe Island", "SST  (+1100) Russia/East", "NIT  (+1130) Norfolk Island", "NST  (+1200) Pacific/Fiji"}));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(4, 4, 4).addComponent(this.lblSerialNumber)).addComponent(this.rbUseDhcp).addComponent(this.rbUseStaticAddress).addGroup(layout.createSequentialGroup().addComponent(this.pnlIpAddress1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlIpAddress2, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMacAddress)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtDomainName, -2, 101, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel12)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel13).addGap(18, 18, 18).addComponent(this.cmbTimeZone, 0, -1, Short.MAX_VALUE))).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSerialNumber).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.lblMacAddress)).addGap(21, 21, 21).addComponent(this.rbUseDhcp).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rbUseStaticAddress).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.pnlIpAddress2, -1, -1, Short.MAX_VALUE).addComponent(this.pnlIpAddress1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtDomainName, -2, -1, -2).addComponent(this.jLabel11).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.cmbTimeZone, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 12, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOK).addComponent(this.btnCancel)).addContainerGap()));
        this.pack();
    }

    private void rbUseDhcpActionPerformed(ActionEvent evt) {
        this._jniorInfo.DhcpEnabled = true;
        this.setControlEnabledForDhcp();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this._jniorInfo = null;
        this.setVisible(false);
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void rbUseStaticAddressActionPerformed(ActionEvent evt) {
        this._jniorInfo.DhcpEnabled = false;
        this.setControlEnabledForDhcp();
    }

    private void formWindowClosing(WindowEvent evt) {
        this._jniorInfo = null;
        this.setVisible(false);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            String stacktrace = ExceptionUtils.getStackTrace(ex);
            Logger.getLogger(ConfigurationDialog.class.getName()).severe(stacktrace);
        }
        catch (InstantiationException ex) {
            String stacktrace = ExceptionUtils.getStackTrace(ex);
            Logger.getLogger(ConfigurationDialog.class.getName()).severe(stacktrace);
        }
        catch (IllegalAccessException ex) {
            String stacktrace = ExceptionUtils.getStackTrace(ex);
            Logger.getLogger(ConfigurationDialog.class.getName()).severe(stacktrace);
        }
        catch (UnsupportedLookAndFeelException ex) {
            String stacktrace = ExceptionUtils.getStackTrace(ex);
            Logger.getLogger(ConfigurationDialog.class.getName()).severe(stacktrace);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfigurationDialog dialog = new ConfigurationDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

