/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.collections;

import com.integ.supporter.CollectionModifiedEvent;
import com.integ.supporter.CollectionModifiedListener;
import java.util.ArrayList;

public class ObservableCollection<E>
extends ArrayList<E> {
    private final ArrayList<CollectionModifiedListener> _collectionListeners = new ArrayList();

    public void addCollectionListener(CollectionModifiedListener collectionListener) {
        if (!this._collectionListeners.contains(collectionListener)) {
            this._collectionListeners.add(collectionListener);
            if (!super.isEmpty()) {
                for (int i = 0; i < super.size(); ++i) {
                    Object item = super.get(i);
                    CollectionModifiedEvent collectionModifiedEvent = new CollectionModifiedEvent(this);
                    collectionListener.itemAdded(collectionModifiedEvent, item);
                    collectionListener.collectionModified(collectionModifiedEvent);
                }
            }
        }
    }

    @Override
    public boolean add(E item) {
        boolean b = super.add(item);
        CollectionModifiedEvent collectionModifiedEvent = new CollectionModifiedEvent(this);
        for (CollectionModifiedListener collectionModifiedListener : this._collectionListeners) {
            collectionModifiedListener.itemAdded(collectionModifiedEvent, item);
            collectionModifiedListener.collectionModified(collectionModifiedEvent);
        }
        return b;
    }

    @Override
    public E remove(int index) {
        Object item = super.remove(index);
        CollectionModifiedEvent collectionModifiedEvent = new CollectionModifiedEvent(this);
        for (CollectionModifiedListener collectionModifiedListener : this._collectionListeners) {
            collectionModifiedListener.itemRemoved(collectionModifiedEvent, item);
            collectionModifiedListener.collectionModified(collectionModifiedEvent);
        }
        return item;
    }

    @Override
    public boolean remove(Object item) {
        boolean b = super.remove(item);
        CollectionModifiedEvent collectionModifiedEvent = new CollectionModifiedEvent(this);
        for (CollectionModifiedListener collectionModifiedListener : this._collectionListeners) {
            collectionModifiedListener.itemRemoved(collectionModifiedEvent, item);
            collectionModifiedListener.collectionModified(collectionModifiedEvent);
        }
        return b;
    }

    @Override
    public void clear() {
        super.clear();
        CollectionModifiedEvent collectionModifiedEvent = new CollectionModifiedEvent(this);
        for (CollectionModifiedListener collectionModifiedListener : this._collectionListeners) {
            collectionModifiedListener.collectionCleared(collectionModifiedEvent);
            collectionModifiedListener.collectionModified(collectionModifiedEvent);
        }
    }
}

