/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.snapshot;

import java.util.ArrayList;

public class FileInfo {
    private final String _name;
    private final ArrayList<FileInfo> _children = new ArrayList();
    private String _path = "";
    private FileInfo _parent = null;

    public FileInfo(String name) {
        this._name = name;
        this._path = name;
    }

    public String getName() {
        return this._name;
    }

    public ArrayList<FileInfo> getChildren() {
        return this._children;
    }

    public ArrayList<FileInfo> getFiles() {
        ArrayList<FileInfo> files = new ArrayList<FileInfo>();
        for (FileInfo child : this._children) {
            if (child.isDirectory()) continue;
            files.add(child);
        }
        return files;
    }

    public ArrayList<FileInfo> getDirectories() {
        ArrayList<FileInfo> directories = new ArrayList<FileInfo>();
        for (FileInfo child : this._children) {
            if (!child.isDirectory()) continue;
            directories.add(child);
        }
        return directories;
    }

    public FileInfo getParent() {
        return this._parent;
    }

    public void setParent(FileInfo parentFileInfo) {
        this._parent = parentFileInfo;
        this._path = parentFileInfo.getPath() + this._name;
    }

    public String getPath() {
        return this._path;
    }

    public void addChild(FileInfo fileInfo) {
        this._children.add(fileInfo);
        fileInfo.setParent(this);
    }

    public boolean isDirectory() {
        return this._name.endsWith("/");
    }

    public String toString() {
        return String.format("%s : %d children", this._path, this._children.size());
    }
}

