/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.ResourceUtils;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.ui.OutputTab;
import com.integ.supporter.ui.TextPaneLog;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.io.File;
import java.net.URL;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class SupporterUtilities {
    private static TrayIcon TRAY_ICON;

    public static void playSound(String soundFileName) {
        try {
            String tempFilePath = String.format("%s/%d_%s", SupporterMain.getTempDirectory(), System.currentTimeMillis(), soundFileName);
            File tempAudioFile = new File(tempFilePath);
            ResourceUtils.extractResource("/resources/" + soundFileName, tempAudioFile);
            AudioInputStream stream = AudioSystem.getAudioInputStream(tempAudioFile);
            AudioFormat format = stream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(stream);
            clip.start();
        }
        catch (Exception ex) {
            Logger.getGlobal().severe(String.format("error playing '%s' sound: %s", soundFileName, ex.getMessage()));
        }
    }

    public static void initTrayIcon() {
        if (SystemTray.isSupported()) {
            try {
                SystemTray tray = SystemTray.getSystemTray();
                URL iconURL = SupporterMain.getInstance().getClass().getResource("/resources/integ.png");
                ImageIcon icon = new ImageIcon(iconURL);
                TRAY_ICON = new TrayIcon(icon.getImage(), "JNIOR Supporter");
                TRAY_ICON.setImageAutoSize(true);
                tray.add(TRAY_ICON);
            }
            catch (Exception ex) {
                Logger.getGlobal().severe(ExceptionUtils.getStackTrace(ex));
            }
        }
    }

    public static void displayMessage(String caption, String text, TrayIcon.MessageType messageType) {
    }

    public static void showError(String message) {
        String logMessage = message;
        TextPaneLog textPaneLog = new TextPaneLog(OutputTab.getInstance().getTextPane());
        textPaneLog.publish(logMessage);
        Logger.getGlobal().severe(logMessage);
        SupporterUtilities.showError(message, "Error!");
    }

    public static void showError(String message, Exception exception) {
        String stackTrace = ExceptionUtils.getStackTrace(exception);
        String logMessage = String.format("%s\nStack Trace: %s", message, stackTrace);
        TextPaneLog textPaneLog = new TextPaneLog(OutputTab.getInstance().getTextPane());
        textPaneLog.publish(logMessage);
        Logger.getGlobal().severe(logMessage);
        String errorMessage = "Message: " + exception.getMessage() + "\nStack Trace: " + stackTrace;
        SupporterUtilities.showError(errorMessage, message);
    }

    public static void showError(String errorMessage, String title) {
        JOptionPane.showMessageDialog(null, errorMessage, title, 0);
    }
}

