/*
 * Decompiled with CFR 0.152.
 */
package com.integ.websocket.messages;

import com.integ.websocket.messages.JniorMessage;
import java.util.Base64;

public class FileWrite
extends JniorMessage {
    private final String _filename;

    public FileWrite(String remotePath, byte[] fileContentBytes, int byteReadCount) {
        super("File Write");
        this._filename = remotePath;
        super.put("File", remotePath);
        super.put("Encoding", "base64");
        byte[] bytes = new byte[byteReadCount];
        System.arraycopy(fileContentBytes, 0, bytes, 0, byteReadCount);
        String encodedString = Base64.getEncoder().encodeToString(bytes);
        super.put("Data", encodedString);
        super.put("Size", this.calcBase64SizeInBytes(encodedString));
        super.put("Mod", System.currentTimeMillis());
    }

    public String getFilename() {
        return this._filename;
    }

    private int calcBase64SizeInBytes(String base64String) {
        double length = -1.0;
        if (null != base64String) {
            int padding = 0;
            if (base64String.endsWith("==")) {
                padding = 2;
            } else if (base64String.endsWith("=")) {
                padding = 1;
            }
            length = Math.floor(base64String.length() / 4) * 3.0 - (double)padding;
        }
        return (int)length;
    }
}

