/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater.steps;

import com.integ.janoslib.utils.ZipUtils;
import com.integ.supporter.updater.JanosUpd;
import com.integ.supporter.updater.steps.FtpStep;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UpdateSeries4OSStep
extends FtpStep {
    protected String _version = "";

    public UpdateSeries4OSStep(String name) {
        super(name);
        this._type = "UpdateSeries4OSProperty";
    }

    public UpdateSeries4OSStep(Element xmlElement) {
        super(xmlElement);
        this._version = this.getChildNodeString("Version");
        System.out.println("Version: " + this._version);
    }

    @Override
    public void setAbsoluteFilePath(String localFileString) {
        super.setAbsoluteFilePath(localFileString);
        File localFile = new File(localFileString);
        JanosUpd.JanosFileInformation janosFileInformation = JanosUpd.getInformation(localFile);
        this.setVersion(janosFileInformation.Version);
    }

    public String getVersion() {
        return this._version;
    }

    void setVersion(String version) {
        String oldVersion = this._version;
        this._version = version;
        this._changes.firePropertyChange("Version", oldVersion, version);
    }

    @Override
    public Element getXmlElement(Document document) {
        Element xmlElement = super.getXmlElement(document);
        Element element = document.createElement("Version");
        element.appendChild(document.createTextNode(this._version));
        xmlElement.appendChild(element);
        return xmlElement;
    }

    @Override
    public boolean execute() throws Exception {
        String buildTag;
        String remoteVersion;
        int equalPos;
        this._force = true;
        if (4 != this._jniorInfo.getSeries()) {
            throw new RuntimeException("The target JNIOR is not a series 4 jnior");
        }
        String localVersion = this.getVersion();
        ZipEntry zipEntry = this._updateProjectFile.getEntryForFile(this._localFile);
        if (null != zipEntry) {
            byte[] fileContentBytes = ZipUtils.extractEntry(this._updateProjectFile.getFilePath(), zipEntry.getName());
            JanosUpd.JanosFileInformation janosUpdInformation = JanosUpd.getInformation(fileContentBytes);
            localVersion = JanosUpd.getVersionFromBuildTag(janosUpdInformation.BuildTag);
        }
        if (-1 != (equalPos = (remoteVersion = this._jniorUpdateControlConnection.exec("registry $version")).indexOf("="))) {
            remoteVersion = remoteVersion.substring(equalPos + 1);
            remoteVersion = remoteVersion.trim();
            this._logger.info(String.format("  remote version: %s", remoteVersion));
        }
        if (!"".equals(buildTag = this._jniorUpdateControlConnection.exec("registry $buildtag")) && !buildTag.contains("not defined")) {
            remoteVersion = JanosUpd.getVersionFromBuildTag(buildTag);
        }
        this._logger.info(String.format("    local version: %s, remote version: %s", localVersion, remoteVersion));
        if (remoteVersion.equalsIgnoreCase(localVersion)) {
            this._summary = "  JANOS " + this._version + " already installed";
            this._logger.info(this._summary);
            return true;
        }
        super.execute();
        String jrupdateCommand = "jrupdate -fup " + this._remotePath;
        this._logger.info(jrupdateCommand);
        long start = System.currentTimeMillis();
        this._jniorUpdateControlConnection.exec(jrupdateCommand, 600000);
        long elapsed = System.currentTimeMillis() - start;
        this._logger.info(String.format("  jrupdate took %.2f seconds", (double)elapsed / 1000.0));
        this._summary = "JANOS updated to " + this._version;
        try {
            this._jniorUpdateControlConnection.disconnect();
        }
        catch (IOException ex) {
            Logger.getLogger(UpdateSeries4OSStep.class.getName()).severe(ex.getMessage());
        }
        Thread.sleep(20000L);
        int retry = 3;
        do {
            Thread.sleep(10000L);
        } while (!this._jniorUpdateControlConnection.connect() && 0 < --retry);
        return 0 < retry;
    }
}

