/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater;

import com.integ.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.RollingLog;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.dialogs.JniorSelectionDialog;
import com.integ.supporter.ui.CheckBoxNodeData;
import com.integ.supporter.ui.CheckBoxNodeEditor;
import com.integ.supporter.ui.CheckBoxNodeRenderer;
import com.integ.supporter.ui.PercentageTabbedPaneUI;
import com.integ.supporter.ui.TreeNodesChangedListener;
import com.integ.supporter.updater.JniorUpdateInProgressCollection;
import com.integ.supporter.updater.JniorUpdateTab;
import com.integ.supporter.updater.UpdateProjectEditorDialog;
import com.integ.supporter.updater.UpdateProjectExecutor;
import com.integ.supporter.updater.UpdateProjectFile;
import com.integ.supporter.updater.UpdateProjectListener;
import com.integ.supporter.updater.UpdateProjectPopupMenu;
import com.integ.supporter.updater.steps.ProjectStep;
import com.integ.supporter.updater.steps.ProjectStepFactory;
import com.integ.supporter.updater.steps.UnknownStepException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class UpdateTab
extends JPanel
implements UpdateProjectListener {
    public static final String UPDATE_PROJECTS_FOLDER = SupporterMain.SUPPORTER_DIRECTORY + "Update Projects/";
    public static final Logger LOGGER = RollingLog.getLogger("UpdateTab");
    private UpdateProjectFile _updateProjectFile;
    private final JMenuItem _abortMenuItem = new JMenuItem("Abort");
    private final JMenuItem _removeTabMenuItem = new JMenuItem("Remove Tab");
    private final JMenuItem _removeAllCompletedTabsMenuItem = new JMenuItem("Remove All Completed Tabs");
    private final JniorUpdateInProgressCollection _jniorUpdateInProgressCollection = new JniorUpdateInProgressCollection();
    private JButton abortToolbarButton;
    private JButton closeToolbarButton;
    private JButton editToolbarButton;
    private JButton jButton1;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JToolBar.Separator jSeparator1;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane1;
    private JToolBar jToolBar1;
    private JTree jTree1;
    private JLabel lblProjectFileName;
    private JButton publishToolbarButton;
    private JTabbedPane updatesTabPane;

    public UpdateTab(UpdateProjectFile updateProjectFile) {
        this.initComponents();
        this.addTabChangeListener();
        JPopupMenu tabbedPanePopupMenu = this.createTabbedPanePopupMenu();
        this.updatesTabPane.setComponentPopupMenu(tabbedPanePopupMenu);
        this.updatesTabPane.setUI(new PercentageTabbedPaneUI());
        this._updateProjectFile = updateProjectFile;
        LOGGER.info("Loading " + this._updateProjectFile.getFilePath());
        this.lblProjectFileName.setText(this._updateProjectFile.getFilePath());
        DefaultMutableTreeNode root = this.loadSteps();
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.jTree1.setModel(treeModel);
        treeModel.addTreeModelListener(new TreeNodesChangedListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                if (null == e.getChildren()) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath()[0];
                    CheckBoxNodeData nodeUserObject = (CheckBoxNodeData)node.getUserObject();
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
                        Object childNodeUserObject = childNode.getUserObject();
                        if (!(childNodeUserObject instanceof CheckBoxNodeData)) continue;
                        CheckBoxNodeData projectStepNodeData = (CheckBoxNodeData)childNodeUserObject;
                        projectStepNodeData.setChecked(nodeUserObject.isChecked());
                    }
                }
                System.out.println(System.currentTimeMillis() + ": nodes changed");
            }
        });
        CheckBoxNodeRenderer renderer = new CheckBoxNodeRenderer();
        this.jTree1.setCellRenderer(renderer);
        CheckBoxNodeEditor editor = new CheckBoxNodeEditor(this.jTree1);
        this.jTree1.setCellEditor(editor);
        this.jTree1.setEditable(true);
        this.addPopupMenu();
        this.updatesTabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                UpdateTab.this.updateMenuStatus();
            }
        });
    }

    private void addTabChangeListener() {
        this.updatesTabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JniorUpdateTab jniorUpdateTab = (JniorUpdateTab)UpdateTab.this.updatesTabPane.getSelectedComponent();
                UpdateTab.this.abortToolbarButton.setEnabled(jniorUpdateTab.isRunning());
            }
        });
    }

    private static DefaultMutableTreeNode add(DefaultMutableTreeNode parent, ProjectStep projectStep, boolean checked) {
        CheckBoxNodeData data = new CheckBoxNodeData(projectStep, checked);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(data);
        parent.add(node);
        return node;
    }

    @Override
    public void loginFailed() {
        JOptionPane.showConfirmDialog(this, "Login Failed", "Login Failed", 0);
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateProjectStepResult(ProjectStep projectStep, boolean result, int index, int total) {
    }

    @Override
    public void updateProjectResult(UpdateProjectExecutor updateProjectExecutor, boolean result) {
        boolean updateInProgress = this.isUpdateInProgress();
        this.closeToolbarButton.setEnabled(!updateInProgress);
        this.publishToolbarButton.setEnabled(!updateInProgress);
        JniorUpdateTab selectedUpdateTab = this.getSelectedJniorUpdateTab();
        this.abortToolbarButton.setEnabled(selectedUpdateTab.isRunning());
        this._jniorUpdateInProgressCollection.removeUpdate(updateProjectExecutor.getJniorInfo());
    }

    private JPopupMenu createTabbedPanePopupMenu() {
        System.out.println(String.format("%s create popup menu", this.getClass().getName()));
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setMinimumSize(new Dimension(200, 1));
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                System.out.println(String.format("%s popup will become visible", this.getClass().getName()));
                Component selectedTabComponent = UpdateTab.this.updatesTabPane.getSelectedComponent();
                JniorUpdateTab selectedJniorUpdateTab = null != selectedTabComponent ? (JniorUpdateTab)selectedTabComponent : null;
                boolean abortAllowed = null != selectedJniorUpdateTab && selectedJniorUpdateTab.isRunning();
                UpdateTab.this._abortMenuItem.setEnabled(abortAllowed);
                boolean removeTabAllowed = null != selectedJniorUpdateTab && !selectedJniorUpdateTab.isRunning();
                UpdateTab.this._removeTabMenuItem.setEnabled(removeTabAllowed);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this._abortMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateTab.this.abortCurrentUpdate();
            }
        });
        popupMenu.add(this._abortMenuItem);
        this._removeTabMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component selectedTabComponent = UpdateTab.this.updatesTabPane.getSelectedComponent();
                UpdateTab.this.updatesTabPane.remove(selectedTabComponent);
            }
        });
        popupMenu.add(this._removeTabMenuItem);
        this._removeAllCompletedTabsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int totalTabs = UpdateTab.this.updatesTabPane.getTabCount();
                for (int i = 0; i < totalTabs; ++i) {
                    Component updateTabComponent = UpdateTab.this.updatesTabPane.getTabComponentAt(i);
                    UpdateTab.this.updatesTabPane.remove(updateTabComponent);
                }
            }
        });
        popupMenu.add(this._removeTabMenuItem);
        return popupMenu;
    }

    private void abortCurrentUpdate() {
        JniorUpdateTab jniorUpdateTab = this.getSelectedJniorUpdateTab();
        if (null != jniorUpdateTab) {
            jniorUpdateTab.abort();
        }
    }

    private void updateMenuStatus() {
        this.closeToolbarButton.setEnabled(!this.isUpdateInProgress());
        JniorUpdateTab jniorUpdateTab = this.getSelectedJniorUpdateTab();
        boolean isRunning = jniorUpdateTab.isRunning();
        this.publishToolbarButton.setEnabled(!isRunning);
        this.abortToolbarButton.setEnabled(isRunning);
    }

    public boolean isUpdateInProgress() {
        JniorUpdateTab jniorUpdateTab;
        boolean running = false;
        for (int i = 0; running && i < this.updatesTabPane.getComponentCount(); running |= jniorUpdateTab.isRunning(), ++i) {
            jniorUpdateTab = (JniorUpdateTab)this.updatesTabPane.getComponent(i);
        }
        return running;
    }

    public JniorUpdateTab getSelectedJniorUpdateTab() {
        int selectedIndex = this.updatesTabPane.getSelectedIndex();
        return -1 != selectedIndex ? (JniorUpdateTab)this.updatesTabPane.getSelectedComponent() : null;
    }

    public void close() {
        LOGGER.info("Close " + this._updateProjectFile.getFilePath());
        JTabbedPane tabbedPane = SupporterMain.getTabPane();
        tabbedPane.setSelectedIndex(0);
        tabbedPane.remove(this);
    }

    public void publish(JniorInfo targetJniorInfo) throws IOException {
        if (!this._jniorUpdateInProgressCollection.isJniorInProgress(targetJniorInfo)) {
            ArrayList<ProjectStep> selectedSteps = new ArrayList<ProjectStep>();
            DefaultTreeModel model = (DefaultTreeModel)this.jTree1.getModel();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
            for (int i = 0; i < root.getChildCount(); ++i) {
                CheckBoxNodeData checkBoxNodeData;
                boolean isChecked;
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)root.getChildAt(i);
                Object childNodeUserObject = childNode.getUserObject();
                if (!(childNodeUserObject instanceof CheckBoxNodeData) || !(isChecked = (checkBoxNodeData = (CheckBoxNodeData)childNodeUserObject).isChecked())) continue;
                try {
                    ProjectStep projectStep = (ProjectStep)checkBoxNodeData.getObject();
                    ProjectStep clonedProjectStep = ProjectStepFactory.getProjectStep(projectStep.getXmlElement());
                    clonedProjectStep.setCheckedOnLoad(isChecked);
                    clonedProjectStep.setUpdateProject(this._updateProjectFile);
                    selectedSteps.add(clonedProjectStep);
                    continue;
                }
                catch (UnknownStepException ex) {
                    LOGGER.severe(ExceptionUtils.getStackTrace(ex));
                }
            }
            JniorUpdateTab jniorUpdateTab = new JniorUpdateTab(this._updateProjectFile.getFilePath(), targetJniorInfo, selectedSteps);
            jniorUpdateTab.setListener(this);
            this.updatesTabPane.insertTab("Update - " + targetJniorInfo.IpAddress, null, jniorUpdateTab, "Updating " + targetJniorInfo.IpAddress, 0);
            this.updatesTabPane.setSelectedComponent(jniorUpdateTab);
            UpdateProjectExecutor updateProjectExecutor = jniorUpdateTab.publish();
            this._jniorUpdateInProgressCollection.startUpdate(targetJniorInfo, updateProjectExecutor);
            this.updateMenuStatus();
        }
    }

    public int getUpdatesInProgressCount() {
        return this._jniorUpdateInProgressCollection.getInProgressCount();
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.closeToolbarButton = new JButton();
        this.editToolbarButton = new JButton();
        this.publishToolbarButton = new JButton();
        this.abortToolbarButton = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jLabel1 = new JLabel();
        this.lblProjectFileName = new JLabel();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane2 = new JScrollPane();
        this.jTree1 = new JTree();
        this.updatesTabPane = new JTabbedPane();
        this.jButton1.setText("jButton1");
        this.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new FlowLayout(0));
        this.jToolBar1.setBorder(null);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.closeToolbarButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/cancel.png")));
        this.closeToolbarButton.setText("Close");
        this.closeToolbarButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.closeToolbarButton.setFocusable(false);
        this.closeToolbarButton.setVerticalTextPosition(3);
        this.closeToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateTab.this.closeToolbarButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.closeToolbarButton);
        this.editToolbarButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/cog.png")));
        this.editToolbarButton.setText("Edit");
        this.editToolbarButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.editToolbarButton.setFocusable(false);
        this.editToolbarButton.setVerticalTextPosition(3);
        this.editToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateTab.this.editToolbarButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.editToolbarButton);
        this.publishToolbarButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/control_play_blue.png")));
        this.publishToolbarButton.setText("Publish");
        this.publishToolbarButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.publishToolbarButton.setFocusable(false);
        this.publishToolbarButton.setVerticalTextPosition(3);
        this.publishToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateTab.this.publishToolbarButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.publishToolbarButton);
        this.abortToolbarButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/stop.png")));
        this.abortToolbarButton.setText("Abort");
        this.abortToolbarButton.setToolTipText("Close");
        this.abortToolbarButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.abortToolbarButton.setEnabled(false);
        this.abortToolbarButton.setFocusable(false);
        this.abortToolbarButton.setVerticalTextPosition(3);
        this.abortToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateTab.this.abortToolbarButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.abortToolbarButton);
        this.jToolBar1.add(this.jSeparator1);
        this.jPanel1.add(this.jToolBar1);
        this.jLabel1.setText("Update Project File Name: ");
        this.jPanel1.add(this.jLabel1);
        this.lblProjectFileName.setText("jLabel2");
        this.jPanel1.add(this.lblProjectFileName);
        this.jPanel2.add((Component)this.jPanel1, "North");
        this.jSplitPane1.setDividerLocation(300);
        this.jSplitPane1.setMinimumSize(new Dimension(300, 25));
        this.jSplitPane1.setPreferredSize(new Dimension(300, 25));
        this.jScrollPane2.setViewportView(this.jTree1);
        this.jSplitPane1.setLeftComponent(this.jScrollPane2);
        this.updatesTabPane.setTabPlacement(4);
        this.jSplitPane1.setRightComponent(this.updatesTabPane);
        this.jPanel2.add((Component)this.jSplitPane1, "Center");
        this.add((Component)this.jPanel2, "Center");
    }

    private void closeToolbarButtonActionPerformed(ActionEvent evt) {
        this.close();
        SupporterMain.INSTANCE.updateClosed();
    }

    private void abortToolbarButtonActionPerformed(ActionEvent evt) {
        this.abortCurrentUpdate();
    }

    private void publishToolbarButtonActionPerformed(ActionEvent evt) {
        JniorSelectionDialog dlg = new JniorSelectionDialog(null, true);
        dlg.setMinimumSize(new Dimension(800, 600));
        dlg.setVisible(true);
        JniorInfo[] selectedJniors = dlg.getSelectedJniors();
        if (null != selectedJniors && 0 < selectedJniors.length) {
            for (JniorInfo selectedRemoteJniorInfo : selectedJniors) {
                try {
                    this.publish(selectedRemoteJniorInfo);
                }
                catch (IOException ex) {
                    Logger.getLogger(UpdateTab.class.getName()).severe(ex.getMessage());
                }
            }
        }
    }

    private void editToolbarButtonActionPerformed(ActionEvent evt) {
        this.showEditProjectDialog();
    }

    public void showEditProjectDialog() {
        try {
            UpdateProjectEditorDialog updateProjectEditorDialog = new UpdateProjectEditorDialog(null, true);
            updateProjectEditorDialog.setUpdateProject(this._updateProjectFile);
            int result = updateProjectEditorDialog.showEditorDialog();
            if (result == 0) {
                this._updateProjectFile = new UpdateProjectFile(updateProjectEditorDialog.getFile());
                this._updateProjectFile.load();
                DefaultMutableTreeNode root = this.loadSteps();
                DefaultTreeModel treeModel = new DefaultTreeModel(root);
                this.jTree1.setModel(treeModel);
                JTabbedPane tabbedPane = (JTabbedPane)this.getParent();
                int index = tabbedPane.getSelectedIndex();
                tabbedPane.setTitleAt(index, "Update - " + this._updateProjectFile.getTitle());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Logger.getLogger(UpdateTab.class.getName()).severe(ex.getMessage());
        }
    }

    private void addPopupMenu() {
        UpdateProjectPopupMenu popupMenu = new UpdateProjectPopupMenu(this);
    }

    private DefaultMutableTreeNode loadSteps() {
        CheckBoxNodeData data = new CheckBoxNodeData("Project Steps", true);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(data);
        ArrayList<ProjectStep> projectStepArrayList = this._updateProjectFile.getSteps();
        for (ProjectStep projectStep : projectStepArrayList) {
            LOGGER.info("Add " + projectStep.toString());
            UpdateTab.add(root, projectStep, projectStep.isCheckedOnLoad());
        }
        return root;
    }
}

